/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.util;

public class HexDump {
    private static final char[] lookup = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static void hexDump(String name, byte[] bs) {
        HexDump.hexDump(name, bs, 0, bs.length);
    }

    public static void hexDump(String name, byte[] bs, int len) {
        HexDump.hexDump(name, bs, 0, len);
    }

    public static void hexDump(String name, byte[] bs, int start, int len) {
        HexDump.hexDump(null, name, bs, start, len);
    }

    public static synchronized void hexDump(String prologue, String name, byte[] bs, int start, int len) {
        StringBuilder out = prologue == null ? new StringBuilder("Hexdump [" + name + "] size = " + len) : new StringBuilder(prologue + "\nHexdump [" + name + "] size = " + len);
        StringBuffer chars = new StringBuffer();
        for (int i2 = start; i2 < start + len; ++i2) {
            if ((i2 - start) % 16 == 0) {
                out.append(chars);
                out.append('\n');
                chars = new StringBuffer();
            }
            chars.append(HexDump.toAscii(bs[i2]));
            out.append(HexDump.toHexAndSpace(bs[i2]));
            if ((i2 - start) % 4 != 3) continue;
            chars.append(' ');
            out.append(' ');
        }
        if (len % 16 != 0) {
            int delta_bytes = 16 - len % 16;
            int pad = delta_bytes * 3;
            pad += delta_bytes / 4;
            for (int i3 = 0; i3 < pad; ++i3) {
                chars.insert(0, ' ');
            }
        }
        out.append(chars);
        System.out.println(out);
    }

    private static String toHexAndSpace(byte b) {
        int upper = b >> 4 & 0xF;
        int lower = b & 0xF;
        String sb = String.valueOf(lookup[upper]) + lookup[lower] + ' ';
        return sb;
    }

    public static String toHex(byte b) {
        int upper = b >> 4 & 0xF;
        int lower = b & 0xF;
        String sb = String.valueOf(lookup[upper]) + lookup[lower];
        return sb;
    }

    public static char toAscii(byte b) {
        if (b > 31 && b < 127) {
            return (char)b;
        }
        return '.';
    }
}

