/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.util.logging;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.time.StopWatch;
import org.epics.ca.util.logging.LibraryLogManager;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Test;

class LibraryLogManagerTest {
    LibraryLogManagerTest() {
    }

    @Test
    void testGetLogger_withDebugEnabled() {
        Logger debugLogger = LibraryLogManager.getLogger(LibraryLogManagerTest.class, Level.ALL);
        debugLogger.finest("** This log message is at level FINEST **");
        debugLogger.finer("** This log message is at level FINER **");
        debugLogger.fine("** This log message is at level FINE **");
        debugLogger.config("** This log message is at level CONFIG **");
        debugLogger.info("** This log message is at level INFO **");
        debugLogger.warning("** This log message is at level WARNING **");
        debugLogger.severe("** This log message is at level SEVERE **");
        LibraryLogManager.disposeLogger(debugLogger);
    }

    @Test
    void testGetLogger_withDebugDisabled() {
        Logger noDebugLogger = LibraryLogManager.getLogger(LibraryLogManagerTest.class, Level.OFF);
        noDebugLogger.finest("** This log message is at level FINEST **");
        noDebugLogger.finer("** This log message is at level FINER **");
        noDebugLogger.fine("** This log message is at level FINE **");
        noDebugLogger.config("** This log message is at level CONFIG **");
        noDebugLogger.info("** This log message is at level INFO **");
        noDebugLogger.warning("** This log message is at level WARNING **");
        noDebugLogger.severe("** This log message is at level SEVERE **");
        LibraryLogManager.disposeLogger(noDebugLogger);
    }

    @Test
    void testGetLogger_withDefaultDebugLevel() {
        Logger defaultLogger = LibraryLogManager.getLogger(LibraryLogManagerTest.class);
        defaultLogger.finest("** This log message is at level FINEST **");
        defaultLogger.finer("** This log message is at level FINER **");
        defaultLogger.fine("** This log message is at level FINE **");
        defaultLogger.config("** This log message is at level CONFIG **");
        defaultLogger.info("** This log message is at level INFO **");
        defaultLogger.warning("** This log message is at level WARNING **");
        defaultLogger.severe("** This log message is at level SEVERE **");
        LibraryLogManager.disposeLogger(defaultLogger);
    }

    @Test
    void testGetLogger_withExceptions() {
        Logger exceptionLogger = LibraryLogManager.getLogger(LibraryLogManagerTest.class);
        RuntimeException exception = new RuntimeException("This is a test exception.");
        exceptionLogger.log(Level.FINEST, "** This exception log message is at level FINEST **", exception);
        exceptionLogger.log(Level.FINER, "** This exception log message is at level FINER **", exception);
        exceptionLogger.log(Level.FINE, "** This exception log message is at level FINE **", exception);
        exceptionLogger.log(Level.CONFIG, "** This exception log message is at level CONFIG **", exception);
        exceptionLogger.log(Level.INFO, "** This exception log message is at level INFO **", exception);
        exceptionLogger.log(Level.WARNING, "** This exception log message is at level WARNING **", exception);
        exceptionLogger.log(Level.SEVERE, "** This exception log message is at level SEVERE **", exception);
        LibraryLogManager.disposeLogger(exceptionLogger);
    }

    @RepeatedTest(value=3)
    void testFinest_performanceWithDebugFullyDisabled() {
        Logger noDebugLogger = LibraryLogManager.getLogger(LibraryLogManagerTest.class, Level.INFO);
        StopWatch stopWatch = StopWatch.createStarted();
        for (int i2 = 0; i2 < 1000000; ++i2) {
            noDebugLogger.finest("** This log message is at level FINEST **");
        }
        long elapsedTimeInMicroseconds = stopWatch.getTime(TimeUnit.MICROSECONDS);
        noDebugLogger.info("Sending 1,000,000 messages to DISABLED debug took " + elapsedTimeInMicroseconds + " us");
        LibraryLogManager.disposeLogger(noDebugLogger);
    }

    @RepeatedTest(value=3)
    void testFinest_performanceWithDebugFullyEnabled() {
        Logger debugLogger = LibraryLogManager.getLogger(LibraryLogManagerTest.class, Level.ALL);
        StopWatch stopWatch = StopWatch.createStarted();
        for (int i2 = 0; i2 < 1000; ++i2) {
            debugLogger.finest("** This log message is at level FINEST **");
        }
        long elapsedTimeInMillis = stopWatch.getTime(TimeUnit.MILLISECONDS);
        debugLogger.info("Sending 1,000 messages to FULLY ENABLED debug took " + elapsedTimeInMillis + "ms");
        LibraryLogManager.disposeLogger(debugLogger);
    }

    @Test
    void testFinest_performanceWithDebugPartiallyEnabled() {
        Logger debugLogger = LibraryLogManager.getLogger(LibraryLogManagerTest.class, Level.FINER);
        StopWatch stopWatch = StopWatch.createStarted();
        for (int i2 = 0; i2 < 1000; ++i2) {
            debugLogger.finer("** This log message is at level FINER **");
            debugLogger.finest("** This log message is at level FINEST **");
        }
        long elapsedTimeInMillis = stopWatch.getTime(TimeUnit.MILLISECONDS);
        debugLogger.info("Sending 1,000 messages to PARTIALLY ENABLED debug took " + elapsedTimeInMillis + "ms");
        LibraryLogManager.disposeLogger(debugLogger);
    }

    @Test
    void logMessage() {
        Logger defaultLogger = LibraryLogManager.getLogger(LibraryLogManagerTest.class);
        defaultLogger.log(Level.INFO, "STRING formatting options:");
        defaultLogger.log(Level.INFO, "My msg with '{0}' format specifier is: {0}", "Hello");
        defaultLogger.log(Level.INFO, "My msg with '{0} {1}' format specifier is: {0} {1}\n", new String[]{"Hello", "world !"});
        defaultLogger.log(Level.INFO, "NUMBER formatting options:");
        defaultLogger.log(Level.INFO, "My msg with '{0,number}' format specifier is: {0,number}", 1.2345678998765433E8);
        defaultLogger.log(Level.INFO, "My msg with '{0,number,integer}' specifier is: {0,number,integer}", 1.2345678998765433E8);
        defaultLogger.log(Level.INFO, "My msg with '{0,number,currency}' specifier is: {0,number,currency}", 1.2345678998765433E8);
        defaultLogger.log(Level.INFO, "My msg with '{0,number,percent}' specifier is: {0,number,percent}\n", 1.2345678998765433E8);
        defaultLogger.log(Level.INFO, "DATE formatting options:");
        defaultLogger.log(Level.INFO, "My msg with '{0,date}' format specifier is: {0,date}", new Date());
        defaultLogger.log(Level.INFO, "My msg with '{0,date,short}' specifier is: {0,date,short}", new Date());
        defaultLogger.log(Level.INFO, "My msg with '{0,date,medium}' specifier is: {0,date,medium}", new Date());
        defaultLogger.log(Level.INFO, "My msg with '{0,date,long}' specifier is: {0,date,long}", new Date());
        defaultLogger.log(Level.INFO, "My msg with '{0,date,full}' specifier is: {0,date,full}\n", new Date());
        defaultLogger.log(Level.INFO, "TIME formatting options:");
        defaultLogger.log(Level.INFO, "My msg with '{0,time}' format specifier is: {0,time}", new Date());
        defaultLogger.log(Level.INFO, "My msg with '{0,time,short}' specifier is: {0,time,short}", new Date());
        defaultLogger.log(Level.INFO, "My msg with '{0,time,medium}' specifier is: {0,time,medium}", new Date());
        defaultLogger.log(Level.INFO, "My msg with '{0,time,long}' specifier is: {0,time,long}", new Date());
        defaultLogger.log(Level.INFO, "My msg with '{0,time,full}' specifier is: {0,time,full}\n", new Date());
        LibraryLogManager.disposeLogger(defaultLogger);
    }
}

