/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.stubbing.answers;

import java.lang.reflect.Array;
import org.mockito.creation.instance.Instantiator;
import org.mockito.internal.configuration.plugins.Plugins;
import org.mockito.internal.stubbing.defaultanswers.ReturnsEmptyValues;
import org.mockito.internal.util.reflection.LenientCopyTool;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class ClonesArguments
implements Answer<Object> {
    @Override
    public Object answer(InvocationOnMock invocation) throws Throwable {
        Object[] arguments = invocation.getArguments();
        for (int i2 = 0; i2 < arguments.length; ++i2) {
            Object newInstance;
            Object from = arguments[i2];
            if (from == null) continue;
            if (from.getClass().isArray()) {
                int len = Array.getLength(from);
                newInstance = Array.newInstance(from.getClass().getComponentType(), len);
                for (int j = 0; j < len; ++j) {
                    Array.set(newInstance, j, Array.get(from, j));
                }
                arguments[i2] = newInstance;
                continue;
            }
            Instantiator instantiator = Plugins.getInstantiatorProvider().getInstantiator(null);
            newInstance = instantiator.newInstance(from.getClass());
            new LenientCopyTool().copyToRealObject(from, newInstance);
            arguments[i2] = newInstance;
        }
        return new ReturnsEmptyValues().answer(invocation);
    }
}

