/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.impl.monitor.blockingqueue;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.apache.commons.lang3.Validate;
import org.epics.ca.impl.monitor.MonitorNotificationService;
import org.epics.ca.impl.monitor.MonitorNotificationServiceFactory;
import org.epics.ca.impl.monitor.MonitorNotificationServiceFactoryCreator;
import org.epics.ca.impl.monitor.blockingqueue.BlockingQueueMonitorNotificationService;
import org.epics.ca.util.logging.LibraryLogManager;

public class BlockingQueueMonitorNotificationServiceFactory
implements MonitorNotificationServiceFactory,
AutoCloseable {
    private static final Logger logger = LibraryLogManager.getLogger(BlockingQueueMonitorNotificationServiceFactory.class);
    private final List<MonitorNotificationService<?>> serviceList = new ArrayList();
    private final ThreadPoolExecutor threadPoolExecutor;
    private final int bufferSize;
    private final int numberOfThreads;

    public BlockingQueueMonitorNotificationServiceFactory(int numberOfThreads, int bufferSize) {
        Validate.inclusiveBetween(1L, Integer.MAX_VALUE, numberOfThreads);
        Validate.inclusiveBetween(1L, Integer.MAX_VALUE, bufferSize);
        this.bufferSize = bufferSize;
        this.numberOfThreads = numberOfThreads;
        int numberOfThreadsBaseline = Thread.getAllStackTraces().keySet().size();
        logger.finest(String.format("The number of baseline threads in the system was: %d", numberOfThreadsBaseline));
        logger.fine(String.format("A BlockingQueueMonitorNotificationServiceFactory is being created with %d threads and a buffer size with %d notification entries...", numberOfThreads, bufferSize));
        LinkedBlockingQueue<Runnable> notificationTaskQueue = new LinkedBlockingQueue<Runnable>();
        this.threadPoolExecutor = new ThreadPoolExecutor(numberOfThreads, numberOfThreads, Long.MAX_VALUE, TimeUnit.DAYS, notificationTaskQueue, new MyThreadFactory("BlockingQueueMonitorNotificationServiceThread-"));
        this.threadPoolExecutor.prestartAllCoreThreads();
    }

    @Override
    public <T> MonitorNotificationService<T> getServiceForConsumer(Consumer<? super T> consumer) {
        Validate.notNull(consumer);
        LinkedBlockingQueue notificationValueQueue = new LinkedBlockingQueue(this.bufferSize);
        BlockingQueueMonitorNotificationService<T> instance = new BlockingQueueMonitorNotificationService<T>(this.threadPoolExecutor, notificationValueQueue, consumer);
        this.serviceList.add(instance);
        instance.init();
        return instance;
    }

    @Override
    public void close() {
        logger.finest(String.format("A BlockingQueueMonitorNotificationServiceFactory is being closed with %d service entries...", this.getServiceCount()));
        for (MonitorNotificationService<?> service : this.serviceList) {
            service.close();
        }
        this.serviceList.clear();
        MonitorNotificationServiceFactoryCreator.shutdownExecutor(this.threadPoolExecutor);
    }

    @Override
    public int getServiceCount() {
        return this.serviceList.size();
    }

    @Override
    public boolean getQosMetricIsBuffered() {
        return this.bufferSize > 1;
    }

    @Override
    public int getQosMetricBufferSizePerConsumer() {
        return this.bufferSize;
    }

    @Override
    public int getQosMetricNumberOfNotificationThreadsPerConsumer() {
        return this.numberOfThreads;
    }

    @Override
    public boolean getQosMetricIsNullPublishable() {
        return false;
    }

    private static class MyThreadFactory
    implements ThreadFactory {
        private static int id = 1;
        private final String prefix;

        private MyThreadFactory(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, this.prefix + id++);
        }
    }
}

