/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.impl.repeater;

import java.net.DatagramPacket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Optional;
import net.jcip.annotations.Immutable;
import org.apache.commons.lang3.Validate;
import org.epics.ca.util.net.InetAddressUtil;

class CARepeaterMessage {
    static final int CA_MESSAGE_HEADER_SIZE = 16;
    static final short CA_MINOR_PROTOCOL_REVISION = 13;

    CARepeaterMessage() {
    }

    static DatagramPacket createVersionMessage() {
        return new CaVersionMessage().getMessageAsDatagram();
    }

    static DatagramPacket createBeaconMessage(short protocolMinorVersion, short serverTcpListeningPort, int serverBeaconId, InetAddress serverAddress) {
        return new CaBeaconMessage(protocolMinorVersion, serverTcpListeningPort, serverBeaconId, serverAddress).getMessageAsDatagram();
    }

    static DatagramPacket createRepeaterRegisterMessage(InetAddress clientIpAddress) {
        return new CaRepeaterRegisterMessage(clientIpAddress).getMessageAsDatagram();
    }

    static DatagramPacket createRepeaterConfirmMessage(InetAddress repeaterAddress) {
        return new CaRepeaterConfirmMessage(repeaterAddress).getMessageAsDatagram();
    }

    static String extractMessageAsString(DatagramPacket datagramPacket) {
        int packetLength = datagramPacket.getLength();
        String contents = Arrays.toString(Arrays.copyOfRange(datagramPacket.getData(), 0, packetLength));
        if (packetLength == 0) {
            return "EmptyMessage{}";
        }
        if (packetLength < 16) {
            CARepeaterMessage.removeFirstMessageFromDatagram(datagramPacket, datagramPacket.getLength());
            return "UnknownMessage{ len=" + packetLength + ", data=" + contents + "}";
        }
        ByteBuffer buffer = ByteBuffer.wrap(datagramPacket.getData());
        short command = buffer.getShort(CaHeaderOffsets.CA_HDR_SHORT_COMMAND_OFFSET.value);
        Optional<CaCommandCodes> code = CaCommandCodes.valueOf(command);
        if (code.isPresent()) {
            switch (code.get()) {
                case CA_PROTO_SEARCH: {
                    int searchId1 = buffer.getInt(CaSearchRequestMessageOffsets.CA_HDR_INT_SEARCH_REQUEST_MSG_SEARCHID1_OFFSET.value);
                    int searchId2 = buffer.getInt(CaSearchRequestMessageOffsets.CA_HDR_INT_SEARCH_REQUEST_MSG_SEARCHID2_OFFSET.value);
                    if (buffer.getShort(CaSearchResponseMessageOffsets.CA_HDR_SHORT_SEARCH_RESPONSE_MSG_PAYLOAD_SIZE_OFFSET.value) == 8) {
                        short serverTcpPort = buffer.getShort(CaSearchResponseMessageOffsets.CA_HDR_SHORT_SEARCH_RESPONSE_MSG_SERVER_TCP_PORT_OFFSET.value);
                        int sidOrServerAddress = buffer.getInt(CaSearchResponseMessageOffsets.CA_HDR_INT_SEARCH_RESPONSE_MSG_SID_OR_SERVER_ADDR_OFFSET.value);
                        int searchId = buffer.getInt(CaSearchResponseMessageOffsets.CA_HDR_INT_SEARCH_RESPONSE_MSG_SEARCHID_OFFSET.value);
                        CARepeaterMessage.removeFirstMessageFromDatagram(datagramPacket, 24);
                        return new CaSearchResponseMessage(serverTcpPort, sidOrServerAddress, searchId).toString();
                    }
                    if (searchId1 == searchId2) {
                        short payloadSize = buffer.getShort(CaSearchRequestMessageOffsets.CA_HDR_SHORT_SEARCH_REQUEST_MSG_PAYLOAD_SIZE_OFFSET.value);
                        byte[] payloadAsByteArray = Arrays.copyOfRange(datagramPacket.getData(), 16, 16 + payloadSize);
                        String payloadAsString = new String(payloadAsByteArray);
                        CARepeaterMessage.removeFirstMessageFromDatagram(datagramPacket, 16 + payloadSize);
                        return new CaSearchRequestMessage(payloadAsString, searchId1).toString();
                    }
                }
                case CA_PROTO_VERSION: {
                    CARepeaterMessage.removeFirstMessageFromDatagram(datagramPacket, 16);
                    return new CaVersionMessage().toString();
                }
                case CA_REPEATER_CONFIRM: {
                    int repeaterAddress = buffer.getInt(CaRepeaterConfirmMessageOffsets.CA_HDR_INT_REPEATER_CONFIRM_MSG_REPEATER_ADDR_OFFSET.value);
                    InetAddress repeaterInetAddress = InetAddressUtil.intToIPv4Address(repeaterAddress);
                    CARepeaterMessage.removeFirstMessageFromDatagram(datagramPacket, 16);
                    return new CaRepeaterConfirmMessage(repeaterInetAddress).toString();
                }
                case CA_REPEATER_REGISTER: {
                    int clientIpAddress = buffer.getInt(CaRepeaterRegisterMessageOffsets.CA_HDR_INT_REPEATER_REGISTER_MSG_REPEATER_ADDR_OFFSET.value);
                    InetAddress clientIpInetAddress = InetAddressUtil.intToIPv4Address(clientIpAddress);
                    CARepeaterMessage.removeFirstMessageFromDatagram(datagramPacket, 16);
                    return new CaRepeaterRegisterMessage(clientIpInetAddress).toString();
                }
                case CA_PROTO_RSRV_IS_UP: {
                    short minorProtocolVersion = buffer.getShort(CaBeaconMessageOffsets.CA_HDR_SHORT_BEACON_MSG_SERVER_PROTOCOL_MINOR_VERSION_OFFSET.value);
                    short serverTcpListeningPort = buffer.getShort(CaBeaconMessageOffsets.CA_HDR_SHORT_BEACON_MSG_SERVER_TCP_LISTENING_PORT_OFFSET.value);
                    int serverBeaconId = buffer.getInt(CaBeaconMessageOffsets.CA_HDR_INT_BEACON_MSG_SERVER_BEACON_ID_OFFSET.value);
                    int serverAddress = buffer.getInt(CaBeaconMessageOffsets.CA_HDR_INT_BEACON_MSG_SERVER_ADDR_OFFSET.value);
                    InetAddress serverInetAddress = InetAddressUtil.intToIPv4Address(serverAddress);
                    CARepeaterMessage.removeFirstMessageFromDatagram(datagramPacket, 16);
                    return new CaBeaconMessage(minorProtocolVersion, serverTcpListeningPort, serverBeaconId, serverInetAddress).toString();
                }
            }
        }
        CARepeaterMessage.removeFirstMessageFromDatagram(datagramPacket, datagramPacket.getLength());
        return "UnknownMessage{ len=" + packetLength + ", data=" + contents + "}";
    }

    static void removeFirstMessageFromDatagram(DatagramPacket datagramPacket, int messageToRemoveLength) {
        Validate.notNull(datagramPacket);
        Validate.isTrue(messageToRemoveLength <= datagramPacket.getLength());
        int newLength = datagramPacket.getLength() - messageToRemoveLength;
        byte[] newPayload = Arrays.copyOfRange(datagramPacket.getData(), messageToRemoveLength, datagramPacket.getLength());
        datagramPacket.setData(newPayload, 0, newLength);
    }

    @Immutable
    private static class CaRepeaterConfirmMessage {
        private final InetAddress repeaterAddress;

        CaRepeaterConfirmMessage(InetAddress repeaterAddress) {
            Validate.notNull(repeaterAddress);
            Validate.isTrue(repeaterAddress instanceof Inet4Address);
            this.repeaterAddress = repeaterAddress;
        }

        DatagramPacket getMessageAsDatagram() {
            ByteBuffer buffer = ByteBuffer.wrap(new byte[16]);
            buffer.putShort(CaRepeaterConfirmMessageOffsets.CA_HDR_SHORT_REPEATER_CONFIRM_MSG_COMMAND_OFFSET.value, CaCommandCodes.CA_REPEATER_CONFIRM.value);
            buffer.putShort(CaRepeaterConfirmMessageOffsets.CA_HDR_SHORT_REPEATER_CONFIRM_MSG_UNUSED1_OFFSET.value, (short)0);
            buffer.putShort(CaRepeaterConfirmMessageOffsets.CA_HDR_SHORT_REPEATER_CONFIRM_MSG_UNUSED2_OFFSET.value, (short)0);
            buffer.putShort(CaRepeaterConfirmMessageOffsets.CA_HDR_SHORT_REPEATER_CONFIRM_MSG_UNUSED3_OFFSET.value, (short)0);
            buffer.putInt(CaRepeaterConfirmMessageOffsets.CA_HDR_INT_REPEATER_CONFIRM_MSG_UNUSED4_OFFSET.value, 0);
            buffer.putInt(CaRepeaterConfirmMessageOffsets.CA_HDR_INT_REPEATER_CONFIRM_MSG_REPEATER_ADDR_OFFSET.value, InetAddressUtil.ipv4AddressToInt(this.repeaterAddress));
            return new DatagramPacket(buffer.array(), buffer.array().length);
        }

        public String toString() {
            return "CaRepeaterConfirmMessage{repeaterAddress=" + this.repeaterAddress + '}';
        }
    }

    @Immutable
    private static class CaRepeaterRegisterMessage {
        private final InetAddress clientAddress;

        CaRepeaterRegisterMessage(InetAddress clientAddress) {
            Validate.notNull(clientAddress);
            Validate.isTrue(clientAddress instanceof Inet4Address);
            this.clientAddress = clientAddress;
        }

        DatagramPacket getMessageAsDatagram() {
            ByteBuffer buffer = ByteBuffer.wrap(new byte[16]);
            buffer.putShort(CaRepeaterRegisterMessageOffsets.CA_HDR_SHORT_REPEATER_REGISTER_MSG_COMMAND_OFFSET.value, CaCommandCodes.CA_REPEATER_REGISTER.value);
            buffer.putShort(CaRepeaterRegisterMessageOffsets.CA_HDR_SHORT_REPEATER_REGISTER_MSG_UNUSED1_OFFSET.value, (short)0);
            buffer.putShort(CaRepeaterRegisterMessageOffsets.CA_HDR_SHORT_REPEATER_REGISTER_MSG_UNUSED2_OFFSET.value, (short)0);
            buffer.putShort(CaRepeaterRegisterMessageOffsets.CA_HDR_SHORT_REPEATER_REGISTER_MSG_UNUSED3_OFFSET.value, (short)0);
            buffer.putInt(CaRepeaterRegisterMessageOffsets.CA_HDR_INT_REPEATER_REGISTER_MSG_UNUSED4_OFFSET.value, 0);
            buffer.putInt(CaRepeaterRegisterMessageOffsets.CA_HDR_INT_REPEATER_REGISTER_MSG_REPEATER_ADDR_OFFSET.value, InetAddressUtil.ipv4AddressToInt(this.clientAddress));
            return new DatagramPacket(buffer.array(), buffer.array().length);
        }

        public String toString() {
            return "CaRepeaterRegisterMessage{clientAddress=" + this.clientAddress + '}';
        }
    }

    @Immutable
    static class CaBeaconMessage {
        private final short serverProtocolMinorVersion;
        private final short serverTcpListeningPort;
        private final int serverBeaconId;
        private final InetAddress serverAddress;

        CaBeaconMessage(short serverProtocolMinorVersion, short serverTcpListeningPort, int serverBeaconId, InetAddress serverAddress) {
            Validate.notNull(serverAddress);
            Validate.isTrue(serverAddress instanceof Inet4Address);
            this.serverProtocolMinorVersion = serverProtocolMinorVersion;
            this.serverTcpListeningPort = serverTcpListeningPort;
            this.serverBeaconId = serverBeaconId;
            this.serverAddress = serverAddress;
        }

        DatagramPacket getMessageAsDatagram() {
            ByteBuffer buffer = ByteBuffer.wrap(new byte[16]);
            buffer.putShort(CaBeaconMessageOffsets.CA_HDR_SHORT_BEACON_MSG_COMMAND_OFFSET.value, CaCommandCodes.CA_PROTO_RSRV_IS_UP.value);
            buffer.putShort(CaBeaconMessageOffsets.CA_HDR_SHORT_BEACON_MSG_UNUSED_OFFSET.value, (short)0);
            buffer.putShort(CaBeaconMessageOffsets.CA_HDR_SHORT_BEACON_MSG_SERVER_PROTOCOL_MINOR_VERSION_OFFSET.value, this.serverProtocolMinorVersion);
            buffer.putShort(CaBeaconMessageOffsets.CA_HDR_SHORT_BEACON_MSG_SERVER_TCP_LISTENING_PORT_OFFSET.value, this.serverTcpListeningPort);
            buffer.putInt(CaBeaconMessageOffsets.CA_HDR_INT_BEACON_MSG_SERVER_BEACON_ID_OFFSET.value, this.serverBeaconId);
            buffer.putInt(CaBeaconMessageOffsets.CA_HDR_INT_BEACON_MSG_SERVER_ADDR_OFFSET.value, InetAddressUtil.ipv4AddressToInt(this.serverAddress));
            return new DatagramPacket(buffer.array(), buffer.array().length);
        }

        public String toString() {
            return "CaBeaconMessage{serverProtocolMinorVersion=" + this.serverProtocolMinorVersion + ", serverTcpListeningPort=" + this.serverTcpListeningPort + ", serverBeaconId=" + this.serverBeaconId + ", serverHostname=" + this.serverAddress.getHostName() + ", serverAddress=" + this.serverAddress + '}';
        }
    }

    @Immutable
    private static class CaVersionMessage {
        CaVersionMessage() {
        }

        DatagramPacket getMessageAsDatagram() {
            ByteBuffer buffer = ByteBuffer.wrap(new byte[16]);
            buffer.putShort(CaVersionMessageOffsets.CA_HDR_SHORT_VERSION_MSG_COMMAND_OFFSET.value, CaCommandCodes.CA_PROTO_VERSION.value);
            buffer.putShort(CaVersionMessageOffsets.CA_HDR_SHORT_VERSION_MSG_UNUSED1_OFFSET.value, (short)0);
            buffer.putShort(CaVersionMessageOffsets.CA_HDR_SHORT_VERSION_MSG_PRIORITY_OFFSET.value, (short)0);
            buffer.putShort(CaVersionMessageOffsets.CA_HDR_SHORT_VERSION_MSG_UNUSED_TCP_MINOR_VERSION_OFFSET.value, (short)0);
            buffer.putInt(CaVersionMessageOffsets.CA_HDR_INT_VERSION_MSG_UNUSED2_OFFSET.value, 0);
            buffer.putInt(CaVersionMessageOffsets.CA_HDR_INT_VERSION_MSG_UNUSED3_OFFSET.value, 0);
            return new DatagramPacket(buffer.array(), buffer.array().length);
        }

        public String toString() {
            return "CaVersionMessage{}";
        }
    }

    @Immutable
    private static class CaSearchResponseMessage {
        private final short serverTcpPort;
        private final int sidOrServerAddress;
        private final int searchId;

        CaSearchResponseMessage(short serverTcpPort, int sidOrServerAddress, int searchId) {
            this.serverTcpPort = serverTcpPort;
            this.sidOrServerAddress = sidOrServerAddress;
            this.searchId = searchId;
        }

        DatagramPacket getMessageAsDatagram(String channelName, int searchId) {
            ByteBuffer buffer = ByteBuffer.wrap(new byte[16]);
            buffer.putShort(CaSearchResponseMessageOffsets.CA_HDR_SHORT_SEARCH_RESPONSE_MSG_COMMAND_OFFSET.value, CaCommandCodes.CA_PROTO_SEARCH.value);
            buffer.putShort(CaSearchResponseMessageOffsets.CA_HDR_SHORT_SEARCH_RESPONSE_MSG_PAYLOAD_SIZE_OFFSET.value, (short)8);
            buffer.putShort(CaSearchResponseMessageOffsets.CA_HDR_SHORT_SEARCH_RESPONSE_MSG_SERVER_TCP_PORT_OFFSET.value, this.serverTcpPort);
            buffer.putShort(CaSearchResponseMessageOffsets.CA_HDR_SHORT_SEARCH_RESPONSE_MSG_DATA_COUNT_OFFSET.value, (short)0);
            buffer.putInt(CaSearchResponseMessageOffsets.CA_HDR_INT_SEARCH_RESPONSE_MSG_SID_OR_SERVER_ADDR_OFFSET.value, this.sidOrServerAddress);
            buffer.putInt(CaSearchResponseMessageOffsets.CA_HDR_INT_SEARCH_RESPONSE_MSG_SEARCHID_OFFSET.value, searchId);
            return new DatagramPacket(buffer.array(), buffer.array().length);
        }

        public String toString() {
            return "CaSearchResponseMessage{serverTcpPort=" + this.serverTcpPort + ", sidOrServerAddress=" + this.sidOrServerAddress + ", searchId=" + this.searchId + '}';
        }
    }

    @Immutable
    private static class CaSearchRequestMessage {
        private final String channelName;
        private final int searchId;

        CaSearchRequestMessage(String channelName, int searchId) {
            this.channelName = channelName;
            this.searchId = searchId;
        }

        DatagramPacket getMessageAsDatagram(String channelName, int searchId) {
            byte[] channelNameAsByteArray = channelName.getBytes();
            short payloadSize = (short)channelNameAsByteArray.length;
            ByteBuffer buffer = ByteBuffer.wrap(new byte[16]);
            buffer.putShort(CaSearchRequestMessageOffsets.CA_HDR_SHORT_SEARCH_REQUEST_MSG_COMMAND_OFFSET.value, CaCommandCodes.CA_PROTO_SEARCH.value);
            buffer.putShort(CaSearchRequestMessageOffsets.CA_HDR_SHORT_SEARCH_REQUEST_MSG_PAYLOAD_SIZE_OFFSET.value, payloadSize);
            buffer.putShort(CaSearchRequestMessageOffsets.CA_HDR_SHORT_SEARCH_REQUEST_MSG_UNUSED_TCP_REPLY_FLAG_OFFSET.value, (short)0);
            buffer.putShort(CaSearchRequestMessageOffsets.CA_HDR_SHORT_SEARCH_REQUEST_MSG_PROTOCOL_MINOR_VERSION_OFFSET.value, (short)0);
            buffer.putInt(CaSearchRequestMessageOffsets.CA_HDR_INT_SEARCH_REQUEST_MSG_SEARCHID1_OFFSET.value, searchId);
            buffer.putInt(CaSearchRequestMessageOffsets.CA_HDR_INT_SEARCH_REQUEST_MSG_SEARCHID2_OFFSET.value, searchId);
            buffer.put(channelNameAsByteArray);
            return new DatagramPacket(buffer.array(), buffer.array().length);
        }

        public String toString() {
            return "CaSearchRequestMessage{channelName='" + this.channelName + '\'' + ", searchId=" + this.searchId + '}';
        }
    }

    static enum CaRepeaterConfirmMessageOffsets {
        CA_HDR_SHORT_REPEATER_CONFIRM_MSG_COMMAND_OFFSET(0),
        CA_HDR_SHORT_REPEATER_CONFIRM_MSG_UNUSED1_OFFSET(2),
        CA_HDR_SHORT_REPEATER_CONFIRM_MSG_UNUSED2_OFFSET(4),
        CA_HDR_SHORT_REPEATER_CONFIRM_MSG_UNUSED3_OFFSET(6),
        CA_HDR_INT_REPEATER_CONFIRM_MSG_UNUSED4_OFFSET(8),
        CA_HDR_INT_REPEATER_CONFIRM_MSG_REPEATER_ADDR_OFFSET(12);

        final int value;

        private CaRepeaterConfirmMessageOffsets(int value) {
            this.value = value;
        }
    }

    static enum CaRepeaterRegisterMessageOffsets {
        CA_HDR_SHORT_REPEATER_REGISTER_MSG_COMMAND_OFFSET(0),
        CA_HDR_SHORT_REPEATER_REGISTER_MSG_UNUSED1_OFFSET(2),
        CA_HDR_SHORT_REPEATER_REGISTER_MSG_UNUSED2_OFFSET(4),
        CA_HDR_SHORT_REPEATER_REGISTER_MSG_UNUSED3_OFFSET(6),
        CA_HDR_INT_REPEATER_REGISTER_MSG_UNUSED4_OFFSET(8),
        CA_HDR_INT_REPEATER_REGISTER_MSG_REPEATER_ADDR_OFFSET(12);

        final int value;

        private CaRepeaterRegisterMessageOffsets(int value) {
            this.value = value;
        }
    }

    static enum CaVersionMessageOffsets {
        CA_HDR_SHORT_VERSION_MSG_COMMAND_OFFSET(0),
        CA_HDR_SHORT_VERSION_MSG_UNUSED1_OFFSET(2),
        CA_HDR_SHORT_VERSION_MSG_PRIORITY_OFFSET(4),
        CA_HDR_SHORT_VERSION_MSG_UNUSED_TCP_MINOR_VERSION_OFFSET(6),
        CA_HDR_INT_VERSION_MSG_UNUSED2_OFFSET(8),
        CA_HDR_INT_VERSION_MSG_UNUSED3_OFFSET(12);

        final int value;

        private CaVersionMessageOffsets(int value) {
            this.value = value;
        }
    }

    static enum CaBeaconMessageOffsets {
        CA_HDR_SHORT_BEACON_MSG_COMMAND_OFFSET(0),
        CA_HDR_SHORT_BEACON_MSG_UNUSED_OFFSET(2),
        CA_HDR_SHORT_BEACON_MSG_SERVER_PROTOCOL_MINOR_VERSION_OFFSET(4),
        CA_HDR_SHORT_BEACON_MSG_SERVER_TCP_LISTENING_PORT_OFFSET(6),
        CA_HDR_INT_BEACON_MSG_SERVER_BEACON_ID_OFFSET(8),
        CA_HDR_INT_BEACON_MSG_SERVER_ADDR_OFFSET(12);

        final int value;

        private CaBeaconMessageOffsets(int value) {
            this.value = value;
        }
    }

    static enum CaSearchResponseMessageOffsets {
        CA_HDR_SHORT_SEARCH_RESPONSE_MSG_COMMAND_OFFSET(0),
        CA_HDR_SHORT_SEARCH_RESPONSE_MSG_PAYLOAD_SIZE_OFFSET(2),
        CA_HDR_SHORT_SEARCH_RESPONSE_MSG_SERVER_TCP_PORT_OFFSET(4),
        CA_HDR_SHORT_SEARCH_RESPONSE_MSG_DATA_COUNT_OFFSET(6),
        CA_HDR_INT_SEARCH_RESPONSE_MSG_SID_OR_SERVER_ADDR_OFFSET(8),
        CA_HDR_INT_SEARCH_RESPONSE_MSG_SEARCHID_OFFSET(12);

        final int value;

        private CaSearchResponseMessageOffsets(int value) {
            this.value = value;
        }
    }

    static enum CaSearchRequestMessageOffsets {
        CA_HDR_SHORT_SEARCH_REQUEST_MSG_COMMAND_OFFSET(0),
        CA_HDR_SHORT_SEARCH_REQUEST_MSG_PAYLOAD_SIZE_OFFSET(2),
        CA_HDR_SHORT_SEARCH_REQUEST_MSG_UNUSED_TCP_REPLY_FLAG_OFFSET(4),
        CA_HDR_SHORT_SEARCH_REQUEST_MSG_PROTOCOL_MINOR_VERSION_OFFSET(6),
        CA_HDR_INT_SEARCH_REQUEST_MSG_SEARCHID1_OFFSET(8),
        CA_HDR_INT_SEARCH_REQUEST_MSG_SEARCHID2_OFFSET(12);

        final int value;

        private CaSearchRequestMessageOffsets(int value) {
            this.value = value;
        }
    }

    static enum CaHeaderOffsets {
        CA_HDR_SHORT_COMMAND_OFFSET(0),
        CA_HDR_SHORT_PAYLOAD_SIZE_OFFSET(2),
        CA_HDR_SHORT_DATA_TYPE_OFFSET(4),
        CA_HDR_SHORT_DATA_COUNT_OFFSET(6),
        CA_HDR_INT_PARAM1_OFFSET(8),
        CA_HDR_INT_PARAM2_OFFSET(12);

        final int value;

        private CaHeaderOffsets(int value) {
            this.value = value;
        }
    }

    static enum CaCommandCodes {
        CA_PROTO_VERSION(0),
        CA_PROTO_SEARCH(6),
        CA_REPEATER_REGISTER(24),
        CA_REPEATER_CONFIRM(17),
        CA_PROTO_RSRV_IS_UP(13);

        final short value;

        private CaCommandCodes(int value) {
            this.value = (short)value;
        }

        static Optional<CaCommandCodes> valueOf(short input) {
            return Arrays.stream(CaCommandCodes.values()).filter(e -> e.value == input).findFirst();
        }
    }
}

