/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.impl.requests;

import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;
import org.epics.ca.CompletionException;
import org.epics.ca.Status;
import org.epics.ca.impl.ChannelImpl;
import org.epics.ca.impl.ContextImpl;
import org.epics.ca.impl.Messages;
import org.epics.ca.impl.NotifyResponseRequest;
import org.epics.ca.impl.Transport;
import org.epics.ca.impl.TypeSupports;
import org.epics.ca.util.logging.LibraryLogManager;

public class WriteNotifyRequest<T>
extends CompletableFuture<Status>
implements NotifyResponseRequest {
    private static final Logger logger = LibraryLogManager.getLogger(WriteNotifyRequest.class);
    protected final ContextImpl context;
    protected final int ioid;
    protected final int sid;
    protected final ChannelImpl<?> channel;

    public WriteNotifyRequest(ChannelImpl<?> channel, Transport transport, int sid, TypeSupports.TypeSupport<T> typeSupport, T value, int count) {
        this.channel = channel;
        this.sid = sid;
        this.context = transport.getContext();
        this.ioid = this.context.registerResponseRequest(this);
        channel.registerResponseRequest(this);
        logger.finest("Send data count is: " + count);
        Messages.writeNotifyMessage(transport, sid, this.ioid, typeSupport, value, count);
        transport.flush();
    }

    @Override
    public int getIOID() {
        return this.ioid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void response(int status, short dataType, int dataCount, ByteBuffer dataPayloadBuffer) {
        try {
            Status caStatus = Status.forStatusCode(status);
            this.complete(caStatus);
        }
        finally {
            this.cancel();
        }
    }

    @Override
    public void cancel() {
        this.context.unregisterResponseRequest(this);
        this.channel.unregisterResponseRequest(this);
    }

    @Override
    public void exception(int errorCode, String errorMessage) {
        this.cancel();
        Status status = Status.forStatusCode(errorCode);
        if (status == null) {
            status = Status.PUTFAIL;
        }
        this.completeExceptionally(new CompletionException(status, errorMessage));
    }
}

