/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.util.logging;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import org.apache.commons.lang3.Validate;
import org.epics.ca.impl.LibraryConfiguration;

public class LibraryLogManager {
    private static final StreamHandler flushingStandardOutputStreamHandler;

    public static Logger getLogger(Class<?> clazz) {
        Validate.notNull(clazz);
        return LibraryLogManager.getLogger(clazz, LibraryConfiguration.getInstance().getLibraryLogLevel());
    }

    public static Logger getLogger(Class<?> clazz, Level logLevel) {
        Logger logger = Logger.getLogger(clazz.getSimpleName());
        logger.setUseParentHandlers(false);
        if (logger.getHandlers().length == 0) {
            logger.addHandler(flushingStandardOutputStreamHandler);
        } else {
            System.out.println("\nWARNING: More than one logger defined for class: '" + clazz.getSimpleName() + "'.\n");
        }
        logger.setLevel(logLevel);
        return logger;
    }

    static void disposeLogger(Logger logger) {
        if (logger.getHandlers().length == 1) {
            logger.removeHandler(flushingStandardOutputStreamHandler);
        }
    }

    static {
        System.setProperty("java.util.logging.SimpleFormatter.format", "%1$tF %1$tT.%1$tL %3$s %4$s %5$s %6$s %n");
        flushingStandardOutputStreamHandler = new StreamHandler(System.out, new SimpleFormatter()){

            @Override
            public synchronized void publish(LogRecord record) {
                super.publish(record);
                this.flush();
            }
        };
        flushingStandardOutputStreamHandler.setLevel(Level.ALL);
    }
}

