/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.epics.ca.AccessRights;
import org.epics.ca.Channel;
import org.epics.ca.ConnectionState;
import org.epics.ca.Constants;
import org.epics.ca.Context;
import org.epics.ca.EpicsChannelAccessTestServer;
import org.epics.ca.Listener;
import org.epics.ca.Monitor;
import org.epics.ca.NotificationConsumer;
import org.epics.ca.Status;
import org.epics.ca.ThreadWatcher;
import org.epics.ca.data.Alarm;
import org.epics.ca.data.AlarmSeverity;
import org.epics.ca.data.AlarmStatus;
import org.epics.ca.data.Control;
import org.epics.ca.data.Graphic;
import org.epics.ca.data.GraphicEnum;
import org.epics.ca.data.GraphicEnumArray;
import org.epics.ca.data.Metadata;
import org.epics.ca.data.Timestamped;
import org.epics.ca.impl.monitor.MonitorNotificationServiceFactoryCreator;
import org.epics.ca.impl.repeater.NetworkUtilities;
import org.epics.ca.util.logging.LibraryLogManager;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class ChannelTest {
    private static final Logger logger = LibraryLogManager.getLogger(ChannelTest.class);
    private ThreadWatcher threadWatcher;
    private static final double DELTA = 1.0E-10;
    private static final int TIMEOUT_MILLISEC = 10000;
    private static final int TEST_SLEEP_INTERVAL_MILLISEC = 500;

    ChannelTest() {
    }

    @BeforeAll
    static void beforeAll() {
        MatcherAssert.assertThat((Object)NetworkUtilities.verifyTargetPlatformNetworkStackIsChannelAccessCompatible(), (Matcher)Is.is((Object)true));
        if (NetworkUtilities.isVpnActive()) {
            Assertions.fail((String)"This test is not supported when a VPN connection is active on the local network interface.");
        }
    }

    @BeforeEach
    void beforeEach() {
        this.threadWatcher = ThreadWatcher.start();
        EpicsChannelAccessTestServer.start();
    }

    @AfterEach
    void afterEach() {
        EpicsChannelAccessTestServer.shutdown();
        this.threadWatcher.verify();
    }

    @Test
    void testConnect() throws Throwable {
        try (Context context = new Context();){
            try (Channel channel = context.createChannel("no_such_channel_test", Double.class);){
                MatcherAssert.assertThat((Object)channel, (Matcher)IsNull.notNullValue());
                MatcherAssert.assertThat((Object)channel.getName(), (Matcher)Is.is((Object)"no_such_channel_test"));
                MatcherAssert.assertThat((Object)channel.getConnectionState(), (Matcher)Is.is((Object)ConnectionState.NEVER_CONNECTED));
                try {
                    channel.connectAsync().get(10000L, TimeUnit.MILLISECONDS);
                    Assertions.fail((String)"connected on non-existent channel, timeout expected");
                }
                catch (TimeoutException timeoutException) {
                    // empty catch block
                }
                MatcherAssert.assertThat((Object)channel.getConnectionState(), (Matcher)Is.is((Object)ConnectionState.NEVER_CONNECTED));
            }
            channel = context.createChannel("adc01", Double.class);
            var4_6 = null;
            try {
                MatcherAssert.assertThat((Object)channel, (Matcher)IsNull.notNullValue());
                MatcherAssert.assertThat((Object)channel.getName(), (Matcher)Is.is((Object)"adc01"));
                MatcherAssert.assertThat((Object)channel.getConnectionState(), (Matcher)Is.is((Object)ConnectionState.NEVER_CONNECTED));
                channel.connectAsync().get(10000L, TimeUnit.MILLISECONDS);
                MatcherAssert.assertThat((Object)channel.getConnectionState(), (Matcher)Is.is((Object)ConnectionState.CONNECTED));
                MatcherAssert.assertThat((Object)channel.getName(), (Matcher)Is.is((Object)"adc01"));
            }
            catch (Throwable throwable) {
                var4_6 = throwable;
                throw throwable;
            }
            finally {
                if (channel != null) {
                    if (var4_6 != null) {
                        try {
                            channel.close();
                        }
                        catch (Throwable throwable) {
                            var4_6.addSuppressed(throwable);
                        }
                    } else {
                        channel.close();
                    }
                }
            }
            channel = context.createChannel("adc01", Double.class);
            var4_6 = null;
            try {
                MatcherAssert.assertThat((Object)channel, (Matcher)IsNull.notNullValue());
                MatcherAssert.assertThat((Object)channel.getConnectionState(), (Matcher)Is.is((Object)ConnectionState.NEVER_CONNECTED));
                channel.connectAsync().get(10000L, TimeUnit.MILLISECONDS);
                MatcherAssert.assertThat((Object)channel.getConnectionState(), (Matcher)Is.is((Object)ConnectionState.CONNECTED));
            }
            catch (Throwable throwable) {
                var4_6 = throwable;
                throw throwable;
            }
            finally {
                if (channel != null) {
                    if (var4_6 != null) {
                        try {
                            channel.close();
                        }
                        catch (Throwable throwable) {
                            var4_6.addSuppressed(throwable);
                        }
                    } else {
                        channel.close();
                    }
                }
            }
        }
    }

    @Test
    void testConnectionListener() throws Throwable {
        try (Context context = new Context();
             Channel channel = context.createChannel("adc01", Double.class);){
            MatcherAssert.assertThat((Object)channel, (Matcher)IsNull.notNullValue());
            MatcherAssert.assertThat((Object)channel.getConnectionState(), (Matcher)Is.is((Object)ConnectionState.NEVER_CONNECTED));
            AtomicInteger connectedCount = new AtomicInteger();
            AtomicInteger disconnectedCount = new AtomicInteger();
            AtomicInteger unregisteredEventCount = new AtomicInteger();
            Listener cl = channel.addConnectionListener((c, connected) -> {
                if (c == channel) {
                    if (connected.booleanValue()) {
                        connectedCount.incrementAndGet();
                    } else {
                        disconnectedCount.incrementAndGet();
                    }
                }
            });
            MatcherAssert.assertThat((Object)cl, (Matcher)IsNull.notNullValue());
            Listener cl2 = channel.addConnectionListener((c, connected) -> unregisteredEventCount.incrementAndGet());
            MatcherAssert.assertThat((Object)cl2, (Matcher)IsNull.notNullValue());
            MatcherAssert.assertThat((Object)unregisteredEventCount.get(), (Matcher)Is.is((Object)0));
            cl2.close();
            channel.connectAsync().get(10000L, TimeUnit.MILLISECONDS);
            MatcherAssert.assertThat((Object)channel.getConnectionState(), (Matcher)Is.is((Object)ConnectionState.CONNECTED));
            Thread.sleep(500L);
            MatcherAssert.assertThat((Object)connectedCount.get(), (Matcher)Is.is((Object)1));
            MatcherAssert.assertThat((Object)disconnectedCount.get(), (Matcher)Is.is((Object)0));
            MatcherAssert.assertThat((Object)unregisteredEventCount.get(), (Matcher)Is.is((Object)0));
            channel.close();
            Thread.sleep(500L);
            MatcherAssert.assertThat((Object)connectedCount.get(), (Matcher)Is.is((Object)1));
            MatcherAssert.assertThat((Object)disconnectedCount.get(), (Matcher)Is.is((Object)0));
            MatcherAssert.assertThat((Object)unregisteredEventCount.get(), (Matcher)Is.is((Object)0));
        }
    }

    @Test
    void testAccessRightsListener() throws Throwable {
        try (Context context = new Context();
             Channel channel = context.createChannel("adc01", Double.class);){
            MatcherAssert.assertThat((Object)channel, (Matcher)IsNull.notNullValue());
            AtomicInteger aclCount = new AtomicInteger();
            AtomicInteger unregisteredEventCount = new AtomicInteger();
            Listener rl = channel.addAccessRightListener((c, ar) -> {
                if (c == channel && ar == AccessRights.READ_WRITE) {
                    aclCount.incrementAndGet();
                }
            });
            MatcherAssert.assertThat((Object)rl, (Matcher)IsNull.notNullValue());
            Listener cl2 = channel.addAccessRightListener((c, ar) -> unregisteredEventCount.incrementAndGet());
            MatcherAssert.assertThat((Object)cl2, (Matcher)IsNull.notNullValue());
            MatcherAssert.assertThat((Object)unregisteredEventCount.get(), (Matcher)Is.is((Object)0));
            cl2.close();
            channel.connectAsync().get(10000L, TimeUnit.MILLISECONDS);
            MatcherAssert.assertThat((Object)channel.getAccessRights(), (Matcher)Is.is((Object)AccessRights.READ_WRITE));
            Thread.sleep(500L);
            MatcherAssert.assertThat((Object)aclCount.get(), (Matcher)Is.is((Object)1));
            MatcherAssert.assertThat((Object)unregisteredEventCount.get(), (Matcher)Is.is((Object)0));
            channel.close();
            Thread.sleep(500L);
            MatcherAssert.assertThat((Object)aclCount.get(), (Matcher)Is.is((Object)1));
            MatcherAssert.assertThat((Object)unregisteredEventCount.get(), (Matcher)Is.is((Object)0));
        }
    }

    @Test
    void testProperties() throws Throwable {
        try (Context context = new Context();
             Channel channel = context.createChannel("adc01", Double.class);){
            channel.connectAsync().get(10000L, TimeUnit.MILLISECONDS);
            Map props = channel.getProperties();
            Object nativeTypeCode = props.get(Constants.ChannelProperties.nativeTypeCode.name());
            MatcherAssert.assertThat(nativeTypeCode, (Matcher)IsNull.notNullValue());
            MatcherAssert.assertThat(nativeTypeCode, (Matcher)Is.is((Object)6));
            Object nativeElementCount = props.get(Constants.ChannelProperties.nativeElementCount.name());
            MatcherAssert.assertThat(nativeElementCount, (Matcher)IsNull.notNullValue());
            MatcherAssert.assertThat(nativeElementCount, (Matcher)Is.is((Object)2));
            Object nativeType = props.get(Constants.ChannelProperties.nativeType.name());
            MatcherAssert.assertThat(nativeType, (Matcher)IsNull.notNullValue());
            MatcherAssert.assertThat(nativeType, (Matcher)Is.is(Double.class));
        }
    }

    @MethodSource(value={"getArgumentsForMonitorNotificationServiceImplementations"})
    @ParameterizedTest
    void testMonitorDisconnectionBehaviour(String serviceImpl) throws InterruptedException {
        Properties contextProperties = new Properties();
        contextProperties.setProperty("CA_MONITOR_NOTIFIER_IMPL", serviceImpl);
        try (Context context = new Context(contextProperties);
             Channel channel = context.createChannel("adc01", Integer.class);){
            channel.addConnectionListener((c, h) -> logger.info(String.format("Channel '%s', new connection state is: '%s' ", c.getName(), c.getConnectionState())));
            Assertions.assertDoesNotThrow(() -> {
                logger.info("connecting async...");
                channel.connectAsync().get(10000L, TimeUnit.MILLISECONDS);
                logger.info("connected.");
            });
            int testValue = 99;
            channel.put((Object)99);
            Consumer consumer = (Consumer)Mockito.mock(GenericIntegerConsumer.class);
            channel.addValueMonitor(consumer);
            Thread.sleep(500L);
            ((Consumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)1))).accept(99);
            EpicsChannelAccessTestServer.shutdown();
            Thread.sleep(500L);
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{consumer});
            EpicsChannelAccessTestServer.start();
        }
    }

    @Test
    void testMonitors() throws Throwable {
        try (Context context = new Context();
             Channel channel = context.createChannel("100msCounter", Integer.class);){
            channel.connect();
            try {
                channel.addValueMonitor(null);
                Assertions.fail((String)"null handler accepted");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            try {
                channel.addValueMonitor(value -> {}, 0);
                Assertions.fail((String)"empty mask accepted");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            try (Monitor monitor = channel.addValueMonitor(value -> {}, 1);){
                Assertions.assertNotNull((Object)monitor);
            }
            AtomicInteger monitorNotificationCount = new AtomicInteger();
            Monitor monitor = channel.addValueMonitor(value -> monitorNotificationCount.incrementAndGet(), 1);
            Assertions.assertNotNull((Object)monitor);
            Thread.sleep(5000L);
            monitor.close();
            int monitorNotifications = monitorNotificationCount.get();
            MatcherAssert.assertThat((Object)monitorNotificationCount.get(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(45)));
            Thread.sleep(1000L);
            MatcherAssert.assertThat((Object)monitorNotificationCount.get(), (Matcher)Is.is((Object)monitorNotifications));
        }
    }

    @Test
    void testLargeArray() throws Throwable {
        try (Context context = new Context();
             Channel channel = context.createChannel("large", int[].class);){
            Assertions.assertDoesNotThrow(() -> (Channel)channel.connectAsync().get(10000L, TimeUnit.MILLISECONDS));
            int[] value = (int[])channel.getAsync().get(10000L, TimeUnit.MILLISECONDS);
            MatcherAssert.assertThat((Object)value, (Matcher)IsNull.notNullValue());
            int LARGE_PRIME = 15485863;
            int i = 0;
            while (i < value.length) {
                MatcherAssert.assertThat((Object)value[i], (Matcher)Is.is((Object)i));
                int n = i++;
                value[n] = value[n] + 15485863;
            }
            Status putStatus = (Status)channel.putAsync((Object)value).get(10000L, TimeUnit.MILLISECONDS);
            MatcherAssert.assertThat((Object)putStatus, (Matcher)Is.is((Object)Status.NORMAL));
            value = (int[])channel.getAsync().get(10000L, TimeUnit.MILLISECONDS);
            MatcherAssert.assertThat((Object)channel, (Matcher)IsNull.notNullValue());
            for (int i2 = 0; i2 < value.length; ++i2) {
                MatcherAssert.assertThat((Object)value[i2], (Matcher)Is.is((Object)(i2 + 15485863)));
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"getArgumentsForMonitorNotificationServiceImplementations"})
    void testContextCloseAlsoClosesMonitorNotifier(String serviceImpl) {
        MatcherAssert.assertThat((Object)MonitorNotificationServiceFactoryCreator.getServiceCount(), (Matcher)Is.is((Object)0L));
        Properties contextProperties = new Properties();
        contextProperties.setProperty("CA_MONITOR_NOTIFIER_IMPL", serviceImpl);
        Context context = new Context(contextProperties);
        Channel channel = context.createChannel("adc01", Integer.class);
        Assertions.assertDoesNotThrow(() -> (Channel)channel.connectAsync().get(10000L, TimeUnit.MILLISECONDS));
        MatcherAssert.assertThat((Object)MonitorNotificationServiceFactoryCreator.getServiceCount(), (Matcher)Is.is((Object)0L));
        NotificationConsumer notificationConsumer = NotificationConsumer.getNormalConsumer();
        NotificationConsumer.clearCurrentTotalNotificationCount();
        NotificationConsumer.setExpectedTotalNotificationCount(2);
        channel.addValueMonitor(notificationConsumer);
        channel.addValueMonitor(notificationConsumer);
        MatcherAssert.assertThat((Object)MonitorNotificationServiceFactoryCreator.getServiceCount(), (Matcher)Is.is((Object)2L));
        NotificationConsumer.awaitExpectedTotalNotificationCount();
        context.close();
        MatcherAssert.assertThat((Object)MonitorNotificationServiceFactoryCreator.getServiceCount(), (Matcher)Is.is((Object)0L));
    }

    @ParameterizedTest
    @MethodSource(value={"getArgumentsForMonitorNotificationServiceImplementations"})
    void testChannelCloseDoesNotCloseMonitorNotifier(String serviceImpl) {
        MatcherAssert.assertThat((Object)MonitorNotificationServiceFactoryCreator.getServiceCount(), (Matcher)Is.is((Object)0L));
        Properties contextProperties = new Properties();
        contextProperties.setProperty("CA_MONITOR_NOTIFIER_IMPL", serviceImpl);
        try (Context context = new Context(contextProperties);){
            Channel channel = context.createChannel("adc01", Integer.class);
            Assertions.assertDoesNotThrow(() -> (Channel)channel.connectAsync().get(10000L, TimeUnit.MILLISECONDS));
            MatcherAssert.assertThat((Object)MonitorNotificationServiceFactoryCreator.getServiceCount(), (Matcher)Is.is((Object)0L));
            NotificationConsumer notificationConsumer = NotificationConsumer.getNormalConsumer();
            NotificationConsumer.clearCurrentTotalNotificationCount();
            NotificationConsumer.setExpectedTotalNotificationCount(2);
            channel.addValueMonitor(notificationConsumer);
            channel.addValueMonitor(notificationConsumer);
            MatcherAssert.assertThat((Object)MonitorNotificationServiceFactoryCreator.getServiceCount(), (Matcher)Is.is((Object)2L));
            NotificationConsumer.awaitExpectedTotalNotificationCount();
            channel.close();
            MatcherAssert.assertThat((Object)MonitorNotificationServiceFactoryCreator.getServiceCount(), (Matcher)Is.is((Object)2L));
        }
        MatcherAssert.assertThat((Object)MonitorNotificationServiceFactoryCreator.getServiceCount(), (Matcher)Is.is((Object)0L));
    }

    @ParameterizedTest
    @MethodSource(value={"getArgumentsForMonitorNotificationServiceImplementations"})
    void testMonitorCloseDoesNotAlsoCloseMonitorNotifier(String serviceImpl) {
        MatcherAssert.assertThat((Object)MonitorNotificationServiceFactoryCreator.getServiceCount(), (Matcher)Is.is((Object)0L));
        Properties contextProperties = new Properties();
        contextProperties.setProperty("CA_MONITOR_NOTIFIER_IMPL", serviceImpl);
        try (Context context = new Context(contextProperties);){
            MatcherAssert.assertThat((Object)MonitorNotificationServiceFactoryCreator.getServiceCount(), (Matcher)Is.is((Object)0L));
            Channel channel = context.createChannel("adc01", Integer.class);
            Assertions.assertDoesNotThrow(() -> (Channel)channel.connectAsync().get(10000L, TimeUnit.MILLISECONDS));
            MatcherAssert.assertThat((Object)MonitorNotificationServiceFactoryCreator.getServiceCount(), (Matcher)Is.is((Object)0L));
            NotificationConsumer notificationConsumer = NotificationConsumer.getNormalConsumer();
            NotificationConsumer.clearCurrentTotalNotificationCount();
            NotificationConsumer.setExpectedTotalNotificationCount(2);
            Monitor monitor1 = channel.addValueMonitor(notificationConsumer);
            Monitor monitor2 = channel.addValueMonitor(notificationConsumer);
            MatcherAssert.assertThat((Object)MonitorNotificationServiceFactoryCreator.getServiceCount(), (Matcher)Is.is((Object)2L));
            NotificationConsumer.awaitExpectedTotalNotificationCount();
            monitor1.close();
            MatcherAssert.assertThat((Object)MonitorNotificationServiceFactoryCreator.getServiceCount(), (Matcher)Is.is((Object)2L));
            monitor2.close();
            MatcherAssert.assertThat((Object)MonitorNotificationServiceFactoryCreator.getServiceCount(), (Matcher)Is.is((Object)2L));
        }
        MatcherAssert.assertThat((Object)MonitorNotificationServiceFactoryCreator.getServiceCount(), (Matcher)Is.is((Object)0L));
    }

    @MethodSource(value={"getArgumentsForTestPutAndGetValue"})
    @ParameterizedTest
    <T> void testPutAndGetValue(String channelName, Class<T> type, T expectedValue, boolean async) throws Throwable {
        logger.info("testPutAndGetValue invoked with args: " + String.format("'%s', '%s', '%s'.", channelName, type.getSimpleName(), async));
        try (Context context = new Context();
             Channel channel = context.createChannel(channelName, type);){
            Object value;
            Assertions.assertDoesNotThrow(() -> (Channel)channel.connectAsync().get(10000L, TimeUnit.MILLISECONDS));
            if (async) {
                Status status = (Status)channel.putAsync(expectedValue).get(10000L, TimeUnit.MILLISECONDS);
                Assertions.assertTrue((boolean)status.isSuccessful());
            } else {
                channel.putNoWait(expectedValue);
            }
            if (async) {
                value = channel.getAsync().get(10000L, TimeUnit.MILLISECONDS);
                Assertions.assertNotNull((Object)value);
            } else {
                value = channel.get();
            }
            MatcherAssert.assertThat((Object)value, (Matcher)Is.is(expectedValue));
        }
    }

    @MethodSource(value={"getArgumentsForTestPutAndGetMetadata"})
    @ParameterizedTest
    <T, ST, MT extends Metadata<T>> void testPutAndGetMetadata(String channelName, Class<T> type, Class<ST> scalarType, T expectedValue, Class<? extends Metadata<T>> metaType, Alarm<?> expectedAlarm, Control<?, Double> expectedMeta, boolean async) throws Throwable {
        logger.info("testPutAndGetMetadata invoked with args: " + String.format("'%s', '%s', '%s', '%s', '%s'.", channelName, type.getSimpleName(), scalarType.getSimpleName(), metaType.getSimpleName(), async));
        if ((metaType.equals(Control.class) || metaType.equals(Graphic.class)) && (type.equals(String.class) || type.equals(String[].class))) {
            logger.info("Skipping test because EPICS does not support this combination !");
            return;
        }
        logger.info("Creating context...");
        try (Context context = new Context();){
            logger.info("Done. Creating channel...");
            try (Channel channel = context.createChannel(channelName, type);){
                Alarm v;
                Metadata value;
                logger.info("Done. connecting channel...");
                Assertions.assertDoesNotThrow(() -> (Channel)channel.connectAsync().get(10000L, TimeUnit.MILLISECONDS));
                if (async) {
                    Status status = (Status)channel.putAsync(expectedValue).get(10000L, TimeUnit.MILLISECONDS);
                    Assertions.assertTrue((boolean)status.isSuccessful());
                } else {
                    channel.putNoWait(expectedValue);
                }
                if (async) {
                    value = (Metadata)channel.getAsync(metaType).get(10000L, TimeUnit.MILLISECONDS);
                    Assertions.assertNotNull((Object)value);
                } else {
                    value = channel.get(metaType);
                }
                if (Alarm.class.isAssignableFrom(metaType)) {
                    v = (Alarm)value;
                    MatcherAssert.assertThat((Object)v.getAlarmStatus(), (Matcher)Is.is((Object)expectedAlarm.getAlarmStatus()));
                    MatcherAssert.assertThat((Object)v.getAlarmSeverity(), (Matcher)Is.is((Object)expectedAlarm.getAlarmSeverity()));
                }
                if (Timestamped.class.isAssignableFrom(metaType)) {
                    v = (Timestamped)value;
                    long dt = System.currentTimeMillis() - v.getMillis();
                    Assertions.assertTrue((dt < 10000L ? 1 : 0) != 0);
                }
                if (Graphic.class.isAssignableFrom(metaType)) {
                    v = (Graphic)value;
                    MatcherAssert.assertThat((Object)v.getUnits(), (Matcher)Is.is((Object)expectedMeta.getUnits()));
                    if (scalarType.equals(Double.class) || scalarType.equals(Float.class)) {
                        Assertions.assertEquals((int)expectedMeta.getPrecision(), (int)v.getPrecision());
                    }
                    MatcherAssert.assertThat((Object)((Number)v.getLowerAlarm()).doubleValue(), (Matcher)Matchers.closeTo((double)((Double)expectedMeta.getLowerAlarm()), (double)1.0E-10));
                    MatcherAssert.assertThat((Object)((Number)v.getLowerDisplay()).doubleValue(), (Matcher)Matchers.closeTo((double)((Double)expectedMeta.getLowerDisplay()), (double)1.0E-10));
                    MatcherAssert.assertThat((Object)((Number)v.getLowerWarning()).doubleValue(), (Matcher)Matchers.closeTo((double)((Double)expectedMeta.getLowerWarning()), (double)1.0E-10));
                    MatcherAssert.assertThat((Object)((Number)v.getUpperAlarm()).doubleValue(), (Matcher)Matchers.closeTo((double)((Double)expectedMeta.getUpperAlarm()), (double)1.0E-10));
                    MatcherAssert.assertThat((Object)((Number)v.getUpperDisplay()).doubleValue(), (Matcher)Matchers.closeTo((double)((Double)expectedMeta.getUpperDisplay()), (double)1.0E-10));
                    MatcherAssert.assertThat((Object)((Number)v.getUpperWarning()).doubleValue(), (Matcher)Matchers.closeTo((double)((Double)expectedMeta.getUpperWarning()), (double)1.0E-10));
                }
                if (Control.class.isAssignableFrom(metaType)) {
                    v = (Control)value;
                    MatcherAssert.assertThat((Object)((Number)v.getLowerControl()).doubleValue(), (Matcher)Matchers.closeTo((double)((Double)expectedMeta.getLowerControl()), (double)1.0E-10));
                    MatcherAssert.assertThat((Object)((Number)v.getUpperControl()).doubleValue(), (Matcher)Matchers.closeTo((double)((Double)expectedMeta.getUpperControl()), (double)1.0E-10));
                }
                MatcherAssert.assertThat((Object)value.getValue(), (Matcher)Is.is(expectedValue));
            }
        }
    }

    @MethodSource(value={"getArgumentsForTestGraphicEnum"})
    @ParameterizedTest
    <T> void testGraphicEnum(String channelName, Class<T> clazz, T expectedValue, Alarm<?> expectedAlarm, String[] expectedLabels, boolean async) throws Throwable {
        try (Context context = new Context();
             Channel channel = context.createChannel(channelName, clazz);){
            Alarm value;
            Class gec;
            Assertions.assertDoesNotThrow(() -> (Channel)channel.connectAsync().get(10000L, TimeUnit.MILLISECONDS));
            if (async) {
                Status status = (Status)channel.putAsync(expectedValue).get(10000L, TimeUnit.MILLISECONDS);
                Assertions.assertTrue((boolean)status.isSuccessful());
            } else {
                channel.putNoWait(expectedValue);
            }
            Class clazz2 = gec = clazz.isArray() ? GraphicEnumArray.class : GraphicEnum.class;
            if (async) {
                value = (Alarm)channel.getAsync(gec).get(10000L, TimeUnit.MILLISECONDS);
                Assertions.assertNotNull((Object)value);
            } else {
                value = (Alarm)channel.get(gec);
            }
            MatcherAssert.assertThat((Object)value.getValue(), (Matcher)Is.is(expectedValue));
            MatcherAssert.assertThat((Object)value.getAlarmStatus(), (Matcher)Is.is((Object)expectedAlarm.getAlarmStatus()));
            MatcherAssert.assertThat((Object)value.getAlarmSeverity(), (Matcher)Is.is((Object)expectedAlarm.getAlarmSeverity()));
            String[] labels = clazz.isArray() ? ((GraphicEnumArray)value).getLabels() : ((GraphicEnum)value).getLabels();
            MatcherAssert.assertThat((Object)labels, (Matcher)Matchers.arrayContaining((Object[])expectedLabels));
        }
    }

    private static Stream<Arguments> getArgumentsForMonitorNotificationServiceImplementations() {
        List serviceImpls = MonitorNotificationServiceFactoryCreator.getAllServiceImplementations();
        return serviceImpls.stream().map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    private static Stream<Arguments> getArgumentsForTestPutAndGetValue() {
        List<Boolean> asyncOptions = Arrays.asList(false, true);
        return asyncOptions.stream().flatMap(async -> Stream.of(Arguments.of((Object[])new Object[]{"adc01", String.class, "12.346", async}), Arguments.of((Object[])new Object[]{"adc01", Short.class, (short)123, async}), Arguments.of((Object[])new Object[]{"adc01", Float.class, Float.valueOf(-123.4f), async}), Arguments.of((Object[])new Object[]{"adc01", Byte.class, (byte)100, async}), Arguments.of((Object[])new Object[]{"adc01", Integer.class, 123456, async}), Arguments.of((Object[])new Object[]{"adc01", Double.class, 12.3456, async}), Arguments.of((Object[])new Object[]{"adc01", String[].class, new String[]{"12.356", "3.112"}, async}), Arguments.of((Object[])new Object[]{"adc01", short[].class, new short[]{123, -321}, async}), Arguments.of((Object[])new Object[]{"adc01", float[].class, new float[]{-123.4f, 321.98f}, async}), Arguments.of((Object[])new Object[]{"adc01", byte[].class, new byte[]{120, -120}, async}), Arguments.of((Object[])new Object[]{"adc01", int[].class, new int[]{123456, 654321}, async}), Arguments.of((Object[])new Object[]{"adc01", double[].class, new double[]{12.82, 3.112}, async})));
    }

    private static Stream<Arguments> getArgumentsForTestPutAndGetMetadata() {
        Alarm alarm = new Alarm();
        alarm.setAlarmStatus(AlarmStatus.UDF_ALARM);
        alarm.setAlarmSeverity(AlarmSeverity.INVALID_ALARM);
        Control meta = new Control();
        meta.setUpperDisplay((Object)10.0);
        meta.setLowerDisplay((Object)-10.0);
        meta.setUpperAlarm((Object)9.0);
        meta.setLowerAlarm((Object)-9.0);
        meta.setUpperControl((Object)8.0);
        meta.setLowerControl((Object)-8.0);
        meta.setUpperWarning((Object)7.0);
        meta.setLowerWarning((Object)-7.0);
        meta.setUnits("units");
        meta.setPrecision(3);
        List<Class> metaTypeOptions = Arrays.asList(Alarm.class, Timestamped.class, Control.class, Graphic.class);
        return metaTypeOptions.stream().flatMap(metaType -> Stream.of(Arguments.of((Object[])new Object[]{"adc01", String.class, String.class, "12.346", metaType, alarm, meta, false}), Arguments.of((Object[])new Object[]{"adc01", Short.class, Short.class, (short)123, metaType, alarm, meta, false}), Arguments.of((Object[])new Object[]{"adc01", Float.class, Float.class, Float.valueOf(-123.4f), metaType, alarm, meta, false}), Arguments.of((Object[])new Object[]{"adc01", Byte.class, Byte.class, (byte)100, metaType, alarm, meta, false}), Arguments.of((Object[])new Object[]{"adc01", Integer.class, Integer.class, 123456, metaType, alarm, meta, false}), Arguments.of((Object[])new Object[]{"adc01", Double.class, Double.class, 12.3456, metaType, alarm, meta, false}), Arguments.of((Object[])new Object[]{"adc01", String.class, String.class, "12.346", metaType, alarm, meta, true}), Arguments.of((Object[])new Object[]{"adc01", Short.class, Short.class, (short)123, metaType, alarm, meta, true}), Arguments.of((Object[])new Object[]{"adc01", Float.class, Float.class, Float.valueOf(-123.4f), metaType, alarm, meta, true}), Arguments.of((Object[])new Object[]{"adc01", Byte.class, Byte.class, (byte)100, metaType, alarm, meta, true}), Arguments.of((Object[])new Object[]{"adc01", Integer.class, Integer.class, 123456, metaType, alarm, meta, true}), Arguments.of((Object[])new Object[]{"adc01", Double.class, Double.class, 12.3456, metaType, alarm, meta, true}), Arguments.of((Object[])new Object[]{"adc01", String[].class, String.class, new String[]{"12.356", "3.112"}, metaType, alarm, meta, false}), Arguments.of((Object[])new Object[]{"adc01", short[].class, Short.class, new short[]{123, -321}, metaType, alarm, meta, false}), Arguments.of((Object[])new Object[]{"adc01", float[].class, Float.class, new float[]{-123.4f, 321.98f}, metaType, alarm, meta, false}), Arguments.of((Object[])new Object[]{"adc01", byte[].class, Byte.class, new byte[]{120, -120}, metaType, alarm, meta, false}), Arguments.of((Object[])new Object[]{"adc01", int[].class, Integer.class, new int[]{123456, 654321}, metaType, alarm, meta, false}), Arguments.of((Object[])new Object[]{"adc01", double[].class, Double.class, new double[]{12.82, 3.112}, metaType, alarm, meta, false}), Arguments.of((Object[])new Object[]{"adc01", String[].class, String.class, new String[]{"12.356", "3.112"}, metaType, alarm, meta, true}), Arguments.of((Object[])new Object[]{"adc01", short[].class, Short.class, new short[]{123, -321}, metaType, alarm, meta, true}), Arguments.of((Object[])new Object[]{"adc01", float[].class, Float.class, new float[]{-123.4f, 321.98f}, metaType, alarm, meta, true}), Arguments.of((Object[])new Object[]{"adc01", byte[].class, Byte.class, new byte[]{120, -120}, metaType, alarm, meta, true}), Arguments.of((Object[])new Object[]{"adc01", int[].class, Integer.class, new int[]{123456, 654321}, metaType, alarm, meta, true}), Arguments.of((Object[])new Object[]{"adc01", double[].class, Double.class, new double[]{12.82, 3.112}, metaType, alarm, meta, true})));
    }

    private static Stream<Arguments> getArgumentsForTestGraphicEnum() {
        Alarm alarm = new Alarm();
        alarm.setAlarmStatus(AlarmStatus.UDF_ALARM);
        alarm.setAlarmSeverity(AlarmSeverity.INVALID_ALARM);
        String[] labels = new String[]{"zero", "one", "two", "three", "four", "five", "six", "seven"};
        List<Boolean> asyncOptions = Arrays.asList(false, true);
        return asyncOptions.stream().flatMap(async -> Stream.of(Arguments.of((Object[])new Object[]{"enum", Short.class, (short)2, alarm, labels, async}), Arguments.of((Object[])new Object[]{"enum", Short.class, (short)3, alarm, labels, async}), Arguments.of((Object[])new Object[]{"enum", short[].class, new short[]{4, 2}, alarm, labels, async}), Arguments.of((Object[])new Object[]{"enum", short[].class, new short[]{1, 3}, alarm, labels, async})));
    }

    static interface GenericIntegerConsumer
    extends Consumer<Integer> {
    }
}

