/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.logging.Logger;
import net.jcip.annotations.ThreadSafe;
import org.apache.commons.lang3.Validate;
import org.epics.ca.util.logging.LibraryLogManager;

@ThreadSafe
public class NotificationConsumer<T>
implements Consumer<T> {
    private static final Logger logger = LibraryLogManager.getLogger(NotificationConsumer.class);
    private static CountDownLatch expectedTotalNotificationCountDetectionLatch;
    private static final AtomicLong expectedTotalNotificationCount;
    private static final AtomicLong currentTotalNotificationCount;
    private final AtomicLong currentNotificationCount = new AtomicLong();
    private final AtomicLong expectedNotificationCount = new AtomicLong();
    private CountDownLatch expectedNotificationCountDetectionLatch;
    private final AtomicReference<T> lastNotificationValue = new AtomicReference();
    private final AtomicReference<T> expectedNotificationValue = new AtomicReference();
    private CountDownLatch expectedNotificationValueDetectionLatch;
    private final AtomicBoolean notificationSequenceWasMonotonic = new AtomicBoolean(true);
    private final AtomicBoolean notificationSequenceWasConsecutive = new AtomicBoolean(true);
    private final ConsumerType consumerType;
    private final long delayTimeInNanoseconds;

    public NotificationConsumer(ConsumerType type, long delayTime, TimeUnit timeUnit) {
        Validate.notNull((Object)((Object)type));
        Validate.isTrue((delayTime >= 0L ? 1 : 0) != 0, (String)"greater than zero", (Object[])new Object[0]);
        this.consumerType = type;
        switch (timeUnit) {
            case NANOSECONDS: {
                this.delayTimeInNanoseconds = delayTime;
                break;
            }
            case MICROSECONDS: {
                this.delayTimeInNanoseconds = delayTime * 1000L;
                break;
            }
            case MILLISECONDS: {
                this.delayTimeInNanoseconds = delayTime * 1000000L;
                break;
            }
            case SECONDS: {
                this.delayTimeInNanoseconds = delayTime * 1000000000L;
                break;
            }
            default: {
                throw new RuntimeException("Unsupported TimeUnit: " + (Object)((Object)timeUnit));
            }
        }
        this.lastNotificationValue.set(null);
        this.currentNotificationCount.set(0L);
    }

    public static <T> NotificationConsumer<T> getNormalConsumer() {
        long notUsedValue = 0L;
        return new NotificationConsumer<T>(ConsumerType.NORMAL, 0L, TimeUnit.SECONDS);
    }

    public static <T> NotificationConsumer<T> getThreadSleepingSlowConsumer(long delayTime, TimeUnit timeUnit) {
        return new NotificationConsumer<T>(ConsumerType.SLOW_WITH_THREAD_SLEEP, delayTime, timeUnit);
    }

    public static <T> NotificationConsumer<T> getBusyWaitingSlowConsumer(long delayTime, TimeUnit timeUnit) {
        return new NotificationConsumer<T>(ConsumerType.SLOW_WITH_BUSY_WAIT, delayTime, timeUnit);
    }

    public static long getCurrentTotalNotificationCount() {
        return currentTotalNotificationCount.get();
    }

    public static void clearCurrentTotalNotificationCount() {
        currentTotalNotificationCount.set(0L);
    }

    public static void setExpectedTotalNotificationCount(int count) {
        expectedTotalNotificationCount.set(count);
        expectedTotalNotificationCountDetectionLatch = new CountDownLatch(1);
    }

    public long getCurrentNotificationCount() {
        return this.currentNotificationCount.get();
    }

    public void clearCurrentNotificationCount() {
        this.currentNotificationCount.set(0L);
    }

    public void setExpectedNotificationCount(int count) {
        this.expectedNotificationCount.set(count);
        this.expectedNotificationCountDetectionLatch = new CountDownLatch(1);
    }

    public void setExpectedNotificationValue(T value) {
        this.expectedNotificationValue.set(value);
        this.expectedNotificationValueDetectionLatch = new CountDownLatch(1);
    }

    public void setNotificationSequenceWasMonotonic() {
        this.notificationSequenceWasMonotonic.set(true);
    }

    public void setNotificationSequenceWasConsecutive() {
        this.notificationSequenceWasConsecutive.set(true);
    }

    public boolean getNotificationSequenceWasMonotonic() {
        return this.notificationSequenceWasMonotonic.get();
    }

    public boolean getNotificationSequenceWasConsecutive() {
        return this.notificationSequenceWasConsecutive.get();
    }

    public static void awaitExpectedTotalNotificationCount() {
        try {
            expectedTotalNotificationCountDetectionLatch.await();
        }
        catch (InterruptedException ex) {
            logger.warning("Unexpectedly interrupted from await");
            Thread.currentThread().interrupt();
        }
    }

    public void awaitExpectedNotificationCount() {
        try {
            this.expectedNotificationCountDetectionLatch.await();
        }
        catch (InterruptedException ex) {
            logger.warning("Unexpectedly interrupted from await");
            Thread.currentThread().interrupt();
        }
    }

    public void awaitExpectedNotificationValue() {
        try {
            this.expectedNotificationValueDetectionLatch.await();
        }
        catch (InterruptedException ex) {
            logger.warning("Unexpectedly interrupted from await");
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void accept(T newValue) {
        logger.finest(String.format("Consumer: Thread: %s has notified me with value %s", Thread.currentThread(), newValue));
        this.simulateProcessingTime(this.delayTimeInNanoseconds);
        this.currentNotificationCount.incrementAndGet();
        currentTotalNotificationCount.incrementAndGet();
        if (this.expectedNotificationValueDetectionLatch != null && newValue.equals(this.expectedNotificationValue.get())) {
            this.expectedNotificationValueDetectionLatch.countDown();
        }
        if (this.expectedNotificationCountDetectionLatch != null && this.currentNotificationCount.get() == this.expectedNotificationCount.get()) {
            this.expectedNotificationCountDetectionLatch.countDown();
        }
        if (expectedTotalNotificationCountDetectionLatch != null && currentTotalNotificationCount.get() == expectedTotalNotificationCount.get()) {
            expectedTotalNotificationCountDetectionLatch.countDown();
        }
        if (this.lastNotificationValue.get() != null && this.lastNotificationValue.get() instanceof Integer && newValue instanceof Integer) {
            if ((Integer)newValue < (Integer)this.lastNotificationValue.get()) {
                this.notificationSequenceWasMonotonic.set(false);
            }
            if ((Integer)newValue != (Integer)this.lastNotificationValue.get() + 1) {
                this.notificationSequenceWasConsecutive.set(false);
            }
        }
        this.lastNotificationValue.set(newValue);
        logger.finest(String.format("Consumer: Thread %s has finished consuming", Thread.currentThread()));
    }

    public T getLastNotificationValue() {
        return this.lastNotificationValue.get();
    }

    public String toString() {
        return "NotificationConsumer<" + (Object)((Object)this.consumerType) + "," + this.delayTimeInNanoseconds + '>';
    }

    private void simulateProcessingTime(long delayTimeInNanoseconds) {
        switch (this.consumerType) {
            case NORMAL: {
                break;
            }
            case SLOW_WITH_BUSY_WAIT: {
                NotificationConsumer.busyWait(delayTimeInNanoseconds);
                break;
            }
            case SLOW_WITH_THREAD_SLEEP: {
                NotificationConsumer.threadSleep(delayTimeInNanoseconds);
            }
        }
    }

    private static void threadSleep(long delaytimeInNanoseconds) {
        try {
            logger.finest(String.format("Sleep request for %d nanoseconds", delaytimeInNanoseconds));
            long millis = delaytimeInNanoseconds / 1000000L;
            long nanos = delaytimeInNanoseconds % 1000000L;
            logger.finest(String.format("Sleeping for %d millis and %d nanos", millis, nanos));
            Thread.sleep(millis, (int)nanos);
            logger.finest("Done with sleeping");
        }
        catch (InterruptedException ex) {
            logger.finest("Unexpectedly awoke from sleep");
            Thread.currentThread().interrupt();
        }
    }

    private static void busyWait(long delaytimeInNanoseconds) {
        long startTime = System.nanoTime();
        long endTime = startTime + delaytimeInNanoseconds;
        while (System.nanoTime() < endTime) {
            NotificationConsumer.noop();
        }
    }

    private static void noop() {
    }

    static {
        expectedTotalNotificationCount = new AtomicLong();
        currentTotalNotificationCount = new AtomicLong();
    }

    public static enum ConsumerType {
        NORMAL,
        SLOW_WITH_THREAD_SLEEP,
        SLOW_WITH_BUSY_WAIT;

    }
}

