/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.impl;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.apache.commons.lang3.time.StopWatch;
import org.epics.ca.impl.ContextImpl;
import org.epics.ca.impl.Header;
import org.epics.ca.impl.ResponseHandlers;
import org.epics.ca.impl.TcpTransport;
import org.epics.ca.impl.Transport;
import org.epics.ca.impl.TransportClient;
import org.epics.ca.impl.TransportRegistry;
import org.epics.ca.impl.reactor.Reactor;
import org.epics.ca.util.logging.LibraryLogManager;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class TcpTransportTest {
    private static final Logger logger = LibraryLogManager.getLogger(TcpTransportTest.class);
    private ContextImpl context;
    private SocketChannel channel;
    private TcpTransport transport;
    private ResponseHandlers.ResponseHandler handler;

    TcpTransportTest() {
    }

    @BeforeEach
    void setupTcpTransport() {
        this.context = (ContextImpl)Mockito.mock(ContextImpl.class);
        TransportClient client = (TransportClient)Mockito.mock(TransportClient.class);
        this.handler = (ResponseHandlers.ResponseHandler)Mockito.mock(ResponseHandlers.ResponseHandler.class);
        this.channel = (SocketChannel)Mockito.mock(SocketChannel.class);
        int minorRevision = 2;
        boolean priority = true;
        InetSocketAddress socketAddress = new InetSocketAddress(1234);
        ScheduledFuture scheduledFuture = (ScheduledFuture)Mockito.mock(ScheduledFuture.class);
        ScheduledExecutorService scheduledExecutorService = (ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class);
        TransportRegistry transportRegistry = (TransportRegistry)Mockito.mock(TransportRegistry.class);
        Socket socket = (Socket)Mockito.mock(Socket.class);
        Mockito.when((Object)this.channel.socket()).thenReturn((Object)socket);
        Mockito.when((Object)socket.getRemoteSocketAddress()).thenReturn((Object)socketAddress);
        Mockito.when((Object)this.context.getScheduledExecutor()).thenReturn((Object)scheduledExecutorService);
        Mockito.when(scheduledExecutorService.scheduleWithFixedDelay((Runnable)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any()))).thenReturn((Object)scheduledFuture);
        Mockito.when((Object)this.context.getTransportRegistry()).thenReturn((Object)transportRegistry);
        this.transport = new TcpTransport(this.context, client, this.handler, this.channel, 2, 1);
    }

    @AfterEach
    void afterEach() {
        Reactor reactor = (Reactor)Mockito.mock(Reactor.class);
        ArgumentCaptor captor = ArgumentCaptor.forClass(SelectableChannel.class);
        Mockito.when((Object)this.context.getReactor()).thenReturn((Object)reactor);
        this.transport.close(false);
        ((Reactor)Mockito.verify((Object)reactor)).unregisterAndClose((SelectableChannel)captor.capture());
    }

    @Test
    void testCaCommandWithNoPayload_HeaderSuppliedInOneChunk() throws IOException {
        int cmdVersion = 23;
        boolean payloadSize = false;
        boolean dataType = true;
        boolean dataCount = false;
        int param1 = -559038737;
        int param2 = -625234688;
        ByteBuffer bufSocketRead1 = (ByteBuffer)ByteBuffer.allocate(16).putShort((short)23).putShort((short)0).putShort((short)1).putShort((short)0).putInt(-559038737).putInt(-625234688).flip();
        Mockito.when((Object)this.channel.read((ByteBuffer)ArgumentMatchers.any())).thenAnswer(i -> {
            ByteBuffer suppliedBuf = (ByteBuffer)i.getArgument(0);
            suppliedBuf.put(bufSocketRead1);
            return 16;
        }).thenAnswer(i -> 0);
        SelectionKey selectionKey = (SelectionKey)Mockito.mock(SelectionKey.class);
        Mockito.when((Object)selectionKey.isValid()).thenReturn((Object)true);
        Mockito.when((Object)selectionKey.readyOps()).thenReturn((Object)1);
        this.transport.handleEvent(selectionKey);
        ArgumentCaptor captor1 = ArgumentCaptor.forClass(InetSocketAddress.class);
        ArgumentCaptor captor2 = ArgumentCaptor.forClass(Transport.class);
        ArgumentCaptor captor3 = ArgumentCaptor.forClass(Header.class);
        ArgumentCaptor captor4 = ArgumentCaptor.forClass(ByteBuffer.class);
        ((ResponseHandlers.ResponseHandler)Mockito.verify((Object)this.handler)).handleResponse((InetSocketAddress)captor1.capture(), (Transport)captor2.capture(), (Header)captor3.capture(), (ByteBuffer)captor4.capture());
        Assertions.assertEquals((int)1234, (int)((InetSocketAddress)captor1.getValue()).getPort());
        Assertions.assertEquals((Object)this.transport, (Object)captor2.getValue());
        Assertions.assertEquals((int)23, (int)((Header)captor3.getValue()).command);
        Assertions.assertEquals((int)0, (int)((Header)captor3.getValue()).payloadSize);
        Assertions.assertEquals((int)1, (int)((Header)captor3.getValue()).dataType);
        Assertions.assertEquals((int)0, (int)((Header)captor3.getValue()).dataCount);
        Assertions.assertEquals((int)-559038737, (int)((Header)captor3.getValue()).parameter1);
        Assertions.assertEquals((int)-625234688, (int)((Header)captor3.getValue()).parameter2);
        Assertions.assertEquals((int)23, (int)((ByteBuffer)captor4.getValue()).getShort(0));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.handler});
    }

    @Test
    void testCaCommandWithNoPayload_HeaderSuppliedInTwoChunks() throws IOException {
        int cmdVersion = 23;
        boolean payloadSize = false;
        boolean dataType = true;
        boolean dataCount = false;
        int param1 = -559038737;
        int param2 = -625234688;
        ByteBuffer bufSocketRead1 = (ByteBuffer)ByteBuffer.allocate(8).putShort((short)23).putShort((short)0).putShort((short)1).putShort((short)0).flip();
        ByteBuffer bufSocketRead2 = (ByteBuffer)ByteBuffer.allocate(8).putInt(-559038737).putInt(-625234688).flip();
        Mockito.when((Object)this.channel.read((ByteBuffer)ArgumentMatchers.any())).thenAnswer(i -> {
            ByteBuffer suppliedBuf = (ByteBuffer)i.getArgument(0);
            suppliedBuf.put(bufSocketRead1);
            return 8;
        }).thenAnswer(i -> {
            ByteBuffer suppliedBuf = (ByteBuffer)i.getArgument(0);
            suppliedBuf.put(bufSocketRead2);
            return 8;
        }).thenAnswer(i -> 0);
        SelectionKey selectionKey = (SelectionKey)Mockito.mock(SelectionKey.class);
        Mockito.when((Object)selectionKey.isValid()).thenReturn((Object)true);
        Mockito.when((Object)selectionKey.readyOps()).thenReturn((Object)1);
        this.transport.handleEvent(selectionKey);
        ArgumentCaptor captor1 = ArgumentCaptor.forClass(InetSocketAddress.class);
        ArgumentCaptor captor2 = ArgumentCaptor.forClass(Transport.class);
        ArgumentCaptor captor3 = ArgumentCaptor.forClass(Header.class);
        ArgumentCaptor captor4 = ArgumentCaptor.forClass(ByteBuffer.class);
        ((ResponseHandlers.ResponseHandler)Mockito.verify((Object)this.handler)).handleResponse((InetSocketAddress)captor1.capture(), (Transport)captor2.capture(), (Header)captor3.capture(), (ByteBuffer)captor4.capture());
        Assertions.assertEquals((int)1234, (int)((InetSocketAddress)captor1.getValue()).getPort());
        Assertions.assertEquals((Object)this.transport, (Object)captor2.getValue());
        Assertions.assertEquals((int)23, (int)((Header)captor3.getValue()).command);
        Assertions.assertEquals((int)0, (int)((Header)captor3.getValue()).payloadSize);
        Assertions.assertEquals((int)1, (int)((Header)captor3.getValue()).dataType);
        Assertions.assertEquals((int)0, (int)((Header)captor3.getValue()).dataCount);
        Assertions.assertEquals((int)-559038737, (int)((Header)captor3.getValue()).parameter1);
        Assertions.assertEquals((int)-625234688, (int)((Header)captor3.getValue()).parameter2);
        Assertions.assertEquals((int)23, (int)((ByteBuffer)captor4.getValue()).getShort(0));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.handler});
    }

    @Test
    void testCaCommandWithPayload_HeaderSuppliedInOneChunk() throws IOException {
        int cmdVersion = 15;
        int payloadSize = 4;
        int dataType = 5;
        boolean dataCount = true;
        int param1 = -559038737;
        int param2 = -625234688;
        ByteBuffer bufSocketRead1 = (ByteBuffer)ByteBuffer.allocate(16).putShort((short)15).putShort((short)4).putShort((short)5).putShort((short)1).putInt(-559038737).putInt(-625234688).flip();
        ByteBuffer bufSocketRead2 = (ByteBuffer)ByteBuffer.allocate(4).putInt(-889275714).flip();
        Mockito.when((Object)this.channel.read((ByteBuffer)ArgumentMatchers.any())).thenAnswer(i -> {
            ByteBuffer suppliedBuf = (ByteBuffer)i.getArgument(0);
            suppliedBuf.put(bufSocketRead1);
            return 16;
        }).thenAnswer(i -> {
            ByteBuffer suppliedBuf = (ByteBuffer)i.getArgument(0);
            suppliedBuf.put(bufSocketRead2);
            return 4;
        }).thenAnswer(i -> 0);
        SelectionKey selectionKey = (SelectionKey)Mockito.mock(SelectionKey.class);
        Mockito.when((Object)selectionKey.isValid()).thenReturn((Object)true);
        Mockito.when((Object)selectionKey.readyOps()).thenReturn((Object)1);
        this.transport.handleEvent(selectionKey);
        ArgumentCaptor captor1 = ArgumentCaptor.forClass(InetSocketAddress.class);
        ArgumentCaptor captor2 = ArgumentCaptor.forClass(Transport.class);
        ArgumentCaptor captor3 = ArgumentCaptor.forClass(Header.class);
        ArgumentCaptor captor4 = ArgumentCaptor.forClass(ByteBuffer.class);
        ((ResponseHandlers.ResponseHandler)Mockito.verify((Object)this.handler)).handleResponse((InetSocketAddress)captor1.capture(), (Transport)captor2.capture(), (Header)captor3.capture(), (ByteBuffer)captor4.capture());
        Assertions.assertEquals((int)1234, (int)((InetSocketAddress)captor1.getValue()).getPort());
        Assertions.assertEquals((Object)this.transport, (Object)captor2.getValue());
        Assertions.assertEquals((int)15, (int)((Header)captor3.getValue()).command);
        Assertions.assertEquals((int)4, (int)((Header)captor3.getValue()).payloadSize);
        Assertions.assertEquals((int)5, (int)((Header)captor3.getValue()).dataType);
        Assertions.assertEquals((int)1, (int)((Header)captor3.getValue()).dataCount);
        Assertions.assertEquals((int)-559038737, (int)((Header)captor3.getValue()).parameter1);
        Assertions.assertEquals((int)-625234688, (int)((Header)captor3.getValue()).parameter2);
        Assertions.assertEquals((int)15, (int)((ByteBuffer)captor4.getValue()).getShort(0));
        Assertions.assertEquals((int)-889275714, (int)((ByteBuffer)captor4.getValue()).getInt(16));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.handler});
    }

    @Test
    void testCaCommandWithPayload_HeaderSuppliedInTwoChunks() throws IOException {
        int cmdVersion = 15;
        int payloadSize = 4;
        int dataType = 2;
        boolean dataCount = true;
        int param1 = -559038737;
        int param2 = -625234688;
        ByteBuffer bufSocketRead1 = (ByteBuffer)ByteBuffer.allocate(8).putShort((short)15).putShort((short)4).putShort((short)2).putShort((short)1).flip();
        ByteBuffer bufSocketRead2 = (ByteBuffer)ByteBuffer.allocate(8).putInt(-559038737).putInt(-625234688).flip();
        ByteBuffer bufSocketRead3 = (ByteBuffer)ByteBuffer.allocate(4).putFloat(1234.5677f).flip();
        Mockito.when((Object)this.channel.read((ByteBuffer)ArgumentMatchers.any())).thenAnswer(i -> {
            ByteBuffer suppliedBuf = (ByteBuffer)i.getArgument(0);
            suppliedBuf.put(bufSocketRead1);
            return 8;
        }).thenAnswer(i -> {
            ByteBuffer suppliedBuf = (ByteBuffer)i.getArgument(0);
            suppliedBuf.put(bufSocketRead2);
            return 8;
        }).thenAnswer(i -> {
            ByteBuffer suppliedBuf = (ByteBuffer)i.getArgument(0);
            suppliedBuf.put(bufSocketRead3);
            return 4;
        }).thenAnswer(i -> 0);
        SelectionKey selectionKey = (SelectionKey)Mockito.mock(SelectionKey.class);
        Mockito.when((Object)selectionKey.isValid()).thenReturn((Object)true);
        Mockito.when((Object)selectionKey.readyOps()).thenReturn((Object)1);
        this.transport.handleEvent(selectionKey);
        ArgumentCaptor captor1 = ArgumentCaptor.forClass(InetSocketAddress.class);
        ArgumentCaptor captor2 = ArgumentCaptor.forClass(Transport.class);
        ArgumentCaptor captor3 = ArgumentCaptor.forClass(Header.class);
        ArgumentCaptor captor4 = ArgumentCaptor.forClass(ByteBuffer.class);
        ((ResponseHandlers.ResponseHandler)Mockito.verify((Object)this.handler)).handleResponse((InetSocketAddress)captor1.capture(), (Transport)captor2.capture(), (Header)captor3.capture(), (ByteBuffer)captor4.capture());
        Assertions.assertEquals((int)1234, (int)((InetSocketAddress)captor1.getValue()).getPort());
        Assertions.assertEquals((Object)this.transport, (Object)captor2.getValue());
        Assertions.assertEquals((int)15, (int)((Header)captor3.getValue()).command);
        Assertions.assertEquals((int)4, (int)((Header)captor3.getValue()).payloadSize);
        Assertions.assertEquals((int)2, (int)((Header)captor3.getValue()).dataType);
        Assertions.assertEquals((int)1, (int)((Header)captor3.getValue()).dataCount);
        Assertions.assertEquals((int)-559038737, (int)((Header)captor3.getValue()).parameter1);
        Assertions.assertEquals((int)-625234688, (int)((Header)captor3.getValue()).parameter2);
        Assertions.assertEquals((int)15, (int)((ByteBuffer)captor4.getValue()).getShort(0));
        Assertions.assertEquals((float)1234.5677f, (float)((ByteBuffer)captor4.getValue()).getFloat(16));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.handler});
    }

    @Test
    void testCaCommandWithPayload_HeaderAndPayloadSplitDifferently() throws IOException {
        int cmdVersion = 15;
        int payloadSize = 4;
        int dataType = 5;
        boolean dataCount = true;
        int param1 = -559038737;
        int param2 = -625234688;
        ByteBuffer bufSocketRead1 = (ByteBuffer)ByteBuffer.allocate(12).putShort((short)15).putShort((short)4).putShort((short)5).putShort((short)1).putInt(-559038737).flip();
        ByteBuffer bufSocketRead2 = (ByteBuffer)ByteBuffer.allocate(8).putInt(-625234688).putInt(-889275714).flip();
        Mockito.when((Object)this.channel.read((ByteBuffer)ArgumentMatchers.any())).thenAnswer(i -> {
            ByteBuffer suppliedBuf = (ByteBuffer)i.getArgument(0);
            suppliedBuf.put(bufSocketRead1);
            return 16;
        }).thenAnswer(i -> {
            ByteBuffer suppliedBuf = (ByteBuffer)i.getArgument(0);
            suppliedBuf.put(bufSocketRead2);
            return 4;
        }).thenAnswer(i -> 0);
        SelectionKey selectionKey = (SelectionKey)Mockito.mock(SelectionKey.class);
        Mockito.when((Object)selectionKey.isValid()).thenReturn((Object)true);
        Mockito.when((Object)selectionKey.readyOps()).thenReturn((Object)1);
        this.transport.handleEvent(selectionKey);
        ArgumentCaptor captor1 = ArgumentCaptor.forClass(InetSocketAddress.class);
        ArgumentCaptor captor2 = ArgumentCaptor.forClass(Transport.class);
        ArgumentCaptor captor3 = ArgumentCaptor.forClass(Header.class);
        ArgumentCaptor captor4 = ArgumentCaptor.forClass(ByteBuffer.class);
        ((ResponseHandlers.ResponseHandler)Mockito.verify((Object)this.handler)).handleResponse((InetSocketAddress)captor1.capture(), (Transport)captor2.capture(), (Header)captor3.capture(), (ByteBuffer)captor4.capture());
        Assertions.assertEquals((int)1234, (int)((InetSocketAddress)captor1.getValue()).getPort());
        Assertions.assertEquals((Object)this.transport, (Object)captor2.getValue());
        Assertions.assertEquals((int)15, (int)((Header)captor3.getValue()).command);
        Assertions.assertEquals((int)4, (int)((Header)captor3.getValue()).payloadSize);
        Assertions.assertEquals((int)5, (int)((Header)captor3.getValue()).dataType);
        Assertions.assertEquals((int)1, (int)((Header)captor3.getValue()).dataCount);
        Assertions.assertEquals((int)-559038737, (int)((Header)captor3.getValue()).parameter1);
        Assertions.assertEquals((int)-625234688, (int)((Header)captor3.getValue()).parameter2);
        Assertions.assertEquals((int)15, (int)((ByteBuffer)captor4.getValue()).getShort(0));
        Assertions.assertEquals((int)-889275714, (int)((ByteBuffer)captor4.getValue()).getInt(16));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.handler});
    }

    @MethodSource(value={"getArgumentsForCaLatencyTest"})
    @ParameterizedTest
    void testCaReadLatency(int maximumExecutionTimeInMicroseconds) throws IOException {
        int cmdVersion = 15;
        int payloadSize = 4;
        int dataType = 5;
        boolean dataCount = true;
        int param1 = -559038737;
        int param2 = -625234688;
        ByteBuffer bufSocketRead1 = (ByteBuffer)ByteBuffer.allocate(20).putShort((short)15).putShort((short)4).putShort((short)5).putShort((short)1).putInt(-559038737).putInt(-625234688).putInt(-889275714).flip();
        Mockito.when((Object)this.channel.read((ByteBuffer)ArgumentMatchers.any())).thenAnswer(i -> {
            ByteBuffer suppliedBuf = (ByteBuffer)i.getArgument(0);
            suppliedBuf.put(bufSocketRead1);
            return 20;
        }).thenAnswer(i -> 0);
        SelectionKey selectionKey = (SelectionKey)Mockito.mock(SelectionKey.class);
        Mockito.when((Object)selectionKey.isValid()).thenReturn((Object)true);
        Mockito.when((Object)selectionKey.readyOps()).thenReturn((Object)1);
        ArgumentCaptor captor1 = ArgumentCaptor.forClass(InetSocketAddress.class);
        ArgumentCaptor captor2 = ArgumentCaptor.forClass(Transport.class);
        ArgumentCaptor captor3 = ArgumentCaptor.forClass(Header.class);
        ArgumentCaptor captor4 = ArgumentCaptor.forClass(ByteBuffer.class);
        StopWatch s = StopWatch.createStarted();
        this.transport.handleEvent(selectionKey);
        long elapsedTimeInMicroseconds = s.getTime(TimeUnit.MICROSECONDS);
        logger.log(Level.INFO, String.format("Transport latency time was '%.3f' ", Float.valueOf((float)elapsedTimeInMicroseconds / 1000.0f)) + "ms");
        ((ResponseHandlers.ResponseHandler)Mockito.verify((Object)this.handler)).handleResponse((InetSocketAddress)captor1.capture(), (Transport)captor2.capture(), (Header)captor3.capture(), (ByteBuffer)captor4.capture());
        Assertions.assertEquals((int)1234, (int)((InetSocketAddress)captor1.getValue()).getPort());
        Assertions.assertEquals((Object)this.transport, (Object)captor2.getValue());
        Assertions.assertEquals((int)15, (int)((Header)captor3.getValue()).command);
        Assertions.assertEquals((int)4, (int)((Header)captor3.getValue()).payloadSize);
        Assertions.assertEquals((int)5, (int)((Header)captor3.getValue()).dataType);
        Assertions.assertEquals((int)1, (int)((Header)captor3.getValue()).dataCount);
        Assertions.assertEquals((int)-559038737, (int)((Header)captor3.getValue()).parameter1);
        Assertions.assertEquals((int)-625234688, (int)((Header)captor3.getValue()).parameter2);
        Assertions.assertEquals((int)15, (int)((ByteBuffer)captor4.getValue()).getShort(0));
        Assertions.assertEquals((int)-889275714, (int)((ByteBuffer)captor4.getValue()).getInt(16));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.handler});
        Assertions.assertTrue((elapsedTimeInMicroseconds < (long)maximumExecutionTimeInMicroseconds ? 1 : 0) != 0, (String)("Actual Execution Time was: " + elapsedTimeInMicroseconds + " us. Maximum Execution Time was: " + maximumExecutionTimeInMicroseconds + " us."));
    }

    private static Stream<Arguments> getArgumentsForCaLatencyTest() {
        return Stream.of(Arguments.of((Object[])new Object[]{100000}), Arguments.of((Object[])new Object[]{25000}), Arguments.of((Object[])new Object[]{25000}), Arguments.of((Object[])new Object[]{25000}), Arguments.of((Object[])new Object[]{25000}), Arguments.of((Object[])new Object[]{25000}), Arguments.of((Object[])new Object[]{25000}));
    }
}

