/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.impl.monitor;

import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.epics.ca.ThreadWatcher;
import org.epics.ca.impl.monitor.MonitorNotificationService;
import org.epics.ca.impl.monitor.MonitorNotificationServiceFactory;
import org.epics.ca.impl.monitor.MonitorNotificationServiceFactoryCreator;
import org.epics.ca.util.logging.LibraryLogManager;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class MonitorNotificationServiceFactoryCreatorTest {
    private static final Logger logger = LibraryLogManager.getLogger(MonitorNotificationServiceFactoryCreatorTest.class);
    private ThreadWatcher threadWatcher;

    MonitorNotificationServiceFactoryCreatorTest() {
    }

    @BeforeEach
    void beforeEach() {
        this.threadWatcher = ThreadWatcher.start();
    }

    @AfterEach
    void afterEach() {
        this.threadWatcher.verify();
    }

    @Test
    void testCreateMonitorNotificationServiceFactory_ThrowsNullPointerExceptionWhenServiceImplConfigurationNull() {
        Assertions.assertThrows(NullPointerException.class, () -> MonitorNotificationServiceFactoryCreator.create(null));
    }

    @Test
    void testCreateMonitorNotificationServiceFactory_ThrowsIllegalArgumentExceptionWhenServiceImplConfigurationNotRecognised() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> MonitorNotificationServiceFactoryCreator.create((String)"ThisConfigIsBananas"));
    }

    @MethodSource(value={"getMonitorNotificationServiceImplementations"})
    @ParameterizedTest
    void testCreateMonitorNotificationServiceFactory_expected_configurations_are_recognised(String serviceImpl) {
        try (MonitorNotificationServiceFactory factory = MonitorNotificationServiceFactoryCreator.create((String)serviceImpl);){
            Assertions.assertNotNull((Object)factory);
        }
    }

    @MethodSource(value={"getArgumentsForTestMonitorNotificationServiceImpl_NumberOfServiceThreadsArgumentProcessing"})
    @ParameterizedTest
    void testMonitorNotificationServiceImpl_NumberOfServiceThreadsArgumentProcessing(String serviceImpl, int expectedThreads) {
        try (MonitorNotificationServiceFactory factory = MonitorNotificationServiceFactoryCreator.create((String)serviceImpl);){
            Assertions.assertEquals((int)expectedThreads, (int)factory.getQosMetricNumberOfNotificationThreadsPerConsumer());
        }
    }

    @MethodSource(value={"getArgumentsForTestMonitorNotificationServiceImpl_BufferSizeArgumentProcessing"})
    @ParameterizedTest
    void testMonitorNotificationServiceImpl_BufferSizeArgumentProcessing(String serviceImpl, boolean expectedIsBuffered, int expectedBufferSize) {
        try (MonitorNotificationServiceFactory factory = MonitorNotificationServiceFactoryCreator.create((String)serviceImpl);){
            Assertions.assertEquals((Object)expectedIsBuffered, (Object)factory.getQosMetricIsBuffered());
            Assertions.assertEquals((int)expectedBufferSize, (int)factory.getQosMetricBufferSizePerConsumer());
        }
    }

    @ParameterizedTest
    @MethodSource(value={"getArgumentsForTestServiceImplBufferingBehaviour"})
    void testServiceImplBufferingBehaviour(String serviceImpl, boolean expectedResult) {
        try (MonitorNotificationServiceFactory factory = MonitorNotificationServiceFactoryCreator.create((String)serviceImpl);){
            Assertions.assertEquals((Object)expectedResult, (Object)factory.getQosMetricIsBuffered());
        }
    }

    @MethodSource(value={"getMonitorNotificationServiceImplementations"})
    @ParameterizedTest
    void testServiceImplResourceDisposeBehaviour_checkFactoryAutoClose(String serviceImpl) {
        logger.info(String.format("Testing resource autoclose behaviour of service implementation: '%s'", serviceImpl + ",50"));
        ThreadWatcher threadWatcher = ThreadWatcher.start();
        try (MonitorNotificationServiceFactory factory = MonitorNotificationServiceFactoryCreator.create((String)(serviceImpl + ",50"));){
            MonitorNotificationService service = factory.getServiceForConsumer(v -> {});
            service.publish((Object)123L);
        }
        threadWatcher.verify();
    }

    @MethodSource(value={"getMonitorNotificationServiceImplementations"})
    @ParameterizedTest
    void testServiceImplResourceDisposeBehaviour_checkFactoryManualClose(String serviceImpl) {
        logger.info(String.format("Testing resource autoclose behaviour of service implementation: '%s'", serviceImpl + ",50"));
        ThreadWatcher threadWatcher = ThreadWatcher.start();
        MonitorNotificationServiceFactory factory = MonitorNotificationServiceFactoryCreator.create((String)(serviceImpl + ",50"));
        MonitorNotificationService service = factory.getServiceForConsumer(v -> {});
        service.publish((Object)123L);
        factory.close();
        threadWatcher.verify();
    }

    private static Stream<Arguments> getMonitorNotificationServiceImplementations() {
        List allConfigurations = MonitorNotificationServiceFactoryCreator.getAllServiceImplementations();
        return allConfigurations.stream().map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    private static Stream<Arguments> getArgumentsForTestMonitorNotificationServiceImpl_BufferSizeArgumentProcessing() {
        return Stream.of(Arguments.of((Object[])new Object[]{"StripedExecutorServiceMonitorNotificationServiceImpl", true, Integer.MAX_VALUE}), Arguments.of((Object[])new Object[]{"StripedExecutorServiceMonitorNotificationServiceImpl,,100", true, Integer.MAX_VALUE}), Arguments.of((Object[])new Object[]{"StripedExecutorServiceMonitorNotificationServiceImpl,5,100", true, Integer.MAX_VALUE}), Arguments.of((Object[])new Object[]{"BlockingQueueSingleWorkerMonitorNotificationServiceImpl", true, Integer.MAX_VALUE}), Arguments.of((Object[])new Object[]{"BlockingQueueSingleWorkerMonitorNotificationServiceImpl,,1", false, 1}), Arguments.of((Object[])new Object[]{"BlockingQueueSingleWorkerMonitorNotificationServiceImpl,,22", true, 22}), Arguments.of((Object[])new Object[]{"BlockingQueueSingleWorkerMonitorNotificationServiceImpl,15,79", true, 79}), Arguments.of((Object[])new Object[]{"BlockingQueueMultipleWorkerMonitorNotificationServiceImpl,,1", false, 1}), Arguments.of((Object[])new Object[]{"BlockingQueueMultipleWorkerMonitorNotificationServiceImpl,,42", true, 42}), Arguments.of((Object[])new Object[]{"BlockingQueueMultipleWorkerMonitorNotificationServiceImpl,15,19", true, 19}));
    }

    private static Stream<Arguments> getArgumentsForTestMonitorNotificationServiceImpl_NumberOfServiceThreadsArgumentProcessing() {
        return Stream.of(Arguments.of((Object[])new Object[]{"StripedExecutorServiceMonitorNotificationServiceImpl", 10}), Arguments.of((Object[])new Object[]{"StripedExecutorServiceMonitorNotificationServiceImpl,66", 66}), Arguments.of((Object[])new Object[]{"StripedExecutorServiceMonitorNotificationServiceImpl,XXX", 10}), Arguments.of((Object[])new Object[]{"StripedExecutorServiceMonitorNotificationServiceImpl,XXX,YYY", 10}), Arguments.of((Object[])new Object[]{"BlockingQueueSingleWorkerMonitorNotificationServiceImpl", 1}), Arguments.of((Object[])new Object[]{"BlockingQueueMultipleWorkerMonitorNotificationServiceImpl", 10}), Arguments.of((Object[])new Object[]{"BlockingQueueMultipleWorkerMonitorNotificationServiceImpl,10", 10}), Arguments.of((Object[])new Object[]{"BlockingQueueMultipleWorkerMonitorNotificationServiceImpl,10,YYY", 10}), Arguments.of((Object[])new Object[]{"BlockingQueueMultipleWorkerMonitorNotificationServiceImpl,XXX", 10}));
    }

    private static Stream<Arguments> getArgumentsForTestServiceImplBufferingBehaviour() {
        return Stream.of(Arguments.of((Object[])new Object[]{MonitorNotificationServiceFactoryCreator.HUMAN_CONSUMER_IMPL, false}), Arguments.of((Object[])new Object[]{MonitorNotificationServiceFactoryCreator.MACHINE_CONSUMER_IMPL, true}));
    }
}

