/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.impl.monitor.striped;

import java.util.logging.Logger;
import java.util.stream.Stream;
import org.epics.ca.NotificationConsumer;
import org.epics.ca.ThreadWatcher;
import org.epics.ca.impl.monitor.MonitorNotificationServiceTest;
import org.epics.ca.util.logging.LibraryLogManager;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class StripedExecutorServiceMonitorNotificationServiceTest {
    private static final Logger logger = LibraryLogManager.getLogger(StripedExecutorServiceMonitorNotificationServiceTest.class);
    private ThreadWatcher threadWatcher;

    StripedExecutorServiceMonitorNotificationServiceTest() {
    }

    @BeforeEach
    void beforeEach() {
        this.threadWatcher = ThreadWatcher.start();
    }

    @AfterEach
    void afterEach() {
        this.threadWatcher.verify();
    }

    @ParameterizedTest
    @MethodSource(value={"getArgumentsForTestThroughputUntilExpectedNotificationsReceived"})
    <T> void testThroughputUntilExpectedNotificationsReceived(String serviceImpl, int notifications, T notifyValue, NotificationConsumer.ConsumerType consumerType) {
        int consumerProcessingTimeInMicroseconds = consumerType == NotificationConsumer.ConsumerType.NORMAL ? 1 : 100;
        new MonitorNotificationServiceTest().testThroughputUntilExpectedNotificationCountReceived(serviceImpl, notifications, notifyValue, consumerType, consumerProcessingTimeInMicroseconds);
    }

    @ParameterizedTest
    @MethodSource(value={"getArgumentsForTestThroughputUntilLastValueReceived"})
    <T> void testThroughputUntilLastValueReceived(String serviceImpl, int notifications, T notifyValue1, T notifyValue2) {
        int consumerProcessingTimeInMicroseconds = 100;
        NotificationConsumer.ConsumerType consumerType = NotificationConsumer.ConsumerType.NORMAL;
        new MonitorNotificationServiceTest().testThroughputUntilLastValueReceived(serviceImpl, notifications, notifyValue1, notifyValue2, consumerType, 100);
    }

    private static Stream<Arguments> getArgumentsForTestThroughputUntilLastValueReceived() {
        return Stream.of(Arguments.of((Object[])new Object[]{"StripedExecutorServiceMonitorNotificationServiceImpl,1", 10000, 123L, 456L}), Arguments.of((Object[])new Object[]{"StripedExecutorServiceMonitorNotificationServiceImpl,5", 10000, 123L, 456L}), Arguments.of((Object[])new Object[]{"StripedExecutorServiceMonitorNotificationServiceImpl,10", 10000, 123L, 456L}), Arguments.of((Object[])new Object[]{"StripedExecutorServiceMonitorNotificationServiceImpl,50", 10000, 123L, 456L}), Arguments.of((Object[])new Object[]{"StripedExecutorServiceMonitorNotificationServiceImpl,100", 10000, 123L, 456L}), Arguments.of((Object[])new Object[]{"StripedExecutorServiceMonitorNotificationServiceImpl,1", 100000, 123L, 456L}), Arguments.of((Object[])new Object[]{"StripedExecutorServiceMonitorNotificationServiceImpl,5", 100000, 123L, 456L}), Arguments.of((Object[])new Object[]{"StripedExecutorServiceMonitorNotificationServiceImpl,10", 100000, 123L, 456L}), Arguments.of((Object[])new Object[]{"StripedExecutorServiceMonitorNotificationServiceImpl,50", 100000, 123L, 456L}), Arguments.of((Object[])new Object[]{"StripedExecutorServiceMonitorNotificationServiceImpl,100", 100000, 123L, 456L}));
    }

    private static Stream<Arguments> getArgumentsForTestThroughputUntilExpectedNotificationsReceived() {
        return Stream.of(Arguments.of((Object[])new Object[]{"StripedExecutorServiceMonitorNotificationServiceImpl,1", 50000, 123L, NotificationConsumer.ConsumerType.NORMAL}), Arguments.of((Object[])new Object[]{"StripedExecutorServiceMonitorNotificationServiceImpl,2", 50000, 123L, NotificationConsumer.ConsumerType.NORMAL}), Arguments.of((Object[])new Object[]{"StripedExecutorServiceMonitorNotificationServiceImpl,4", 50000, 123L, NotificationConsumer.ConsumerType.NORMAL}), Arguments.of((Object[])new Object[]{"StripedExecutorServiceMonitorNotificationServiceImpl,8", 50000, 123L, NotificationConsumer.ConsumerType.NORMAL}), Arguments.of((Object[])new Object[]{"StripedExecutorServiceMonitorNotificationServiceImpl,16", 50000, 123L, NotificationConsumer.ConsumerType.NORMAL}), Arguments.of((Object[])new Object[]{"StripedExecutorServiceMonitorNotificationServiceImpl,32", 50000, 123L, NotificationConsumer.ConsumerType.NORMAL}), Arguments.of((Object[])new Object[]{"StripedExecutorServiceMonitorNotificationServiceImpl,64", 50000, 123L, NotificationConsumer.ConsumerType.NORMAL}), Arguments.of((Object[])new Object[]{"StripedExecutorServiceMonitorNotificationServiceImpl,128", 50000, 123L, NotificationConsumer.ConsumerType.NORMAL}), Arguments.of((Object[])new Object[]{"StripedExecutorServiceMonitorNotificationServiceImpl,8", 50000, 123L, NotificationConsumer.ConsumerType.SLOW_WITH_BUSY_WAIT}), Arguments.of((Object[])new Object[]{"StripedExecutorServiceMonitorNotificationServiceImpl,16", 50000, 123L, NotificationConsumer.ConsumerType.SLOW_WITH_BUSY_WAIT}), Arguments.of((Object[])new Object[]{"StripedExecutorServiceMonitorNotificationServiceImpl,32", 50000, 123L, NotificationConsumer.ConsumerType.SLOW_WITH_BUSY_WAIT}), Arguments.of((Object[])new Object[]{"StripedExecutorServiceMonitorNotificationServiceImpl,64", 50000, 123L, NotificationConsumer.ConsumerType.SLOW_WITH_BUSY_WAIT}), Arguments.of((Object[])new Object[]{"StripedExecutorServiceMonitorNotificationServiceImpl,128", 50000, 123L, NotificationConsumer.ConsumerType.SLOW_WITH_BUSY_WAIT}), Arguments.of((Object[])new Object[]{"StripedExecutorServiceMonitorNotificationServiceImpl,8", 50000, 123L, NotificationConsumer.ConsumerType.SLOW_WITH_THREAD_SLEEP}), Arguments.of((Object[])new Object[]{"StripedExecutorServiceMonitorNotificationServiceImpl,16", 50000, 123L, NotificationConsumer.ConsumerType.SLOW_WITH_THREAD_SLEEP}), Arguments.of((Object[])new Object[]{"StripedExecutorServiceMonitorNotificationServiceImpl,32", 50000, 123L, NotificationConsumer.ConsumerType.SLOW_WITH_THREAD_SLEEP}), Arguments.of((Object[])new Object[]{"StripedExecutorServiceMonitorNotificationServiceImpl,64", 50000, 123L, NotificationConsumer.ConsumerType.SLOW_WITH_THREAD_SLEEP}), Arguments.of((Object[])new Object[]{"StripedExecutorServiceMonitorNotificationServiceImpl,128", 50000, 123L, NotificationConsumer.ConsumerType.SLOW_WITH_THREAD_SLEEP}));
    }
}

