/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.impl.repeater;

import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.time.Duration;
import org.epics.ca.ThreadWatcher;
import org.epics.ca.impl.repeater.CARepeaterClientManager;
import org.epics.ca.impl.repeater.CARepeaterMessage;
import org.epics.ca.impl.repeater.NetworkUtilities;
import org.epics.ca.impl.repeater.UdpSocketReceiver;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class CARepeaterClientManagerTest {
    private ThreadWatcher threadWatcher;

    @BeforeAll
    static void beforeAll() {
        MatcherAssert.assertThat((Object)NetworkUtilities.verifyTargetPlatformNetworkStackIsChannelAccessCompatible(), (Matcher)Is.is((Object)true));
        if (NetworkUtilities.isVpnActive()) {
            Assertions.fail((String)"This test is not supported when a VPN connection is active on the local network interface.");
        }
    }

    @BeforeEach
    void beforeEach() {
        this.threadWatcher = ThreadWatcher.start();
    }

    @AfterEach
    void afterEach() {
        this.threadWatcher.verify();
    }

    @Test
    void testConstructor() {
        Throwable throwable = Assertions.assertThrows(NullPointerException.class, () -> new CARepeaterClientManager(null));
        MatcherAssert.assertThat((Object)throwable.getMessage(), (Matcher)Is.is((Object)"The 'repeaterListeningAddress' argument was null."));
    }

    @Test
    void testForwardDatagram_doesNotThrowExceptions() {
        InetSocketAddress repeaterListeningAddress = new InetSocketAddress(1999);
        CARepeaterClientManager manager = new CARepeaterClientManager(repeaterListeningAddress);
        DatagramPacket datagramPacket = new DatagramPacket(new byte[]{-86, -69}, 0, 2);
        InetSocketAddress excluded = new InetSocketAddress(333);
        Assertions.assertDoesNotThrow(() -> manager.forwardDatagram(datagramPacket, excluded));
    }

    @Test
    void testRegister() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(5L), () -> {
            DatagramPacket rxPacket;
            InetSocketAddress repeaterListeningAddress = new InetSocketAddress(2322);
            CARepeaterClientManager manager = new CARepeaterClientManager(repeaterListeningAddress);
            try (UdpSocketReceiver receiver = UdpSocketReceiver.startListening(54213);){
                manager.registerNewClient(new InetSocketAddress(InetAddress.getLocalHost(), 54213));
                rxPacket = receiver.getDatagram();
            }
            MatcherAssert.assertThat((Object)rxPacket.getLength(), (Matcher)Is.is((Object)16));
            ByteBuffer byteBuffer = ByteBuffer.wrap(rxPacket.getData());
            MatcherAssert.assertThat((Object)byteBuffer.getShort(CARepeaterMessage.CaHeaderOffsets.CA_HDR_SHORT_COMMAND_OFFSET.value), (Matcher)Is.is((Object)CARepeaterMessage.CaCommandCodes.CA_REPEATER_CONFIRM.value));
        });
    }
}

