/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.impl.repeater;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.logging.Logger;
import org.epics.ca.ThreadWatcher;
import org.epics.ca.impl.repeater.CARepeaterClientProxy;
import org.epics.ca.impl.repeater.CARepeaterMessage;
import org.epics.ca.impl.repeater.NetworkUtilities;
import org.epics.ca.impl.repeater.UdpSocketReceiver;
import org.epics.ca.impl.repeater.UdpSocketUtilities;
import org.epics.ca.util.logging.LibraryLogManager;
import org.epics.ca.util.net.InetAddressUtil;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class CARepeaterClientProxyTest {
    private static final Logger logger = LibraryLogManager.getLogger(CARepeaterClientProxyTest.class);
    private ThreadWatcher threadWatcher;

    CARepeaterClientProxyTest() {
    }

    @BeforeAll
    static void beforeAll() {
        MatcherAssert.assertThat((Object)NetworkUtilities.verifyTargetPlatformNetworkStackIsChannelAccessCompatible(), (Matcher)Is.is((Object)true));
        if (NetworkUtilities.isVpnActive()) {
            Assertions.fail((String)"This test is not supported when a VPN connection is active on the local network interface.");
        }
    }

    @BeforeEach
    void beforeEach() {
        this.threadWatcher = ThreadWatcher.start();
    }

    @AfterEach
    void afterEach() {
        this.threadWatcher.verify();
    }

    @Test
    void testConstructor_nullArgument_throwsNullPointerException() {
        Throwable throwable = Assertions.assertThrows(NullPointerException.class, () -> new CARepeaterClientProxy(null));
        MatcherAssert.assertThat((Object)throwable.getMessage(), (Matcher)Matchers.containsString((String)"The 'clientListeningSocketAddress' argument was null."));
    }

    @Test
    void testConstructor_localAddressDoesNotThrowException() {
        InetSocketAddress nonLocalAddress = new InetSocketAddress("localhost", 1234);
        Assertions.assertDoesNotThrow(() -> new CARepeaterClientProxy(nonLocalAddress));
    }

    @Test
    void testConstructor_loopbackIpDoesNotThrowException() {
        InetSocketAddress nonLocalAddress = new InetSocketAddress("127.0.0.1", 1234);
        Assertions.assertDoesNotThrow(() -> new CARepeaterClientProxy(nonLocalAddress).close());
    }

    @Test
    void testConstructor_wildcardAddressDoesNotThrowException() {
        InetSocketAddress wildcardAddress = new InetSocketAddress(1234);
        Assertions.assertDoesNotThrow(() -> new CARepeaterClientProxy(wildcardAddress).close());
    }

    @Test
    void testConstructor_ephemeralPortDoesNotThrowException() {
        InetSocketAddress nonLocalAddress = new InetSocketAddress(0);
        Assertions.assertDoesNotThrow(() -> new CARepeaterClientProxy(nonLocalAddress).close());
    }

    @Test
    void testSendUdpPacket_throwsIllegalArgumentException_whenDatagramPortIsConfigured() throws SocketException {
        try (CARepeaterClientProxy proxy = new CARepeaterClientProxy(new InetSocketAddress(0));){
            DatagramPacket datagramPacketWithShouldNotBeConfiguredPort = new DatagramPacket(new byte[0], 0);
            datagramPacketWithShouldNotBeConfiguredPort.setPort(1234);
            Throwable throwable = Assertions.assertThrows(IllegalArgumentException.class, () -> proxy.sendDatagram(datagramPacketWithShouldNotBeConfiguredPort));
            MatcherAssert.assertThat((Object)throwable.getMessage(), (Matcher)Is.is((Object)"The datagram port should not be configured."));
        }
    }

    @Test
    void testSendUdpPacket_throwsIllegalArgumentException_whenDatagramInetAddressIsConfigured() throws SocketException {
        try (CARepeaterClientProxy proxy = new CARepeaterClientProxy(new InetSocketAddress(0));){
            DatagramPacket datagramPacketWithShouldNotBeConfiguredAddress = new DatagramPacket(new byte[0], 0);
            datagramPacketWithShouldNotBeConfiguredAddress.setAddress(InetAddress.getLoopbackAddress());
            Throwable throwable = Assertions.assertThrows(IllegalArgumentException.class, () -> proxy.sendDatagram(datagramPacketWithShouldNotBeConfiguredAddress));
            MatcherAssert.assertThat((Object)throwable.getMessage(), (Matcher)Is.is((Object)"The datagram inet address should not be configured."));
        }
    }

    @Test
    void testSendCaBeaconMessage_throwsNullPointerException_whenServerAddressNull() throws SocketException, UnknownHostException {
        try (CARepeaterClientProxy proxy = new CARepeaterClientProxy(new InetSocketAddress(InetAddress.getLocalHost(), 3333));){
            Throwable throwable = Assertions.assertThrows(NullPointerException.class, () -> proxy.sendCaServerBeaconMessage((short)99, (short)4444, 305419896, null));
            MatcherAssert.assertThat((Object)throwable.getMessage(), (Matcher)Is.is((Object)"The validated object is null"));
        }
    }

    @Test
    void integrationTestSendCaVersionMessage() throws SocketException {
        try (UdpSocketReceiver receiver = UdpSocketReceiver.startListening(31245);){
            try (CARepeaterClientProxy proxy = new CARepeaterClientProxy(new InetSocketAddress(InetAddress.getLoopbackAddress(), 31245));){
                logger.info("About to send...");
                proxy.sendCaVersionMessage();
                logger.info("Sent.");
            }
            DatagramPacket receivePacket = receiver.getDatagram();
            MatcherAssert.assertThat((Object)receivePacket.getLength(), (Matcher)Is.is((Object)16));
            ByteBuffer byteBuffer = ByteBuffer.wrap(receivePacket.getData());
            byteBuffer.limit(receivePacket.getLength());
            MatcherAssert.assertThat((Object)byteBuffer.getShort(CARepeaterMessage.CaHeaderOffsets.CA_HDR_SHORT_COMMAND_OFFSET.value), (Matcher)Is.is((Object)CARepeaterMessage.CaCommandCodes.CA_PROTO_VERSION.value));
            MatcherAssert.assertThat((Object)byteBuffer.getShort(CARepeaterMessage.CaVersionMessageOffsets.CA_HDR_SHORT_VERSION_MSG_UNUSED1_OFFSET.value), (Matcher)Is.is((Object)0));
            MatcherAssert.assertThat((Object)byteBuffer.getShort(CARepeaterMessage.CaVersionMessageOffsets.CA_HDR_SHORT_VERSION_MSG_PRIORITY_OFFSET.value), (Matcher)Is.is((Object)0));
            MatcherAssert.assertThat((Object)byteBuffer.getShort(CARepeaterMessage.CaVersionMessageOffsets.CA_HDR_SHORT_VERSION_MSG_UNUSED_TCP_MINOR_VERSION_OFFSET.value), (Matcher)Is.is((Object)0));
            MatcherAssert.assertThat((Object)byteBuffer.getInt(CARepeaterMessage.CaVersionMessageOffsets.CA_HDR_INT_VERSION_MSG_UNUSED2_OFFSET.value), (Matcher)Is.is((Object)0));
            MatcherAssert.assertThat((Object)byteBuffer.getInt(CARepeaterMessage.CaVersionMessageOffsets.CA_HDR_INT_VERSION_MSG_UNUSED3_OFFSET.value), (Matcher)Is.is((Object)0));
        }
    }

    @Test
    void integrationTestSendCaBeaconMessage() throws SocketException, UnknownHostException {
        try (UdpSocketReceiver receiver = UdpSocketReceiver.startListening(31246);){
            try (CARepeaterClientProxy proxy = new CARepeaterClientProxy(new InetSocketAddress(InetAddress.getLoopbackAddress(), 31246));){
                logger.info("About to send...");
                proxy.sendCaServerBeaconMessage((short)99, (short)4444, 305419896, InetAddress.getByAddress(new byte[]{-86, -69, -52, -35}));
                logger.info("Sent !");
            }
            DatagramPacket receivePacket = receiver.getDatagram();
            MatcherAssert.assertThat((Object)receivePacket.getLength(), (Matcher)Is.is((Object)16));
            ByteBuffer byteBuffer = ByteBuffer.wrap(receivePacket.getData());
            byteBuffer.limit(receivePacket.getLength());
            MatcherAssert.assertThat((Object)byteBuffer.getShort(CARepeaterMessage.CaHeaderOffsets.CA_HDR_SHORT_COMMAND_OFFSET.value), (Matcher)Is.is((Object)CARepeaterMessage.CaCommandCodes.CA_PROTO_RSRV_IS_UP.value));
            MatcherAssert.assertThat((Object)byteBuffer.getShort(CARepeaterMessage.CaBeaconMessageOffsets.CA_HDR_SHORT_BEACON_MSG_UNUSED_OFFSET.value), (Matcher)Is.is((Object)0));
            MatcherAssert.assertThat((Object)byteBuffer.getShort(CARepeaterMessage.CaBeaconMessageOffsets.CA_HDR_SHORT_BEACON_MSG_SERVER_PROTOCOL_MINOR_VERSION_OFFSET.value), (Matcher)Is.is((Object)99));
            MatcherAssert.assertThat((Object)byteBuffer.getShort(CARepeaterMessage.CaBeaconMessageOffsets.CA_HDR_SHORT_BEACON_MSG_SERVER_TCP_LISTENING_PORT_OFFSET.value), (Matcher)Is.is((Object)4444));
            MatcherAssert.assertThat((Object)byteBuffer.getInt(CARepeaterMessage.CaBeaconMessageOffsets.CA_HDR_INT_BEACON_MSG_SERVER_BEACON_ID_OFFSET.value), (Matcher)Is.is((Object)305419896));
            MatcherAssert.assertThat((Object)byteBuffer.getInt(CARepeaterMessage.CaBeaconMessageOffsets.CA_HDR_INT_BEACON_MSG_SERVER_ADDR_OFFSET.value), (Matcher)Is.is((Object)-1430532899));
        }
    }

    @Test
    void integrationTestSendRepeaterConfirmMessage() throws SocketException {
        try (UdpSocketReceiver receiver = UdpSocketReceiver.startListening(31247);){
            try (CARepeaterClientProxy proxy = new CARepeaterClientProxy(new InetSocketAddress(InetAddress.getLoopbackAddress(), 31247));){
                logger.info("About to send...");
                proxy.sendCaRepeaterConfirmMessage(InetAddress.getLoopbackAddress());
                logger.info("Sent.");
            }
            DatagramPacket receivePacket = receiver.getDatagram();
            MatcherAssert.assertThat((Object)receivePacket.getLength(), (Matcher)Is.is((Object)16));
            ByteBuffer byteBuffer = ByteBuffer.wrap(receivePacket.getData());
            byteBuffer.limit(receivePacket.getLength());
            MatcherAssert.assertThat((Object)byteBuffer.getShort(CARepeaterMessage.CaRepeaterConfirmMessageOffsets.CA_HDR_SHORT_REPEATER_CONFIRM_MSG_COMMAND_OFFSET.value), (Matcher)Is.is((Object)CARepeaterMessage.CaCommandCodes.CA_REPEATER_CONFIRM.value));
            MatcherAssert.assertThat((Object)byteBuffer.getShort(CARepeaterMessage.CaRepeaterConfirmMessageOffsets.CA_HDR_SHORT_REPEATER_CONFIRM_MSG_UNUSED1_OFFSET.value), (Matcher)Is.is((Object)0));
            MatcherAssert.assertThat((Object)byteBuffer.getShort(CARepeaterMessage.CaRepeaterConfirmMessageOffsets.CA_HDR_SHORT_REPEATER_CONFIRM_MSG_UNUSED2_OFFSET.value), (Matcher)Is.is((Object)0));
            MatcherAssert.assertThat((Object)byteBuffer.getShort(CARepeaterMessage.CaRepeaterConfirmMessageOffsets.CA_HDR_SHORT_REPEATER_CONFIRM_MSG_UNUSED3_OFFSET.value), (Matcher)Is.is((Object)0));
            MatcherAssert.assertThat((Object)byteBuffer.getInt(CARepeaterMessage.CaRepeaterConfirmMessageOffsets.CA_HDR_INT_REPEATER_CONFIRM_MSG_UNUSED4_OFFSET.value), (Matcher)Is.is((Object)0));
            InetAddress caRepeaterInetAddressAsInteger = InetAddressUtil.intToIPv4Address((int)byteBuffer.getInt(CARepeaterMessage.CaRepeaterConfirmMessageOffsets.CA_HDR_INT_REPEATER_CONFIRM_MSG_REPEATER_ADDR_OFFSET.value));
            MatcherAssert.assertThat((Object)NetworkUtilities.isThisMyIpAddress((InetAddress)caRepeaterInetAddressAsInteger), (Matcher)Is.is((Object)true));
        }
    }

    @Test
    void testIsClientDead() throws SocketException {
        try (DatagramSocket caRepeaterClientListener = UdpSocketUtilities.createBroadcastAwareListeningSocket((int)1111, (boolean)false);
             CARepeaterClientProxy proxyToClientWhichIsAlive = new CARepeaterClientProxy(new InetSocketAddress(1111));
             CARepeaterClientProxy proxyToClientWhichIsDead = new CARepeaterClientProxy(new InetSocketAddress(1112));){
            MatcherAssert.assertThat((Object)proxyToClientWhichIsAlive.isClientDead(), (Matcher)Is.is((Object)false));
            MatcherAssert.assertThat((Object)proxyToClientWhichIsDead.isClientDead(), (Matcher)Is.is((Object)true));
        }
        var2_2 = null;
        try (CARepeaterClientProxy proxyToGoneAwayClient = new CARepeaterClientProxy(new InetSocketAddress(1111));){
            MatcherAssert.assertThat((Object)proxyToGoneAwayClient.isClientDead(), (Matcher)Is.is((Object)true));
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
    }
}

