/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.impl.repeater;

import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.Validate;
import org.epics.ca.ThreadWatcher;
import org.epics.ca.impl.JavaProcessManager;
import org.epics.ca.impl.repeater.CARepeaterServiceManager;
import org.epics.ca.impl.repeater.NetworkUtilities;
import org.epics.ca.impl.repeater.UdpSocketReserver;
import org.epics.ca.impl.repeater.UdpSocketUtilities;
import org.epics.ca.util.logging.LibraryLogManager;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class CARepeaterServiceManagerTest {
    private static final Logger logger = LibraryLogManager.getLogger(CARepeaterServiceManagerTest.class);
    private ThreadWatcher threadWatcher;
    private static final int testPort = 5065;
    private static final Level caRepeaterDebugLevel = Level.ALL;
    private static final boolean caRepeaterOutputCaptureEnable = false;

    @BeforeAll
    static void beforeAll() {
        MatcherAssert.assertThat((Object)NetworkUtilities.verifyTargetPlatformNetworkStackIsChannelAccessCompatible(), (Matcher)Is.is((Object)true));
        if (NetworkUtilities.isVpnActive()) {
            Assertions.fail((String)"This test is not supported when a VPN connection is active on the local network interface.");
        }
    }

    @BeforeEach
    void beforeEach() {
        this.threadWatcher = ThreadWatcher.start();
        InetSocketAddress wildcardAddress = new InetSocketAddress(5065);
        logger.info("Checking Test Precondition: CA Repeater should NOT be running... on: " + wildcardAddress);
        if (CARepeaterServiceManager.isRepeaterRunning((int)5065)) {
            logger.info("Test Precondition FAILED: the CA Repeater was detected to be already running.");
            Assertions.fail();
        } else {
            logger.info("Test Precondition OK: the CA Repeater was not detected to be already running.");
        }
        logger.info("Starting Test.");
    }

    @AfterEach
    void afterEach() {
        this.threadWatcher.verify();
    }

    @Test
    void testNothingShouldBeRunningOnRepeaterPort() {
    }

    @Test
    void testCARepeaterServiceManager_requestAndCancelService() {
        CARepeaterServiceManager.requestServiceOnPort((int)2);
        MatcherAssert.assertThat((Object)CARepeaterServiceManager.getServiceInstances(), (Matcher)Is.is((Object)1));
        CARepeaterServiceManager.cancelServiceRequestOnPort((int)2);
        MatcherAssert.assertThat((Object)CARepeaterServiceManager.getServiceInstances(), (Matcher)Is.is((Object)0));
    }

    @Test
    void testCARepeaterServiceManager_requestAndCancelServiceTwiceOnSamePort() {
        MatcherAssert.assertThat((Object)CARepeaterServiceManager.getServiceInstances(), (Matcher)Is.is((Object)0));
        CARepeaterServiceManager.requestServiceOnPort((int)2);
        MatcherAssert.assertThat((Object)CARepeaterServiceManager.getServiceInstances(), (Matcher)Is.is((Object)1));
        CARepeaterServiceManager.requestServiceOnPort((int)2);
        MatcherAssert.assertThat((Object)CARepeaterServiceManager.getServiceInstances(), (Matcher)Is.is((Object)1));
        CARepeaterServiceManager.cancelServiceRequestOnPort((int)2);
        MatcherAssert.assertThat((Object)CARepeaterServiceManager.getServiceInstances(), (Matcher)Is.is((Object)1));
        CARepeaterServiceManager.cancelServiceRequestOnPort((int)2);
        MatcherAssert.assertThat((Object)CARepeaterServiceManager.getServiceInstances(), (Matcher)Is.is((Object)0));
    }

    @Test
    void testCARepeaterServiceManager_requestAndCancelServiceOnDifferentPorts() {
        MatcherAssert.assertThat((Object)CARepeaterServiceManager.getServiceInstances(), (Matcher)Is.is((Object)0));
        CARepeaterServiceManager.requestServiceOnPort((int)22);
        MatcherAssert.assertThat((Object)CARepeaterServiceManager.getServiceInstances(), (Matcher)Is.is((Object)1));
        CARepeaterServiceManager.requestServiceOnPort((int)33);
        MatcherAssert.assertThat((Object)CARepeaterServiceManager.getServiceInstances(), (Matcher)Is.is((Object)2));
        CARepeaterServiceManager.cancelServiceRequestOnPort((int)999);
        MatcherAssert.assertThat((Object)CARepeaterServiceManager.getServiceInstances(), (Matcher)Is.is((Object)2));
        CARepeaterServiceManager.cancelServiceRequestOnPort((int)22);
        MatcherAssert.assertThat((Object)CARepeaterServiceManager.getServiceInstances(), (Matcher)Is.is((Object)1));
        CARepeaterServiceManager.cancelServiceRequestOnPort((int)33);
        MatcherAssert.assertThat((Object)CARepeaterServiceManager.getServiceInstances(), (Matcher)Is.is((Object)0));
    }

    @Test
    void testIsRepeaterRunning_detectsShareableSocketWhenReservedInSameJvm() throws Throwable {
        try (DatagramSocket ignored = UdpSocketUtilities.createBroadcastAwareListeningSocket((int)5065, (boolean)true);){
            MatcherAssert.assertThat((Object)CARepeaterServiceManager.isRepeaterRunning((int)5065), (Matcher)Is.is((Object)true));
        }
        MatcherAssert.assertThat((Object)CARepeaterServiceManager.isRepeaterRunning((int)5065), (Matcher)Is.is((Object)false));
    }

    @Test
    void testIsRepeaterRunning_detectsNonShareableSocketWhenReservedInSameJvm() throws Throwable {
        try (DatagramSocket ignored = UdpSocketUtilities.createBroadcastAwareListeningSocket((int)5065, (boolean)false);){
            MatcherAssert.assertThat((Object)CARepeaterServiceManager.isRepeaterRunning((int)5065), (Matcher)Is.is((Object)true));
        }
        MatcherAssert.assertThat((Object)CARepeaterServiceManager.isRepeaterRunning((int)5065), (Matcher)Is.is((Object)false));
    }

    @MethodSource(value={"getArgumentsForTestIsRepeaterRunning_detectsSocketReservedInDifferentJvmOnDifferentLocalAddresses"})
    @ParameterizedTest
    void testIsRepeaterRunning_detectsSocketReservedInDifferentJvmOnDifferentLocalAddress(String localAddress) throws Throwable {
        Validate.notNull((Object)localAddress, (String)"The localAddress was not provided.", (Object[])new Object[0]);
        logger.info("Checking whether repeater instance detected on local address: '" + localAddress + "'");
        int portToReserve = 5065;
        int reservationTimeInMillis = 3000;
        JavaProcessManager processManager = UdpSocketReserver.start(localAddress, 5065, 3000);
        Thread.sleep(1500L);
        MatcherAssert.assertThat((Object)processManager.isAlive(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((String)"The isRepeaterRunning method failed to detect that the socket was reserved.", (Object)CARepeaterServiceManager.isRepeaterRunning((int)5065), (Matcher)Is.is((Object)true));
        processManager.waitFor(5000L, TimeUnit.MILLISECONDS);
        MatcherAssert.assertThat((Object)processManager.isAlive(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((String)"The isRepeaterRunning method failed to detect that the socket is now available.", (Object)CARepeaterServiceManager.isRepeaterRunning((int)5065), (Matcher)Is.is((Object)false));
        logger.info("The test PASSED.");
    }

    private static Stream<Arguments> getArgumentsForTestIsRepeaterRunning_detectsSocketReservedInDifferentJvmOnDifferentLocalAddresses() {
        List localAddressList = NetworkUtilities.getLocalNetworkInterfaceAddresses();
        List localAddresses = localAddressList.stream().map(Inet4Address::getHostAddress).collect(Collectors.toList());
        return localAddresses.stream().map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }
}

