/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.impl.repeater;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.epics.ca.ThreadWatcher;
import org.epics.ca.impl.repeater.CARepeater;
import org.epics.ca.impl.repeater.CARepeaterMessage;
import org.epics.ca.impl.repeater.NetworkUtilities;
import org.epics.ca.impl.repeater.UdpSocketUtilities;
import org.epics.ca.util.logging.LibraryLogManager;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;

class CARepeaterTest {
    private static final Logger logger = LibraryLogManager.getLogger(CARepeaterTest.class);
    private ThreadWatcher threadWatcher;
    private CARepeater caRepeater;

    CARepeaterTest() {
    }

    @BeforeAll
    static void beforeAll() {
        MatcherAssert.assertThat((Object)NetworkUtilities.verifyTargetPlatformNetworkStackIsChannelAccessCompatible(), (Matcher)Is.is((Object)true));
        if (NetworkUtilities.isVpnActive()) {
            Assertions.fail((String)"This test is not supported when a VPN connection is active on the local network interface.");
        }
    }

    @BeforeEach
    void beforeEach() throws CARepeater.CaRepeaterStartupException {
        this.threadWatcher = ThreadWatcher.start();
        logger.info("Starting CA Repeater integration tests...");
        logger.info("Creating CA Repeater which will listen for broadcast messages on Port 43721.");
        this.caRepeater = new CARepeater(43721);
        logger.info("Starting CA Repeater on port 43721.");
        this.caRepeater.start();
        logger.info("Repeater has been started.");
    }

    @AfterEach
    void afterEach() {
        if (this.caRepeater == null) {
            logger.info("CA Repeater did not start correctly so no need to shut it down...");
        } else {
            logger.info("Shutting down CA Repeater...");
            this.caRepeater.shutdown();
            logger.info("Repeater has been shutdown.");
        }
        logger.info("CARepeater test completed ok.");
        this.threadWatcher.verify();
    }

    @Test
    void testRunInternalCaRepeaterForTwoSeconds() throws InterruptedException {
        logger.info("Sleeping for 2 seconds...");
        Thread.sleep(2000L);
        logger.info("Sleeping time is over.");
    }

    @MethodSource(value={"getArgumentsForIntegrationTestCaRepeater_registerNewClient"})
    @ParameterizedTest
    void integrationTestCaRepeater_registerNewClient(String targetInetAddress, int targetPort, boolean useBroadcast, String advertisedListeningAddress) throws IOException {
        logger.info(String.format("Register new client test with params: %s %d %s %s", targetInetAddress, targetPort, useBroadcast, advertisedListeningAddress));
        try (DatagramSocket testSocket = UdpSocketUtilities.createEphemeralSendSocket((boolean)true);){
            DatagramPacket requestPacket = CARepeaterMessage.createRepeaterRegisterMessage((InetAddress)InetAddress.getByName(advertisedListeningAddress));
            requestPacket.setAddress(InetAddress.getByName(targetInetAddress));
            requestPacket.setPort(targetPort);
            byte[] replyMessage = new byte[16];
            DatagramPacket replyPacket = new DatagramPacket(replyMessage, replyMessage.length);
            testSocket.send(requestPacket);
            Assertions.assertTimeoutPreemptively((Duration)Duration.of(1L, ChronoUnit.SECONDS), () -> testSocket.receive(replyPacket));
            MatcherAssert.assertThat((Object)replyPacket.getLength(), (Matcher)Is.is((Object)16));
            ByteBuffer replyBuffer = ByteBuffer.wrap(replyMessage);
            short commandReceived = replyBuffer.getShort(CARepeaterMessage.CaHeaderOffsets.CA_HDR_SHORT_COMMAND_OFFSET.value);
            short commandExpected = CARepeaterMessage.CaCommandCodes.CA_REPEATER_CONFIRM.value;
            MatcherAssert.assertThat((Object)commandReceived, (Matcher)Is.is((Object)commandExpected));
        }
    }

    @ValueSource(ints={43721})
    @ParameterizedTest
    void integrationTestCaRepeater_zeroLengthDatagram_registersClientWhoSentIt(int port) throws IOException {
        try (DatagramSocket caRepeaterClientSocket = UdpSocketUtilities.createEphemeralSendSocket((boolean)true);){
            DatagramPacket requestPacket = new DatagramPacket(new byte[0], 0);
            requestPacket.setAddress(InetAddress.getLoopbackAddress());
            requestPacket.setPort(port);
            caRepeaterClientSocket.send(requestPacket);
            byte[] replyMessage = new byte[1024];
            DatagramPacket replyPacket = new DatagramPacket(replyMessage, replyMessage.length);
            ByteBuffer replyBuffer = ByteBuffer.wrap(replyMessage);
            caRepeaterClientSocket.receive(replyPacket);
            MatcherAssert.assertThat((Object)replyPacket.getLength(), (Matcher)Is.is((Object)16));
            short commandReceived = replyBuffer.getShort(CARepeaterMessage.CaHeaderOffsets.CA_HDR_SHORT_COMMAND_OFFSET.value);
            short commandExpected = CARepeaterMessage.CaCommandCodes.CA_REPEATER_CONFIRM.value;
            MatcherAssert.assertThat((Object)commandReceived, (Matcher)Is.is((Object)commandExpected));
        }
    }

    @ValueSource(ints={43721})
    @ParameterizedTest
    void integrationTestCaRepeater_afterRegistration_allReceivedDatagrams_getPublishedToAllClients(int port) throws IOException {
        try (DatagramSocket caRepeaterClientSocketA = UdpSocketUtilities.createEphemeralSendSocket((boolean)true);
             DatagramSocket caRepeaterClientSocketB = UdpSocketUtilities.createEphemeralSendSocket((boolean)true);
             DatagramSocket caRepeaterClientSocketC = UdpSocketUtilities.createEphemeralSendSocket((boolean)true);
             DatagramSocket caRepeaterSenderSocket = UdpSocketUtilities.createEphemeralSendSocket((boolean)true);){
            DatagramPacket registrationRequestPacket = new DatagramPacket(new byte[]{0}, 0);
            registrationRequestPacket.setAddress(InetAddress.getLoopbackAddress());
            registrationRequestPacket.setPort(port);
            logger.info("Client A: sending: registrationRequestPacket: " + Arrays.toString(registrationRequestPacket.getData()) + " to: " + registrationRequestPacket.getSocketAddress() + " from: " + caRepeaterClientSocketA.getLocalSocketAddress());
            caRepeaterClientSocketA.send(registrationRequestPacket);
            logger.info("Client B: sending: registrationRequestPacket: " + Arrays.toString(registrationRequestPacket.getData()) + " to: " + registrationRequestPacket.getSocketAddress() + " from: " + caRepeaterClientSocketB.getLocalSocketAddress());
            caRepeaterClientSocketB.send(registrationRequestPacket);
            logger.info("Client C: sending: registrationRequestPacket: " + Arrays.toString(registrationRequestPacket.getData()) + " to: " + registrationRequestPacket.getSocketAddress() + " from: " + caRepeaterClientSocketC.getLocalSocketAddress());
            caRepeaterClientSocketC.send(registrationRequestPacket);
            logger.info("Client A: waiting for CA repeater registration confirmation.");
            byte[] replyMessageA = new byte[16];
            DatagramPacket replyPacketA = new DatagramPacket(replyMessageA, replyMessageA.length);
            ByteBuffer replyBufferA = ByteBuffer.wrap(replyMessageA);
            caRepeaterClientSocketA.receive(replyPacketA);
            logger.info("Received: replyPacketA: " + Arrays.toString(replyPacketA.getData()) + " from: " + replyPacketA.getSocketAddress());
            MatcherAssert.assertThat((Object)replyPacketA.getLength(), (Matcher)Is.is((Object)16));
            short commandReceivedA = replyBufferA.getShort(CARepeaterMessage.CaHeaderOffsets.CA_HDR_SHORT_COMMAND_OFFSET.value);
            short commandExpectedA = CARepeaterMessage.CaCommandCodes.CA_REPEATER_CONFIRM.value;
            MatcherAssert.assertThat((Object)commandReceivedA, (Matcher)Is.is((Object)commandExpectedA));
            logger.info("Client A was registered.");
            logger.info("Client B: waiting for CA repeater registration confirmation.");
            byte[] replyMessageB = new byte[16];
            DatagramPacket replyPacketB = new DatagramPacket(replyMessageB, replyMessageB.length);
            ByteBuffer replyBufferB = ByteBuffer.wrap(replyMessageB);
            caRepeaterClientSocketB.receive(replyPacketB);
            logger.info("Received: replyPacketB: " + Arrays.toString(replyPacketB.getData()) + " from: " + replyPacketB.getSocketAddress());
            MatcherAssert.assertThat((Object)replyPacketB.getLength(), (Matcher)Is.is((Object)16));
            short commandReceivedB = replyBufferA.getShort(CARepeaterMessage.CaHeaderOffsets.CA_HDR_SHORT_COMMAND_OFFSET.value);
            short commandExpectedB = CARepeaterMessage.CaCommandCodes.CA_REPEATER_CONFIRM.value;
            MatcherAssert.assertThat((Object)commandReceivedB, (Matcher)Is.is((Object)commandExpectedA));
            logger.info("Client B was registered.");
            logger.info("Client C: waiting for CA repeater registration confirmation.");
            byte[] replyMessageC = new byte[16];
            DatagramPacket replyPacketC = new DatagramPacket(replyMessageC, replyMessageC.length);
            ByteBuffer replyBufferC = ByteBuffer.wrap(replyMessageC);
            caRepeaterClientSocketC.receive(replyPacketC);
            logger.info("Received: replyPacketC: " + Arrays.toString(replyPacketC.getData()) + " from: " + replyPacketC.getSocketAddress());
            MatcherAssert.assertThat((Object)replyPacketC.getLength(), (Matcher)Is.is((Object)16));
            short commandReceivedC = replyBufferA.getShort(CARepeaterMessage.CaHeaderOffsets.CA_HDR_SHORT_COMMAND_OFFSET.value);
            short commandExpectedC = CARepeaterMessage.CaCommandCodes.CA_REPEATER_CONFIRM.value;
            MatcherAssert.assertThat((Object)commandReceivedC, (Matcher)Is.is((Object)commandExpectedA));
            logger.info("Client C was registered.");
            logger.info("Sending UDP datagram to CA Repeater...");
            byte[] someRandomTxMessage = new byte[]{1, 2, 3, 4, 5};
            DatagramPacket randomTxPacket = new DatagramPacket(someRandomTxMessage, someRandomTxMessage.length);
            randomTxPacket.setAddress(InetAddress.getLoopbackAddress());
            randomTxPacket.setPort(port);
            caRepeaterSenderSocket.send(randomTxPacket);
            byte[] rxMessageA = new byte[32];
            DatagramPacket rxPacketA = new DatagramPacket(rxMessageA, 32);
            ByteBuffer rxBufferA = ByteBuffer.wrap(rxMessageA);
            caRepeaterClientSocketA.receive(rxPacketA);
            logger.info("Received: rxPacketA: " + Arrays.toString(rxPacketA.getData()) + " from: " + rxPacketA.getSocketAddress());
            caRepeaterClientSocketA.receive(rxPacketA);
            logger.info("Received: rxPacketA: " + Arrays.toString(rxPacketA.getData()) + " from: " + rxPacketA.getSocketAddress());
            caRepeaterClientSocketA.receive(rxPacketA);
            logger.info("Received: rxPacketA: " + Arrays.toString(rxPacketA.getData()) + " from: " + rxPacketA.getSocketAddress());
            MatcherAssert.assertThat((Object)rxPacketA.getLength(), (Matcher)Is.is((Object)5));
            MatcherAssert.assertThat((Object)Arrays.copyOfRange(rxBufferA.array(), 0, someRandomTxMessage.length), (Matcher)Is.is((Object)someRandomTxMessage));
            byte[] rxMessageB = new byte[32];
            DatagramPacket rxPacketB = new DatagramPacket(rxMessageB, 32);
            ByteBuffer rxBufferB = ByteBuffer.wrap(rxMessageB);
            caRepeaterClientSocketB.receive(rxPacketB);
            logger.info("Received: rxPacketB: " + Arrays.toString(rxPacketB.getData()) + " from: " + rxPacketB.getSocketAddress());
            caRepeaterClientSocketB.receive(rxPacketB);
            logger.info("Received: rxPacketB: " + Arrays.toString(rxPacketB.getData()) + " from: " + rxPacketB.getSocketAddress());
            MatcherAssert.assertThat((Object)rxPacketB.getLength(), (Matcher)Is.is((Object)5));
            MatcherAssert.assertThat((Object)Arrays.copyOfRange(rxBufferB.array(), 0, someRandomTxMessage.length), (Matcher)Is.is((Object)someRandomTxMessage));
            byte[] rxMessageC = new byte[32];
            DatagramPacket rxPacketC = new DatagramPacket(rxMessageC, 32);
            ByteBuffer rxBufferC = ByteBuffer.wrap(rxMessageC);
            caRepeaterClientSocketC.receive(rxPacketC);
            logger.info("Received: rxPacketC: " + Arrays.toString(rxPacketC.getData()) + " from: " + rxPacketC.getSocketAddress());
            MatcherAssert.assertThat((Object)rxPacketC.getLength(), (Matcher)Is.is((Object)5));
            MatcherAssert.assertThat((Object)Arrays.copyOfRange(rxBufferC.array(), 0, someRandomTxMessage.length), (Matcher)Is.is((Object)someRandomTxMessage));
        }
    }

    private static Stream<Arguments> getArgumentsForIntegrationTestCaRepeater_registerNewClient() {
        List broadcastAddresses = NetworkUtilities.getLocalBroadcastAddresses();
        List args = broadcastAddresses.stream().map(addr -> {
            String stringAddr = addr.getHostAddress();
            return Arguments.of((Object[])new Object[]{stringAddr, 43721, true, stringAddr});
        }).collect(Collectors.toList());
        args.add(Arguments.of((Object[])new Object[]{"127.0.0.1", 43721, false, "127.0.0.1"}));
        return args.stream();
    }
}

