/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.impl.repeater;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.epics.ca.ThreadWatcher;
import org.epics.ca.impl.repeater.NetworkUtilities;
import org.epics.ca.util.logging.LibraryLogManager;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class NetworkUtilitiesTest {
    private static final Logger logger = LibraryLogManager.getLogger(NetworkUtilitiesTest.class);
    private ThreadWatcher threadWatcher;

    NetworkUtilitiesTest() {
    }

    @BeforeAll
    static void beforeAll() {
        MatcherAssert.assertThat((Object)NetworkUtilities.verifyTargetPlatformNetworkStackIsChannelAccessCompatible(), (Matcher)Is.is((Object)true));
    }

    @BeforeEach
    void beforeEach() {
        this.threadWatcher = ThreadWatcher.start();
    }

    @AfterEach
    void afterEach() {
        this.threadWatcher.verify();
    }

    @Test
    void testIsThisMyIp_suppliedWithNullThrowsNullPointerException() {
        Assertions.assertThrows(NullPointerException.class, () -> NetworkUtilities.isThisMyIpAddress(null));
    }

    @Test
    void testIsThisMyIp_withMiscellaneousAddresses() throws UnknownHostException {
        MatcherAssert.assertThat((Object)NetworkUtilities.isThisMyIpAddress((InetAddress)InetAddress.getByName("bbc.co.uk")), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)NetworkUtilities.isThisMyIpAddress((InetAddress)InetAddress.getLoopbackAddress()), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)NetworkUtilities.isThisMyIpAddress((InetAddress)InetAddress.getLocalHost()), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)NetworkUtilities.isThisMyIpAddress((InetAddress)InetAddress.getByName("127.0.0.1")), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)NetworkUtilities.isThisMyIpAddress((InetAddress)InetAddress.getByName("127.0.0.8")), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)NetworkUtilities.isThisMyIpAddress((InetAddress)InetAddress.getByName("0.0.0.0")), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)NetworkUtilities.isThisMyIpAddress((InetAddress)InetAddress.getByName("192.168.0.1")), (Matcher)Is.is((Object)false));
    }

    @Test
    void testIsThisMyIp_withAllLocalHostNameAddresses() throws UnknownHostException {
        String hostName = InetAddress.getLocalHost().getHostName();
        InetAddress[] localAddresses = InetAddress.getAllByName(hostName);
        Arrays.asList(localAddresses).forEach(addr -> {
            logger.info("Testing with IP: " + addr);
            MatcherAssert.assertThat((Object)NetworkUtilities.isThisMyIpAddress((InetAddress)addr), (Matcher)Is.is((Object)true));
        });
    }

    @Test
    void testIsThisMyIp_withAllLocalHostAddresses() throws UnknownHostException {
        InetAddress[] localAddresses = InetAddress.getAllByName("localhost");
        Arrays.asList(localAddresses).forEach(addr -> {
            logger.info("Testing with IP: " + addr);
            MatcherAssert.assertThat((Object)NetworkUtilities.isThisMyIpAddress((InetAddress)addr), (Matcher)Is.is((Object)true));
        });
    }

    @Test
    void testGetLocalNetworkInterfaceAddresses() {
        logger.info("The following network addresses have been detected on the local network interface:");
        List list = NetworkUtilities.getLocalNetworkInterfaceAddresses();
        list.forEach(addr -> logger.info("- " + addr.toString()));
    }

    @Test
    void testGetLocalBroadcastAddresses() {
        logger.info("The following broadcast addresses have been detected on the local network interface:");
        List list = NetworkUtilities.getLocalBroadcastAddresses();
        list.forEach(addr -> logger.info("- " + addr.toString()));
    }

    @Test
    void testIsVpnActive() {
        NetworkUtilities.isVpnActive();
    }
}

