/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.impl.repeater;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.util.logging.Logger;
import net.jcip.annotations.ThreadSafe;
import org.epics.ca.impl.repeater.UdpSocketUtilities;
import org.epics.ca.util.logging.LibraryLogManager;

@ThreadSafe
class UdpSocketReceiver
implements AutoCloseable {
    private static final Logger logger = LibraryLogManager.getLogger(UdpSocketReceiver.class);
    private static final int BUFSIZE = 65508;
    private final DatagramSocket listeningSocket;

    private UdpSocketReceiver(int listeningPort) {
        try {
            this.listeningSocket = UdpSocketUtilities.createBroadcastAwareListeningSocket((int)listeningPort, (boolean)true);
        }
        catch (SocketException ex) {
            String message = "Exception thrown when creating listening socket. Details: " + ex.getMessage();
            logger.warning(message);
            throw new RuntimeException(ex);
        }
    }

    public static UdpSocketReceiver startListening(int listeningPort) {
        return new UdpSocketReceiver(listeningPort);
    }

    @Override
    public void close() {
        this.listeningSocket.close();
    }

    public DatagramPacket getDatagram() {
        logger.info("Receiving datagram...");
        DatagramPacket receivePacket = new DatagramPacket(new byte[65508], 65508);
        try {
            logger.info("Listening on socket: " + this.listeningSocket.getLocalSocketAddress());
            this.listeningSocket.receive(receivePacket);
            logger.info("Received new packet from: " + receivePacket.getSocketAddress());
        }
        catch (IOException ex) {
            logger.warning("IOException thrown when attempting to receive datagram ! Perhaps the operation was cancelled ?");
        }
        catch (Exception ex) {
            logger.warning("Exception thrown when attempting to receive datagram. Details: '" + ex.getMessage() + "'.");
        }
        logger.finest("Receive thread completed.");
        return receivePacket;
    }
}

