/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.impl.repeater;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.epics.ca.ThreadWatcher;
import org.epics.ca.impl.JavaProcessManager;
import org.epics.ca.impl.repeater.NetworkUtilities;
import org.epics.ca.impl.repeater.UdpSocketReserver;
import org.epics.ca.impl.repeater.UdpSocketUtilities;
import org.epics.ca.util.logging.LibraryLogManager;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;

class UdpSocketUtilitiesTest {
    private static final Logger logger = LibraryLogManager.getLogger(UdpSocketUtilitiesTest.class);
    private ThreadWatcher threadWatcher;

    UdpSocketUtilitiesTest() {
    }

    @BeforeAll
    static void beforeAll() {
        MatcherAssert.assertThat((Object)NetworkUtilities.verifyTargetPlatformNetworkStackIsChannelAccessCompatible(), (Matcher)Is.is((Object)true));
    }

    @BeforeEach
    void beforeEach() {
        this.threadWatcher = ThreadWatcher.start();
    }

    @AfterEach
    void afterEach() {
        this.threadWatcher.verify();
    }

    @Test
    void testInetAddress_getAllByName() throws UnknownHostException {
        MatcherAssert.assertThat((Object)Arrays.toString(InetAddress.getAllByName("0.0.0.0")), (Matcher)Is.is((Object)"[/0.0.0.0]"));
        MatcherAssert.assertThat((Object)Arrays.toString(InetAddress.getAllByName(null)), (Matcher)Is.is((Object)"[localhost/127.0.0.1]"));
        InetAddress[] localInetAddresses = InetAddress.getAllByName("localhost");
        Arrays.stream(localInetAddresses).map(InetAddress::toString).forEach(i -> MatcherAssert.assertThat((Object)i, (Matcher)Matchers.anyOf((Matcher)Is.is((Object)"localhost/127.0.0.1"), (Matcher)Is.is((Object)"localhost/127.0.1.1"), (Matcher)Is.is((Object)"localhost/0:0:0:0:0:0:0:1"))));
    }

    @Test
    void testInetAddress_getLoopbackAddress_isNotAnyLocalAddress() {
        MatcherAssert.assertThat((Object)InetAddress.getLoopbackAddress().isAnyLocalAddress(), (Matcher)Is.is((Object)false));
    }

    @Test
    void testInetAddress_getLoopbackAddress_is_as_expected() {
        MatcherAssert.assertThat((Object)InetAddress.getLoopbackAddress().toString(), (Matcher)Is.is((Object)"localhost/127.0.0.1"));
    }

    @Test
    void testInetAddress_getLocalHost_isNotAnyLocalAddress() throws UnknownHostException {
        MatcherAssert.assertThat((Object)InetAddress.getLocalHost().isAnyLocalAddress(), (Matcher)Is.is((Object)false));
    }

    @Test
    void testInetAddress_getLocalHostAddress_and_getLoopbackAddress() throws UnknownHostException {
        logger.info("The localhost address is: " + InetAddress.getLocalHost());
        logger.info("The loopback address is: " + InetAddress.getLoopbackAddress());
    }

    @Test
    void testInetAddress_getByName_IP_0_0_0_0_isAnyLocalAddress() throws UnknownHostException {
        MatcherAssert.assertThat((Object)InetAddress.getByName("0.0.0.0").isAnyLocalAddress(), (Matcher)Is.is((Object)true));
    }

    @Test
    void testInetSocketAddresss_constructor_withWildcardAddressAndDefinedPort() throws UnknownHostException {
        InetSocketAddress wildcardAddress = new InetSocketAddress(1234);
        MatcherAssert.assertThat((Object)wildcardAddress.toString(), (Matcher)Is.is((Object)"0.0.0.0/0.0.0.0:1234"));
        MatcherAssert.assertThat((Object)wildcardAddress.isUnresolved(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)wildcardAddress.getPort(), (Matcher)Is.is((Object)1234));
        MatcherAssert.assertThat((Object)wildcardAddress.getAddress(), (Matcher)Is.is((Object)InetAddress.getByName("0.0.0.0")));
        MatcherAssert.assertThat((Object)wildcardAddress.getAddress().toString(), (Matcher)Is.is((Object)"0.0.0.0/0.0.0.0"));
        MatcherAssert.assertThat((Object)wildcardAddress.getHostName(), (Matcher)Is.is((Object)"0.0.0.0"));
        MatcherAssert.assertThat((Object)wildcardAddress.getHostString(), (Matcher)Is.is((Object)"0.0.0.0"));
    }

    @Test
    void testInetSocketAddresss_constructor_withWildcardAddressAndEphemeralPort() throws UnknownHostException {
        InetSocketAddress ephemeralAddress = new InetSocketAddress(0);
        MatcherAssert.assertThat((Object)ephemeralAddress.toString(), (Matcher)Is.is((Object)"0.0.0.0/0.0.0.0:0"));
        MatcherAssert.assertThat((Object)ephemeralAddress.isUnresolved(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)ephemeralAddress.getPort(), (Matcher)Is.is((Object)0));
        MatcherAssert.assertThat((Object)ephemeralAddress.getAddress(), (Matcher)Is.is((Object)InetAddress.getByName("0.0.0.0")));
        MatcherAssert.assertThat((Object)ephemeralAddress.getAddress().toString(), (Matcher)Is.is((Object)"0.0.0.0/0.0.0.0"));
        MatcherAssert.assertThat((Object)ephemeralAddress.getHostName(), (Matcher)Is.is((Object)"0.0.0.0"));
        MatcherAssert.assertThat((Object)ephemeralAddress.getHostString(), (Matcher)Is.is((Object)"0.0.0.0"));
    }

    @Test
    void testInetSocketAddresss_constructor_withEmptyHostnameString() {
        InetSocketAddress emptyHostnameAddress = new InetSocketAddress("", 1234);
        MatcherAssert.assertThat((Object)emptyHostnameAddress.toString(), (Matcher)Is.is((Object)"localhost/127.0.0.1:1234"));
        MatcherAssert.assertThat((Object)emptyHostnameAddress.isUnresolved(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)emptyHostnameAddress.getPort(), (Matcher)Is.is((Object)1234));
        MatcherAssert.assertThat((Object)emptyHostnameAddress.getAddress(), (Matcher)Is.is((Object)InetAddress.getLoopbackAddress()));
        MatcherAssert.assertThat((Object)emptyHostnameAddress.getAddress().toString(), (Matcher)Is.is((Object)"localhost/127.0.0.1"));
        MatcherAssert.assertThat((Object)emptyHostnameAddress.getHostName(), (Matcher)Is.is((Object)"localhost"));
        MatcherAssert.assertThat((Object)emptyHostnameAddress.getHostString(), (Matcher)Is.is((Object)"localhost"));
    }

    @Test
    void testInetSocketAddresss_constructor_withHostnameStringSetToLocalhost() {
        InetSocketAddress loopbackAddress = new InetSocketAddress("localhost", 1234);
        MatcherAssert.assertThat((Object)loopbackAddress.toString(), (Matcher)Is.is((Object)"localhost/127.0.0.1:1234"));
        MatcherAssert.assertThat((Object)loopbackAddress.isUnresolved(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)loopbackAddress.getPort(), (Matcher)Is.is((Object)1234));
        MatcherAssert.assertThat((Object)loopbackAddress.getAddress(), (Matcher)Is.is((Object)InetAddress.getLoopbackAddress()));
        MatcherAssert.assertThat((Object)loopbackAddress.getAddress().toString(), (Matcher)Is.is((Object)"localhost/127.0.0.1"));
        MatcherAssert.assertThat((Object)loopbackAddress.getHostName(), (Matcher)Is.is((Object)"localhost"));
        MatcherAssert.assertThat((Object)loopbackAddress.getHostString(), (Matcher)Is.is((Object)"localhost"));
    }

    @Test
    void testInetSocketAddresss_constructor_withHostnameStringSetToResolvableHost() throws UnknownHostException {
        InetSocketAddress resolvableHostAddress = new InetSocketAddress("psi.ch", 1234);
        MatcherAssert.assertThat((Object)resolvableHostAddress.isUnresolved(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)resolvableHostAddress.toString(), (Matcher)Is.is((Object)"psi.ch/192.33.120.32:1234"));
        MatcherAssert.assertThat((Object)resolvableHostAddress.getPort(), (Matcher)Is.is((Object)1234));
        MatcherAssert.assertThat((Object)resolvableHostAddress.getAddress(), (Matcher)Is.is((Object)InetAddress.getByName("psi.ch")));
        MatcherAssert.assertThat((Object)resolvableHostAddress.getAddress().toString(), (Matcher)Is.is((Object)"psi.ch/192.33.120.32"));
        MatcherAssert.assertThat((Object)resolvableHostAddress.getHostName(), (Matcher)Is.is((Object)"psi.ch"));
        MatcherAssert.assertThat((Object)resolvableHostAddress.getHostString(), (Matcher)Is.is((Object)"psi.ch"));
    }

    @Test
    void testInetSocketAddresss_constructor_withNullHostnameString() throws UnknownHostException {
        InetSocketAddress nullHostAddress = new InetSocketAddress((InetAddress)null, 1234);
        MatcherAssert.assertThat((Object)nullHostAddress.toString(), (Matcher)Is.is((Object)"0.0.0.0/0.0.0.0:1234"));
        MatcherAssert.assertThat((Object)nullHostAddress.isUnresolved(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)nullHostAddress.getPort(), (Matcher)Is.is((Object)1234));
        MatcherAssert.assertThat((Object)nullHostAddress.getAddress(), (Matcher)Is.is((Object)InetAddress.getByName("0.0.0.0")));
        MatcherAssert.assertThat((Object)nullHostAddress.getAddress().toString(), (Matcher)Is.is((Object)"0.0.0.0/0.0.0.0"));
        MatcherAssert.assertThat((Object)nullHostAddress.getHostName(), (Matcher)Is.is((Object)"0.0.0.0"));
        MatcherAssert.assertThat((Object)nullHostAddress.getHostString(), (Matcher)Is.is((Object)"0.0.0.0"));
    }

    @Test
    void testInetSocketAddresss_constructor_withUnresolvedHost() {
        InetSocketAddress unresolvableHostAddress = InetSocketAddress.createUnresolved("somehost", 1234);
        MatcherAssert.assertThat((Object)unresolvableHostAddress.toString(), (Matcher)Is.is((Object)"somehost:1234"));
        MatcherAssert.assertThat((Object)unresolvableHostAddress.isUnresolved(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)unresolvableHostAddress.getPort(), (Matcher)Is.is((Object)1234));
        MatcherAssert.assertThat((Object)unresolvableHostAddress.getAddress(), (Matcher)Is.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)unresolvableHostAddress.getHostName(), (Matcher)Is.is((Object)"somehost"));
        MatcherAssert.assertThat((Object)unresolvableHostAddress.getHostString(), (Matcher)Is.is((Object)"somehost"));
    }

    @Test
    void testCreateDatagramPacket_withoutDestinationAddress_checkProperties() {
        DatagramPacket packet = new DatagramPacket(new byte[0], 0);
        MatcherAssert.assertThat((Object)packet.getPort(), (Matcher)Is.is((Object)-1));
        MatcherAssert.assertThat((Object)packet.getAddress(), (Matcher)Is.is((Matcher)Matchers.nullValue()));
        Assertions.assertThrows(IllegalArgumentException.class, packet::getSocketAddress);
        packet.setPort(33);
        MatcherAssert.assertThat((Object)packet.getPort(), (Matcher)Is.is((Object)33));
        MatcherAssert.assertThat((Object)packet.getAddress(), (Matcher)Is.is((Matcher)Matchers.nullValue()));
        Assertions.assertDoesNotThrow(packet::getSocketAddress);
        MatcherAssert.assertThat((Object)packet.getSocketAddress().toString(), (Matcher)Is.is((Object)"0.0.0.0/0.0.0.0:33"));
    }

    @Test
    void testCreateDatagramPacket_withDestinationAddressExplicitlySetToUnconfigured_checkProperties() {
        DatagramPacket packet = new DatagramPacket(new byte[0], 0, InetAddress.getLoopbackAddress(), 33127);
        MatcherAssert.assertThat((Object)packet.getSocketAddress().toString(), (Matcher)Is.is((Object)"localhost/127.0.0.1:33127"));
        packet.setAddress(null);
        MatcherAssert.assertThat((Object)packet.getAddress(), (Matcher)Is.is((Matcher)Matchers.nullValue()));
        packet.setPort(0);
        MatcherAssert.assertThat((Object)packet.getPort(), (Matcher)Is.is((Object)0));
    }

    @Test
    void testIsSocketAvailable_reportRepeaterPortStatus() throws UnknownHostException {
        InetSocketAddress wildcardAddress = new InetSocketAddress(InetAddress.getLocalHost(), 5065);
        boolean portAvailable = UdpSocketUtilities.isSocketAvailable((InetSocketAddress)wildcardAddress);
        logger.info("The repeater port availability is: " + portAvailable);
    }

    @Test
    void testIsSocketAvailable_noSocketsCreated_returnsTrue() {
        InetSocketAddress wildcardAddress = new InetSocketAddress(11111);
        MatcherAssert.assertThat((Object)UdpSocketUtilities.isSocketAvailable((InetSocketAddress)wildcardAddress), (Matcher)Is.is((Object)true));
    }

    @RepeatedTest(value=100)
    void testIsSocketAvailable_MultipleOpenAndClose() throws SocketException {
        InetSocketAddress wildcardAddress = new InetSocketAddress(11111);
        MatcherAssert.assertThat((Object)UdpSocketUtilities.isSocketAvailable((InetSocketAddress)wildcardAddress), (Matcher)Is.is((Object)true));
        try (DatagramSocket ignored = UdpSocketUtilities.createBroadcastAwareListeningSocket((int)11111, (boolean)true);){
            MatcherAssert.assertThat((Object)UdpSocketUtilities.isSocketAvailable((InetSocketAddress)wildcardAddress), (Matcher)Is.is((Object)false));
        }
    }

    @Test
    void testIsSocketAvailable_ThreadSafety() {
        int testPort = 11111;
        int numThreads = 100;
        ExecutorService executorService = Executors.newFixedThreadPool(100);
        InetSocketAddress wildcardAddress = new InetSocketAddress(11111);
        for (int i = 0; i < 100; ++i) {
            executorService.submit(() -> {
                MatcherAssert.assertThat((Object)UdpSocketUtilities.isSocketAvailable((InetSocketAddress)wildcardAddress), (Matcher)Is.is((Object)true));
                try (DatagramSocket ignored = UdpSocketUtilities.createBroadcastAwareListeningSocket((int)11111, (boolean)true);){
                    MatcherAssert.assertThat((Object)UdpSocketUtilities.isSocketAvailable((InetSocketAddress)wildcardAddress), (Matcher)Is.is((Object)false));
                }
                catch (SocketException e) {
                    e.printStackTrace();
                }
                logger.info("Thread completed.");
            });
            logger.info("Thread: " + i + " submitted");
        }
        executorService.shutdown();
    }

    @CsvSource(value={"0.0.0.0,false", "0.0.0.0,true", "127.0.0.1,false", "127.0.0.1,true"})
    @ParameterizedTest
    void testIsSocketAvailableReturnsFalse_whenSubProcessReservesSocket(String address, boolean socketIsShareable) throws IOException, InterruptedException {
        int testPort = 2222;
        InetSocketAddress wildcardSocketAddress = new InetSocketAddress(2222);
        try (DatagramSocket ignored = UdpSocketUtilities.createBroadcastAwareListeningSocket((int)2222, (boolean)socketIsShareable);){
            MatcherAssert.assertThat((Object)UdpSocketUtilities.isSocketAvailable((InetSocketAddress)wildcardSocketAddress), (Matcher)Is.is((Object)false));
        }
        MatcherAssert.assertThat((Object)UdpSocketUtilities.isSocketAvailable((InetSocketAddress)wildcardSocketAddress), (Matcher)Is.is((Object)true));
        int socketReserveTimeInMilliseconds = 3000;
        JavaProcessManager processManager = UdpSocketReserver.start(address, 2222, 3000);
        Thread.sleep(1500L);
        MatcherAssert.assertThat((Object)processManager.isAlive(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)UdpSocketUtilities.isSocketAvailable((InetSocketAddress)wildcardSocketAddress), (Matcher)Is.is((Object)false));
        processManager.waitFor(5000L, TimeUnit.MILLISECONDS);
        MatcherAssert.assertThat((Object)processManager.isAlive(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)UdpSocketUtilities.isSocketAvailable((InetSocketAddress)wildcardSocketAddress), (Matcher)Is.is((Object)true));
    }

    @CsvSource(value={"0.0.0.0,false", "0.0.0.0,true", "127.0.0.1,false"})
    @ParameterizedTest
    void testSubProcessFailsToReserveSocket_whenReservedByParentProcess(String address, boolean socketIsShareable) throws IOException, InterruptedException {
        int testPort = 9999;
        InetSocketAddress wildcardSocketAddress = new InetSocketAddress(9999);
        try (DatagramSocket ignored = UdpSocketUtilities.createBroadcastAwareListeningSocket((int)9999, (boolean)socketIsShareable);){
            MatcherAssert.assertThat((Object)UdpSocketUtilities.isSocketAvailable((InetSocketAddress)wildcardSocketAddress), (Matcher)Is.is((Object)false));
            int socketReserveTimeInMilliseconds = 10000;
            JavaProcessManager processManager = UdpSocketReserver.start(address, 9999, 10000);
            processManager.waitFor(5000L, TimeUnit.MILLISECONDS);
            MatcherAssert.assertThat((Object)processManager.isAlive(), (Matcher)Is.is((Object)false));
            MatcherAssert.assertThat((Object)processManager.getExitValue(), (Matcher)Is.is((Matcher)Matchers.not((Object)0)));
        }
        MatcherAssert.assertThat((Object)UdpSocketUtilities.isSocketAvailable((InetSocketAddress)wildcardSocketAddress), (Matcher)Is.is((Object)true));
    }

    @ValueSource(booleans={false, true})
    @ParameterizedTest
    void testIsSocketAvailable_wildcardAddressShareability(boolean shareable) throws SocketException {
        InetSocketAddress wildcardSocketAddress = new InetSocketAddress(22222);
        MatcherAssert.assertThat((Object)UdpSocketUtilities.isSocketAvailable((InetSocketAddress)wildcardSocketAddress), (Matcher)Is.is((Object)true));
        try (DatagramSocket socketInUse = UdpSocketUtilities.createUnboundSendSocket();){
            socketInUse.setReuseAddress(shareable);
            socketInUse.bind(wildcardSocketAddress);
            MatcherAssert.assertThat((Object)UdpSocketUtilities.isSocketAvailable((InetSocketAddress)wildcardSocketAddress), (Matcher)Is.is((Object)false));
        }
    }

    @ValueSource(booleans={false, true})
    @ParameterizedTest
    void testIsSocketAvailable_localHostAddressShareability(boolean shareable) throws SocketException, UnknownHostException {
        InetSocketAddress localHostSocketAddress = new InetSocketAddress(InetAddress.getLocalHost(), 33333);
        MatcherAssert.assertThat((Object)UdpSocketUtilities.isSocketAvailable((InetSocketAddress)localHostSocketAddress), (Matcher)Is.is((Object)true));
        try (DatagramSocket socketInUse = UdpSocketUtilities.createUnboundSendSocket();){
            socketInUse.setReuseAddress(shareable);
            socketInUse.bind(localHostSocketAddress);
            MatcherAssert.assertThat((Object)UdpSocketUtilities.isSocketAvailable((InetSocketAddress)localHostSocketAddress), (Matcher)Is.is((Object)false));
        }
    }

    @ValueSource(booleans={false, true})
    @ParameterizedTest
    void testIsSocketAvailable_loopbackAddressShareability(boolean shareable) throws SocketException {
        InetSocketAddress loopbackSocketAddress = new InetSocketAddress(InetAddress.getLoopbackAddress(), 44444);
        MatcherAssert.assertThat((Object)UdpSocketUtilities.isSocketAvailable((InetSocketAddress)loopbackSocketAddress), (Matcher)Is.is((Object)true));
        try (DatagramSocket socketInUse = UdpSocketUtilities.createUnboundSendSocket();){
            socketInUse.setReuseAddress(shareable);
            socketInUse.bind(loopbackSocketAddress);
            MatcherAssert.assertThat((Object)UdpSocketUtilities.isSocketAvailable((InetSocketAddress)loopbackSocketAddress), (Matcher)Is.is((Object)false));
        }
    }

    @ValueSource(booleans={false, true})
    @ParameterizedTest
    void testCreateEphemeralSendSocketProperties(boolean broadcastEnable) throws SocketException {
        DatagramSocket socketReferenceCopy;
        try (DatagramSocket sendSocket = UdpSocketUtilities.createEphemeralSendSocket((boolean)broadcastEnable);){
            socketReferenceCopy = sendSocket;
            MatcherAssert.assertThat((Object)sendSocket.isBound(), (Matcher)Is.is((Object)true));
            MatcherAssert.assertThat((Object)sendSocket.getLocalAddress().toString(), (Matcher)Is.is((Object)"0.0.0.0/0.0.0.0"));
            MatcherAssert.assertThat((Object)sendSocket.getLocalPort(), (Matcher)Matchers.not((Matcher)Is.is((Object)0)));
            MatcherAssert.assertThat((Object)sendSocket.isConnected(), (Matcher)Is.is((Object)false));
            MatcherAssert.assertThat((Object)sendSocket.getPort(), (Matcher)Is.is((Object)-1));
            MatcherAssert.assertThat((Object)sendSocket.getInetAddress(), (Matcher)Is.is((Matcher)Matchers.nullValue()));
            MatcherAssert.assertThat((Object)sendSocket.getRemoteSocketAddress(), (Matcher)Is.is((Matcher)Matchers.nullValue()));
            MatcherAssert.assertThat((Object)sendSocket.isClosed(), (Matcher)Is.is((Object)false));
            MatcherAssert.assertThat((Object)sendSocket.getSoTimeout(), (Matcher)Is.is((Object)0));
            MatcherAssert.assertThat((Object)sendSocket.getBroadcast(), (Matcher)Is.is((Object)broadcastEnable));
            MatcherAssert.assertThat((Object)sendSocket.getReuseAddress(), (Matcher)Is.is((Object)false));
            sendSocket.connect(new InetSocketAddress(InetAddress.getLoopbackAddress(), 1234));
            MatcherAssert.assertThat((Object)sendSocket.isConnected(), (Matcher)Is.is((Object)true));
            MatcherAssert.assertThat((Object)sendSocket.isClosed(), (Matcher)Is.is((Object)false));
            MatcherAssert.assertThat((Object)sendSocket.getRemoteSocketAddress().toString(), (Matcher)Is.is((Object)"localhost/127.0.0.1:1234"));
        }
        MatcherAssert.assertThat((Object)socketReferenceCopy, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)socketReferenceCopy.isConnected(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)socketReferenceCopy.isClosed(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)socketReferenceCopy.isBound(), (Matcher)Is.is((Object)true));
    }

    @Test
    void testCreateUnboundSendSocketProperties() throws IOException {
        DatagramSocket socketReferenceCopy;
        try (DatagramSocket sendSocket = UdpSocketUtilities.createUnboundSendSocket();){
            socketReferenceCopy = sendSocket;
            MatcherAssert.assertThat((Object)sendSocket.isBound(), (Matcher)Is.is((Object)false));
            MatcherAssert.assertThat((Object)sendSocket.getLocalAddress().toString(), (Matcher)Is.is((Object)"0.0.0.0/0.0.0.0"));
            MatcherAssert.assertThat((Object)sendSocket.getLocalPort(), (Matcher)Is.is((Object)0));
            MatcherAssert.assertThat((Object)sendSocket.isConnected(), (Matcher)Is.is((Object)false));
            MatcherAssert.assertThat((Object)sendSocket.getPort(), (Matcher)Is.is((Object)-1));
            MatcherAssert.assertThat((Object)sendSocket.getInetAddress(), (Matcher)Is.is((Matcher)Matchers.nullValue()));
            MatcherAssert.assertThat((Object)sendSocket.getRemoteSocketAddress(), (Matcher)Is.is((Matcher)Matchers.nullValue()));
            MatcherAssert.assertThat((Object)sendSocket.isClosed(), (Matcher)Is.is((Object)false));
            MatcherAssert.assertThat((Object)sendSocket.getSoTimeout(), (Matcher)Is.is((Object)0));
            MatcherAssert.assertThat((Object)sendSocket.getBroadcast(), (Matcher)Is.is((Object)true));
            MatcherAssert.assertThat((Object)sendSocket.getReuseAddress(), (Matcher)Is.is((Object)false));
            DatagramPacket datagramPacket = new DatagramPacket(new byte[]{-86, -69}, 2, new InetSocketAddress(InetAddress.getLoopbackAddress(), 9998));
            sendSocket.send(datagramPacket);
            MatcherAssert.assertThat((Object)sendSocket.isBound(), (Matcher)Is.is((Object)true));
            MatcherAssert.assertThat((Object)sendSocket.getLocalAddress().toString(), (Matcher)Is.is((Object)"0.0.0.0/0.0.0.0"));
            MatcherAssert.assertThat((Object)sendSocket.getLocalPort(), (Matcher)Matchers.not((Matcher)Is.is((Object)0)));
            Throwable throwable = Assertions.assertThrows(SocketException.class, () -> sendSocket.bind(new InetSocketAddress(InetAddress.getLocalHost(), 9999)));
            MatcherAssert.assertThat((Object)throwable.getMessage(), (Matcher)Is.is((Object)"already bound"));
            sendSocket.connect(new InetSocketAddress(InetAddress.getLoopbackAddress(), 1234));
            MatcherAssert.assertThat((Object)sendSocket.isConnected(), (Matcher)Is.is((Object)true));
            MatcherAssert.assertThat((Object)sendSocket.isClosed(), (Matcher)Is.is((Object)false));
            MatcherAssert.assertThat((Object)sendSocket.getRemoteSocketAddress().toString(), (Matcher)Is.is((Object)"localhost/127.0.0.1:1234"));
        }
        MatcherAssert.assertThat((Object)socketReferenceCopy, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)socketReferenceCopy.isConnected(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)socketReferenceCopy.isClosed(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)socketReferenceCopy.isBound(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)socketReferenceCopy.isBound(), (Matcher)Is.is((Object)true));
    }

    @Test
    void testCreateUnboundSendSocket_BindBehaviourFollowingConnect() throws IOException {
        try (DatagramSocket sendSocket = UdpSocketUtilities.createUnboundSendSocket();){
            MatcherAssert.assertThat((Object)sendSocket.isBound(), (Matcher)Is.is((Object)false));
            sendSocket.connect(new InetSocketAddress(InetAddress.getLoopbackAddress(), 1234));
            MatcherAssert.assertThat((Object)sendSocket.isBound(), (Matcher)Is.is((Object)true));
        }
    }

    @ValueSource(strings={"127.0.0.1", "240.0.0.0", "google.com"})
    @ParameterizedTest
    void testSocketSend_investigateMaximumLengthOfDatagram(String inetAddress) throws UnknownHostException {
        int bufferSize = 100000;
        DatagramPacket packet = new DatagramPacket(new byte[100000], 100000, InetAddress.getByName(inetAddress), 7712);
        IOException exception = null;
        int maxDatagramLength = 100000;
        try (DatagramSocket sendSocket = UdpSocketUtilities.createEphemeralSendSocket((boolean)true);){
            for (int i = 0; i < 100000; i += 1000) {
                packet.setLength(i);
                sendSocket.send(packet);
                maxDatagramLength = i;
            }
        }
        catch (IOException ex) {
            exception = ex;
        }
        Assertions.assertNotNull((Object)exception);
        MatcherAssert.assertThat((Object)exception, (Matcher)Matchers.isA(IOException.class));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.anyOf((Matcher)Matchers.containsString((String)"The message is larger than the maximum supported by the underlying transport: Datagram send failed"), (Matcher)Matchers.containsString((String)"Network is unreachable: Datagram send failed"), (Matcher)Matchers.containsString((String)"Message too long"), (Matcher)Matchers.containsString((String)"sendto failed")));
        logger.info("The exception message details were: '" + exception.getMessage() + "'.");
        logger.info("The maximum datagram length for InetAddress: '" + inetAddress + "' is " + maxDatagramLength + " bytes.");
    }

    @Test
    void testSocketSend_investigateAttemptToBroadcastWhenSocketNotBroadcastEnabled() throws UnknownHostException, SocketException {
        Exception exception;
        DatagramPacket packet = new DatagramPacket(new byte[]{-86}, 1, InetAddress.getByName("255.255.255.255"), 6904);
        try (DatagramSocket sendSocket = UdpSocketUtilities.createEphemeralSendSocket((boolean)false);){
            exception = (Exception)Assertions.assertThrows(IOException.class, () -> sendSocket.send(packet));
        }
        MatcherAssert.assertThat((Object)exception, (Matcher)Matchers.isA(IOException.class));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.anyOf((Matcher)Matchers.containsString((String)"Permission denied"), (Matcher)Matchers.containsString((String)"Can't assign requested address (sendto failed)"), (Matcher)Matchers.containsString((String)"No buffer space available (sendto failed)")));
        logger.info("The exception message details were: '" + exception.getMessage() + "'.");
    }

    @Test
    void testSocketSend_investigateNobodyListening() throws UnknownHostException, SocketException {
        Exception exception;
        DatagramPacket packet = new DatagramPacket(new byte[]{-86}, 1, InetAddress.getByName("100::"), 44231);
        try (DatagramSocket sendSocket = UdpSocketUtilities.createEphemeralSendSocket((boolean)false);){
            exception = (Exception)Assertions.assertThrows(IOException.class, () -> sendSocket.send(packet));
        }
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.anyOf((Matcher)Matchers.containsString((String)"Protocol not allowed"), (Matcher)Matchers.containsString((String)"Network is unreachable"), (Matcher)Matchers.containsString((String)"No route to host (sendto failed)"), (Matcher)Matchers.containsString((String)"No buffer space available (sendto failed)"), (Matcher)Matchers.containsString((String)"Protocol family unavailable")));
        logger.info("The exception message details were: '" + exception.getMessage() + "'.");
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void testCreateBroadcastAwareListeningSocket_DefaultProperties(boolean shareable) throws SocketException {
        try (DatagramSocket socket = UdpSocketUtilities.createBroadcastAwareListeningSocket((int)1234, (boolean)shareable);){
            MatcherAssert.assertThat((Object)socket.isClosed(), (Matcher)Is.is((Object)false));
            MatcherAssert.assertThat((Object)socket.getBroadcast(), (Matcher)Is.is((Object)true));
            MatcherAssert.assertThat((Object)socket.isConnected(), (Matcher)Is.is((Object)false));
            String reason = "The socket reuse mode was not as configured. Perhaps it is not available on the current runtime platform.";
            MatcherAssert.assertThat((String)"The socket reuse mode was not as configured. Perhaps it is not available on the current runtime platform.", (Object)socket.getReuseAddress(), (Matcher)Is.is((Object)shareable));
            MatcherAssert.assertThat((Object)socket.isBound(), (Matcher)Is.is((Object)true));
            MatcherAssert.assertThat((Object)socket.getLocalSocketAddress().toString(), (Matcher)Is.is((Object)"0.0.0.0/0.0.0.0:1234"));
            MatcherAssert.assertThat((Object)socket.getLocalAddress().toString(), (Matcher)Is.is((Object)"0.0.0.0/0.0.0.0"));
            MatcherAssert.assertThat((Object)socket.getLocalPort(), (Matcher)Is.is((Object)1234));
            MatcherAssert.assertThat((Object)socket.getReceiveBufferSize(), (Matcher)Is.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(16384))));
            MatcherAssert.assertThat((Object)socket.getRemoteSocketAddress(), (Matcher)Is.is((Matcher)Matchers.nullValue()));
            MatcherAssert.assertThat((Object)socket.getPort(), (Matcher)Is.is((Object)-1));
            MatcherAssert.assertThat((Object)socket.getInetAddress(), (Matcher)Is.is((Matcher)Matchers.nullValue()));
            socket.close();
            MatcherAssert.assertThat((Object)socket.isClosed(), (Matcher)Is.is((Object)true));
            MatcherAssert.assertThat((Object)socket.isBound(), (Matcher)Is.is((Object)true));
        }
    }

    @Test
    void testCreateBroadcastAwareListeningSocket_verifyShareablePortsAreShareable() throws SocketException {
        try (DatagramSocket ignored = UdpSocketUtilities.createBroadcastAwareListeningSocket((int)1234, (boolean)true);){
            Assertions.assertDoesNotThrow(() -> UdpSocketUtilities.createBroadcastAwareListeningSocket((int)1234, (boolean)true).close());
        }
    }

    @Test
    void testCreateBroadcastAwareListeningSocket_verifyUnshareablePortsAreUnshareable() throws SocketException {
        try (DatagramSocket ignored = UdpSocketUtilities.createBroadcastAwareListeningSocket((int)1234, (boolean)false);){
            Assertions.assertThrows(SocketException.class, () -> UdpSocketUtilities.createBroadcastAwareListeningSocket((int)1234, (boolean)false));
        }
    }

    @Test
    void testCreateBroadcastAwareListeningSocket_autoclose() throws SocketException {
        DatagramSocket socketReferenceCopy;
        try (DatagramSocket listeningSocket = UdpSocketUtilities.createBroadcastAwareListeningSocket((int)1234, (boolean)false);){
            socketReferenceCopy = listeningSocket;
            MatcherAssert.assertThat((Object)listeningSocket.isClosed(), (Matcher)Is.is((Object)false));
        }
        MatcherAssert.assertThat((Object)socketReferenceCopy.isClosed(), (Matcher)Is.is((Object)true));
    }

    private static List<Inet4Address> getArgumentsForIntegrationTestBroadcastCapability() throws UnknownHostException {
        InetAddress blacklistAddress = Inet4Address.getByName("192.168.251.255");
        List allAddresses = NetworkUtilities.getLocalBroadcastAddresses();
        return allAddresses.stream().filter(x -> !x.equals(blacklistAddress)).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MethodSource(value={"getArgumentsForIntegrationTestBroadcastCapability"})
    @ParameterizedTest
    void integrationTestBroadcastCapability(Inet4Address broadcastAddress) throws IOException, ExecutionException, InterruptedException {
        logger.info("Testing broadcast address: '" + broadcastAddress + "'.");
        if (NetworkUtilities.isVpnActive()) {
            logger.warning("This test is not supported when a VPN connection is active on the local network interface.");
            return;
        }
        int testPort = 8888;
        DatagramPacket receivePacket = new DatagramPacket(new byte[10], 10);
        try (DatagramSocket listenSocket = UdpSocketUtilities.createBroadcastAwareListeningSocket((int)8888, (boolean)false);
             DatagramSocket sendSocket = UdpSocketUtilities.createUnboundSendSocket();){
            ExecutorService executor = Executors.newSingleThreadExecutor();
            Future<?> f = executor.submit(() -> {
                logger.info("Receive thread starting to listen on address: '" + listenSocket.getLocalSocketAddress() + "'.");
                try {
                    listenSocket.receive(receivePacket);
                    logger.info("Received new packet from: '" + receivePacket.getSocketAddress() + "'.");
                }
                catch (Exception ex) {
                    logger.info("Received thread interrupted by exception: " + ex.getMessage() + ".");
                }
                logger.info("Receiver task completed.");
            });
            logger.info("Sending packet...");
            DatagramPacket sendPacket = new DatagramPacket(new byte[]{-86, -69}, 2);
            sendPacket.setSocketAddress(new InetSocketAddress(broadcastAddress, 8888));
            Assertions.assertDoesNotThrow(() -> sendSocket.send(sendPacket), (String)"The send operation generated an exception. Is this test being run behind a VPN where broadcasts are not supported ?");
            logger.info("Send completed.");
            try {
                logger.info("Waiting 500ms for data...");
                f.get(500L, TimeUnit.MILLISECONDS);
                logger.info("Wait terminated.");
                MatcherAssert.assertThat((Object)receivePacket.getLength(), (Matcher)Is.is((Object)sendPacket.getLength()));
                MatcherAssert.assertThat((Object)receivePacket.getData()[0], (Matcher)Is.is((Object)sendPacket.getData()[0]));
                MatcherAssert.assertThat((Object)receivePacket.getData()[1], (Matcher)Is.is((Object)sendPacket.getData()[1]));
            }
            catch (TimeoutException ex) {
                Assertions.fail((String)"Timeout - data not received.");
                f.cancel(true);
            }
            finally {
                logger.info("cleaning up.");
                executor.shutdown();
            }
        }
    }

    @ValueSource(booleans={true, false})
    @ParameterizedTest
    void integrationTestSynchronousDataTransfer(boolean bindSendSocket) throws Exception {
        DatagramPacket receivePacket = new DatagramPacket(new byte[10], 10);
        DatagramPacket sendPacket = new DatagramPacket(new byte[]{-86, -69}, 2);
        try (DatagramSocket listenSocket = UdpSocketUtilities.createBroadcastAwareListeningSocket((int)12345, (boolean)false);
             DatagramSocket sendSocket = bindSendSocket ? UdpSocketUtilities.createEphemeralSendSocket((boolean)false) : UdpSocketUtilities.createUnboundSendSocket();){
            MatcherAssert.assertThat((Object)sendSocket.isBound(), (Matcher)Is.is((Object)bindSendSocket));
            sendSocket.connect(InetAddress.getLoopbackAddress(), 12345);
            MatcherAssert.assertThat((Object)sendSocket.isConnected(), (Matcher)Is.is((Object)true));
            logger.info("About to send...");
            sendSocket.send(sendPacket);
            logger.info("Sent.");
            logger.info("Waiting for receive to complete");
            try {
                logger.info("Calling receive()...");
                listenSocket.receive(receivePacket);
                logger.info("Received new packet from: " + receivePacket.getSocketAddress());
            }
            catch (Exception ex) {
                logger.info("Exception thrown !" + ex.getMessage());
            }
            logger.info("Receive thread completed");
        }
        MatcherAssert.assertThat((Object)receivePacket.getLength(), (Matcher)Is.is((Object)2));
        MatcherAssert.assertThat((Object)(receivePacket.getSocketAddress() instanceof InetSocketAddress), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((InetSocketAddress)receivePacket.getSocketAddress()).getAddress(), (Matcher)Matchers.not((Matcher)Is.is((Object)InetAddress.getByName("0.0.0.0"))));
        MatcherAssert.assertThat((Object)((InetSocketAddress)receivePacket.getSocketAddress()).getPort(), (Matcher)Matchers.not((Matcher)Is.is((Object)0)));
        MatcherAssert.assertThat((Object)receivePacket.getData()[0], (Matcher)Is.is((Object)sendPacket.getData()[0]));
        MatcherAssert.assertThat((Object)receivePacket.getData()[1], (Matcher)Is.is((Object)sendPacket.getData()[1]));
    }

    @ValueSource(booleans={true, false})
    @ParameterizedTest
    void integrationTestAsynchronousDataTransfer(boolean bindSendSocket) throws Exception {
        DatagramPacket receivePacket = new DatagramPacket(new byte[10], 10);
        DatagramPacket sendPacket = new DatagramPacket(new byte[]{-86, -69}, 2);
        try (DatagramSocket listenSocket = UdpSocketUtilities.createBroadcastAwareListeningSocket((int)12345, (boolean)false);
             DatagramSocket sendSocket = bindSendSocket ? UdpSocketUtilities.createEphemeralSendSocket((boolean)false) : UdpSocketUtilities.createUnboundSendSocket();){
            MatcherAssert.assertThat((Object)sendSocket.isBound(), (Matcher)Is.is((Object)bindSendSocket));
            sendSocket.connect(InetAddress.getLoopbackAddress(), 12345);
            MatcherAssert.assertThat((Object)sendSocket.isConnected(), (Matcher)Is.is((Object)true));
            ExecutorService executor = Executors.newSingleThreadExecutor();
            Future<?> f = executor.submit(() -> {
                logger.info("Receive thread started");
                try {
                    logger.info("Calling receive()...");
                    listenSocket.receive(receivePacket);
                    logger.info("Received new packet from: " + receivePacket.getSocketAddress());
                }
                catch (Exception ex) {
                    logger.info("Exception thrown !" + ex.getMessage());
                }
                logger.info("Receive thread completed");
            });
            logger.info("About to send...");
            sendSocket.send(sendPacket);
            logger.info("Sent. Waiting for receive to complete");
            f.get();
            logger.info("Receive completed");
            executor.shutdown();
        }
        MatcherAssert.assertThat((Object)receivePacket.getLength(), (Matcher)Is.is((Object)2));
        MatcherAssert.assertThat((Object)(receivePacket.getSocketAddress() instanceof InetSocketAddress), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((InetSocketAddress)receivePacket.getSocketAddress()).getAddress(), (Matcher)Matchers.not((Matcher)Is.is((Object)InetAddress.getByName("0.0.0.0"))));
        MatcherAssert.assertThat((Object)((InetSocketAddress)receivePacket.getSocketAddress()).getPort(), (Matcher)Matchers.not((Matcher)Is.is((Object)0)));
        MatcherAssert.assertThat((Object)receivePacket.getData()[0], (Matcher)Is.is((Object)sendPacket.getData()[0]));
        MatcherAssert.assertThat((Object)receivePacket.getData()[1], (Matcher)Is.is((Object)sendPacket.getData()[1]));
    }
}

