/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca;

import java.util.Properties;
import org.apache.commons.lang3.Validate;
import org.epics.ca.Channel;
import org.epics.ca.impl.ContextImpl;
import org.epics.ca.impl.ProtocolConfiguration;

public class Context
implements AutoCloseable {
    private final ContextImpl delegate;

    public Context() {
        this(System.getProperties());
    }

    public Context(Properties properties) {
        Validate.notNull((Object)properties, (String)"null properties", (Object[])new Object[0]);
        ProtocolConfiguration protocolConfiguration = new ProtocolConfiguration(properties);
        this.delegate = new ContextImpl(protocolConfiguration);
    }

    public <T> Channel<T> createChannel(String channelName, Class<T> channelType) {
        return this.delegate.createChannel(channelName, channelType, 0);
    }

    public <T> Channel<T> createChannel(String channelName, Class<T> channelType, int priority) {
        Validate.notNull((Object)channelName);
        Validate.notNull(channelType);
        return this.delegate.createChannel(channelName, channelType, priority);
    }

    @Override
    public void close() {
        this.delegate.close();
    }
}

