/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.Validate;
import org.epics.ca.util.logging.LibraryLogManager;

public class JavaProcessStreamConsumer {
    private static final Logger logger = LibraryLogManager.getLogger(JavaProcessStreamConsumer.class);
    private final InputStream stdout;
    private final InputStream stderr;

    private JavaProcessStreamConsumer(Process process) {
        Validate.notNull((Object)process);
        Validate.isTrue((boolean)process.isAlive());
        this.stdout = process.getInputStream();
        this.stderr = process.getErrorStream();
    }

    public static JavaProcessStreamConsumer consumeFrom(Process process) {
        Validate.notNull((Object)process);
        JavaProcessStreamConsumer javaProcessStreamConsumer = new JavaProcessStreamConsumer(process);
        javaProcessStreamConsumer.start();
        return javaProcessStreamConsumer;
    }

    public void shutdown() {
        try {
            logger.finest("Closing down the STDOUT stream consumer.");
            this.stdout.close();
            logger.finest("The STDOUT stream consumer has been closed.");
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "Exception when closing down the STDOUT stream consumer.", ex);
        }
        try {
            logger.finest("Closing down the STDERR stream consumer.");
            this.stderr.close();
            logger.finest("The STDERR stream consumer has been closed.");
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "Exception when closing down the STDERR stream consumer.", ex);
        }
    }

    private void start() {
        logger.finest("Starting stream consumers...");
        new Thread(() -> this.consumeAndLogSubProcessStream("STDOUT", this.stdout, Level.INFO)).start();
        new Thread(() -> this.consumeAndLogSubProcessStream("STDERR", this.stderr, Level.WARNING)).start();
        logger.finest("The stream consumers are running.");
    }

    private void consumeAndLogSubProcessStream(String streamName, InputStream streamToConsume, Level logLevel) {
        Validate.notBlank((CharSequence)streamName);
        Validate.notNull((Object)streamToConsume);
        Validate.notNull((Object)logLevel);
        try (BufferedReader subProcessStreamReader = new BufferedReader(new InputStreamReader(streamToConsume));){
            logger.finest("Monitoring stream " + streamName + " of type " + streamToConsume.getClass().getSimpleName() + ".");
            try {
                String line;
                while ((line = subProcessStreamReader.readLine()) != null) {
                    logger.log(logLevel, line);
                }
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, "Exception reading stream", ex);
            }
            logger.finest("The stream " + streamName + " has terminated.");
        }
        catch (Exception ex) {
            logger.warning("Failed to read subprocess stream. Exception message: '" + ex.getMessage() + "'.");
        }
    }
}

