/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.impl.monitor.blockingqueue;

import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jcip.annotations.Immutable;
import org.apache.commons.lang3.Validate;
import org.epics.ca.util.logging.LibraryLogManager;

@Immutable
class MonitorNotificationTask<T>
implements Runnable {
    private static final Logger logger = LibraryLogManager.getLogger(MonitorNotificationTask.class);
    private final Supplier<? extends T> valueSupplier;
    private final Consumer<? super T> valueConsumer;

    MonitorNotificationTask(Consumer<? super T> valueConsumer, Supplier<? extends T> valueSupplier) {
        this.valueConsumer = (Consumer)Validate.notNull(valueConsumer);
        this.valueSupplier = (Supplier)Validate.notNull(valueSupplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        MonitorNotificationTask monitorNotificationTask = this;
        synchronized (monitorNotificationTask) {
            try {
                T latestValue = this.valueSupplier.get();
                logger.finest(String.format("Notifying consumer '%s' with value: '%s'... ", this.valueConsumer, latestValue));
                this.valueConsumer.accept(latestValue);
                logger.finest("Notification completed ok");
            }
            catch (RuntimeException ex) {
                logger.log(Level.WARNING, String.format("Unexpected exception during transfer. Message was: '%s'", ex));
                ex.printStackTrace();
            }
        }
    }
}

