/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.impl.repeater;

import java.io.File;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import org.apache.commons.lang3.Validate;
import org.epics.ca.impl.repeater.CARepeaterServiceInstance;
import org.epics.ca.impl.repeater.UdpSocketUtilities;
import org.epics.ca.util.logging.LibraryLogManager;

public class CARepeaterServiceManager {
    private static final Logger logger = LibraryLogManager.getLogger(CARepeaterServiceManager.class);
    private static final File NULL_FILE = new File(System.getProperty("os.name").startsWith("Windows") ? "NUL" : "/dev/null");
    private static final Map<CARepeaterServiceInstance, Integer> serviceInterestMap = new HashMap<CARepeaterServiceInstance, Integer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void requestServiceOnPort(int repeaterPort) {
        Class<CARepeaterServiceManager> clazz = CARepeaterServiceManager.class;
        synchronized (CARepeaterServiceManager.class) {
            logger.fine("Processing request for CA Repeater Services on port '" + repeaterPort + ".");
            int currentInterestLevel = CARepeaterServiceManager.getServiceInterestLevelForPort(repeaterPort);
            if (CARepeaterServiceManager.getServiceInterestLevelForPort(repeaterPort) == 0) {
                logger.fine("Starting the port " + repeaterPort + " CA Repeater Service instance.");
                CARepeaterServiceInstance newInstance = new CARepeaterServiceInstance(repeaterPort);
                serviceInterestMap.put(newInstance, 1);
                newInstance.start();
            } else {
                logger.finer("Increasing the interest level in the port " + repeaterPort + " CA Repeater Service instance.");
                CARepeaterServiceManager.increaseServiceInterestLevelForPort(repeaterPort);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cancelServiceRequestOnPort(int repeaterPort) {
        Class<CARepeaterServiceManager> clazz = CARepeaterServiceManager.class;
        synchronized (CARepeaterServiceManager.class) {
            logger.fine("Processing request for cancellation of CA Repeater Services on port: '" + repeaterPort + "'.");
            int currentInterestLevel = CARepeaterServiceManager.getServiceInterestLevelForPort(repeaterPort);
            switch (currentInterestLevel) {
                case 0: {
                    logger.warning("The CA Repeater Service has received no previous service requests for port " + repeaterPort + ".");
                    break;
                }
                case 1: {
                    logger.fine("Shutting down the port " + repeaterPort + " CA Repeater Service instance.");
                    Optional<CARepeaterServiceInstance> optInstance = CARepeaterServiceManager.getServiceInstanceFor(repeaterPort);
                    Validate.validState((boolean)optInstance.isPresent());
                    serviceInterestMap.remove(optInstance.get());
                    optInstance.get().shutdown();
                    break;
                }
                default: {
                    logger.finer("Reducing the interest level in the port " + repeaterPort + " CA Repeater Service instance.");
                    CARepeaterServiceManager.reduceServiceInterestlevelForPort(repeaterPort);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static boolean isRepeaterRunning(int repeaterPort) {
        logger.finest("Checking whether repeater is running on port " + repeaterPort);
        InetSocketAddress wildcardSocketAddress = new InetSocketAddress(repeaterPort);
        logger.finest("Checking socket address " + wildcardSocketAddress);
        boolean repeaterIsRunning = !UdpSocketUtilities.isSocketAvailable(wildcardSocketAddress);
        String runningOrNot = repeaterIsRunning ? " IS " : " IS NOT ";
        logger.finest("The repeater on port " + repeaterPort + runningOrNot + "running.");
        return repeaterIsRunning;
    }

    static int getServiceInstances() {
        return serviceInterestMap.size();
    }

    private static int getServiceInterestLevelForPort(int port) {
        Validate.inclusiveBetween((long)0L, (long)65535L, (long)port);
        Optional<Integer> currentInterestLevel = serviceInterestMap.entrySet().stream().filter(x -> ((CARepeaterServiceInstance)x.getKey()).getPort() == port).map(Map.Entry::getValue).findFirst();
        return currentInterestLevel.orElse(0);
    }

    private static Optional<CARepeaterServiceInstance> getServiceInstanceFor(int port) {
        Validate.inclusiveBetween((long)0L, (long)65535L, (long)port);
        return serviceInterestMap.keySet().stream().filter(integer -> integer.getPort() == port).findFirst();
    }

    private static void increaseServiceInterestLevelForPort(int port) {
        Validate.inclusiveBetween((long)0L, (long)65535L, (long)port);
        Optional<CARepeaterServiceInstance> instance = CARepeaterServiceManager.getServiceInstanceFor(port);
        Validate.validState((boolean)instance.isPresent());
        int currentInterestLevel = CARepeaterServiceManager.getServiceInterestLevelForPort(port);
        Validate.validState((currentInterestLevel >= 1 ? 1 : 0) != 0);
        int newInterestLevel = CARepeaterServiceManager.getServiceInterestLevelForPort(port) + 1;
        serviceInterestMap.put(instance.get(), newInterestLevel);
    }

    private static void reduceServiceInterestlevelForPort(int port) {
        Validate.inclusiveBetween((long)0L, (long)65535L, (long)port);
        Optional<CARepeaterServiceInstance> instance = CARepeaterServiceManager.getServiceInstanceFor(port);
        Validate.validState((boolean)instance.isPresent());
        int currentInterestLevel = CARepeaterServiceManager.getServiceInterestLevelForPort(port);
        Validate.validState((currentInterestLevel >= 1 ? 1 : 0) != 0);
        int newInterestLevel = currentInterestLevel - 1;
        serviceInterestMap.put(instance.get(), newInterestLevel);
    }
}

