/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.util.sync;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

final class ReferenceCountingLock {
    private final AtomicInteger references = new AtomicInteger(1);
    private final Lock lock = new ReentrantLock();

    public boolean acquire(long msecs) {
        try {
            return this.lock.tryLock(msecs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ie) {
            return false;
        }
    }

    public void release() {
        this.lock.unlock();
    }

    public int increment() {
        return this.references.incrementAndGet();
    }

    public int decrement() {
        return this.references.decrementAndGet();
    }
}

