/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.epics.caj.cas;

import com.cosylab.epics.caj.cas.requests.BeaconRequest;
import com.cosylab.epics.caj.impl.BroadcastTransport;
import com.cosylab.epics.caj.impl.CAContext;
import com.cosylab.epics.caj.util.Timer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BeaconEmitter
implements Timer.TimerRunnable {
    protected static final float EPICS_CA_MAX_BEACON_PERIOD = 15.0f;
    protected static final float EPICS_CA_MIN_BEACON_PERIOD = 0.001f;
    protected Timer timer;
    protected Logger logger;
    protected BroadcastTransport transport;
    protected int beaconSequenceID = 0;
    protected int beaconPeriod = 1;
    protected int maxBeaconPeriod;
    private Object taskID;

    public BeaconEmitter(BroadcastTransport transport, CAContext context, float beaconPeriod) {
        this.transport = transport;
        this.timer = context.getTimer();
        this.logger = context.getLogger();
        this.maxBeaconPeriod = (int)(Math.max(beaconPeriod, 0.001f) * 1000.0f);
    }

    protected void start() {
        this.reschedule();
    }

    protected void reschedule() {
        this.taskID = this.timer.executeAfterDelay(this.beaconPeriod, this);
    }

    @Override
    public void timeout(long timeToRun) {
        try {
            new BeaconRequest(this.transport, this.beaconSequenceID).submit();
        }
        catch (Throwable th) {
            this.logger.log(Level.WARNING, "Failed to send beacon.", th);
        }
        ++this.beaconSequenceID;
        if (this.beaconPeriod < this.maxBeaconPeriod) {
            this.beaconPeriod = Math.min(this.beaconPeriod * 2, this.maxBeaconPeriod);
        }
        this.reschedule();
    }

    public void destroy() {
        if (this.taskID != null) {
            Timer.cancel(this.taskID);
        }
    }
}

