/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.epics.caj.cas;

import com.cosylab.epics.caj.cas.CAJServerContext;
import com.cosylab.epics.caj.cas.CASResponseHandler;
import com.cosylab.epics.caj.impl.CAContext;
import com.cosylab.epics.caj.impl.CachedByteBufferAllocator;
import com.cosylab.epics.caj.impl.Request;
import com.cosylab.epics.caj.impl.ResponseHandler;
import com.cosylab.epics.caj.impl.Transport;
import com.cosylab.epics.caj.impl.reactor.ReactorHandler;
import com.cosylab.epics.caj.impl.reactor.lf.LeaderFollowersThreadPool;
import com.cosylab.epics.caj.util.IntHashMap;
import gov.aps.jca.CAStatus;
import gov.aps.jca.CAStatusException;
import gov.aps.jca.cas.ServerChannel;
import gov.aps.jca.dbr.DBR_STSACK_String;
import gov.aps.jca.dbr.DBR_String;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CASTransport
implements Transport,
ReactorHandler,
Runnable {
    private static final Logger logger = Logger.getLogger(CASTransport.class.getName());
    private volatile boolean closed = false;
    private CAJServerContext context;
    private SocketChannel channel;
    private InetSocketAddress socketAddress;
    private ByteBuffer[] receiveBuffer;
    private LinkedList sendQueue;
    private short remoteTransportRevision;
    private short priority;
    private Object sendLock = new Object();
    private volatile boolean flushPending = false;
    private ByteBuffer sendBuffer;
    private CachedByteBufferAllocator bufferAllocator;
    protected ResponseHandler responseHandler = null;
    private ByteBuffer lastActiveSendBuffer = null;
    private String clientHostname = null;
    private String clientUsername = null;
    private volatile boolean replaceEventPolicy = false;
    private volatile boolean processEvents = true;
    private Thread processEventThread;
    private final LinkedList eventQueue = new LinkedList();
    private IntHashMap channels;
    private Runnable flushTask = new Runnable(){

        @Override
        public void run() {
            CASTransport.this.flushInternal();
        }
    };
    static final int CA_SERVER_THREAD_PRIORITY_MIN = 4;
    static final int CA_SERVER_THREAD_PRIORITY_MAX = 9;

    public CASTransport(CAContext context, SocketChannel channel) {
        this.context = (CAJServerContext)context;
        this.channel = channel;
        this.remoteTransportRevision = 0;
        int INITIAL_SIZE = 64;
        this.channels = new IntHashMap(64);
        this.receiveBuffer = new ByteBuffer[]{ByteBuffer.allocate(24), ByteBuffer.allocate(Math.max(16408, this.context.getMaxArrayBytes() + 8))};
        this.receiveBuffer[0].limit(16);
        this.sendQueue = new LinkedList();
        this.bufferAllocator = context.getCachedBufferAllocator();
        this.sendBuffer = this.bufferAllocator.get();
        this.responseHandler = new CASResponseHandler(this.context);
        this.socketAddress = (InetSocketAddress)channel.socket().getRemoteSocketAddress();
        this.processEventThread = new Thread((Runnable)this, this.socketAddress + "event dispatcher");
        this.setPriority((short)0);
        this.processEventThread.start();
        context.getTransportRegistry().put(this.socketAddress, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close(boolean forced) {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.context.getTransportRegistry().remove(this.socketAddress, (short)0);
        this.destroyAllChannels();
        LinkedList linkedList = this.eventQueue;
        synchronized (linkedList) {
            this.eventQueue.notify();
        }
        if (!forced) {
            this.flushInternal();
        }
        this.freeSendBuffers();
        this.context.getLogger().finer("Connection to " + this.socketAddress + " closed.");
        this.context.getReactor().unregisterAndClose(this.channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyAllChannels() {
        Object[] channelsArray;
        IntHashMap intHashMap = this.channels;
        synchronized (intHashMap) {
            if (this.channels.size() == 0) {
                return;
            }
            channelsArray = new ServerChannel[this.channels.size()];
            this.channels.toArray(channelsArray);
            this.channels.clear();
        }
        this.context.getLogger().fine("Transport to " + this.socketAddress + " still has " + channelsArray.length + " channel(s) active and closing...");
        for (int i2 = 0; i2 < channelsArray.length; ++i2) {
            try {
                ((ServerChannel)channelsArray[i2]).destroy();
                continue;
            }
            catch (Throwable th) {
                logger.log(Level.SEVERE, "", th);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void freeSendBuffers() {
        LinkedList linkedList = this.sendQueue;
        synchronized (linkedList) {
            this.sendBuffer = null;
            this.lastActiveSendBuffer = null;
            while (this.sendQueue.size() > 0) {
                this.bufferAllocator.put((ByteBuffer)this.sendQueue.removeFirst());
            }
        }
    }

    @Override
    public short getMinorRevision() {
        return this.remoteTransportRevision;
    }

    public void setMinorRevision(short minorRevision) {
        this.remoteTransportRevision = minorRevision;
    }

    @Override
    public void handleEvent(SelectionKey key) {
        if (key.isValid() && key.isReadable()) {
            this.processRead();
        }
        if (key.isValid() && key.isWritable()) {
            this.processWrite();
        }
    }

    protected void processRead() {
        try {
            while (true) {
                if (this.closed) {
                    return;
                }
                ByteBuffer headerBuffer = this.receiveBuffer[0];
                ByteBuffer payloadBuffer = this.receiveBuffer[1];
                if (headerBuffer.hasRemaining()) {
                    if (this.channel.read(headerBuffer) < 0) {
                        this.close(true);
                        return;
                    }
                    if (headerBuffer.hasRemaining()) break;
                    int payloadSize = headerBuffer.getShort(2) & 0xFFFF;
                    if (payloadSize == 65535) {
                        if (headerBuffer.limit() == 24) {
                            payloadSize = headerBuffer.getInt(16);
                        } else {
                            headerBuffer.limit(24);
                            continue;
                        }
                    }
                    if (payloadSize > payloadBuffer.capacity()) {
                        this.receiveBuffer[1] = ByteBuffer.allocate(payloadSize);
                        payloadBuffer = this.receiveBuffer[1];
                    }
                    payloadBuffer.clear();
                    payloadBuffer.limit(payloadSize);
                }
                if (payloadBuffer.limit() == 0) {
                    try {
                        headerBuffer.flip();
                        this.responseHandler.handleResponse(this.socketAddress, this, this.receiveBuffer);
                    }
                    catch (Throwable th) {
                        logger.log(Level.SEVERE, "", th);
                    }
                    headerBuffer.clear();
                    headerBuffer.limit(16);
                    continue;
                }
                if (!payloadBuffer.hasRemaining()) continue;
                this.channel.read(payloadBuffer);
                if (payloadBuffer.hasRemaining()) break;
                headerBuffer.flip();
                payloadBuffer.flip();
                try {
                    this.responseHandler.handleResponse(this.socketAddress, this, this.receiveBuffer);
                }
                catch (Throwable th) {
                    logger.log(Level.SEVERE, "", th);
                }
                headerBuffer.clear();
                headerBuffer.limit(16);
            }
        }
        catch (IOException ioex) {
            this.close(true);
        }
    }

    protected void processWrite() {
        this.flushInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(ByteBuffer buffer) throws IOException {
        Object object = this.sendLock;
        synchronized (object) {
            try {
                buffer.flip();
                int SEND_BUFFER_LIMIT = 16000;
                int bufferLimit = buffer.limit();
                int parts = (buffer.limit() - 1) / 16000 + 1;
                block7: for (int part = 1; part <= parts; ++part) {
                    if (parts > 1) {
                        buffer.limit(Math.min(part * 16000, bufferLimit));
                        this.context.getLogger().finest("[Parted] Sending (part " + part + "/" + parts + ") " + (buffer.limit() - buffer.position()) + " bytes to " + this.socketAddress + ".");
                    }
                    int TRIES = 10;
                    int tries = 0;
                    while (true) {
                        this.channel.write(buffer);
                        if (buffer.position() == buffer.limit()) continue block7;
                        if (tries == 10) {
                            this.context.getLogger().warning("Failed to send message to " + this.socketAddress + " - buffer full.");
                            return;
                        }
                        this.context.getLogger().finest("Send buffer full for " + this.socketAddress + ", waiting...");
                        this.channel.socket().getOutputStream().flush();
                        try {
                            Thread.sleep(10 + tries * 100);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        ++tries;
                    }
                }
            }
            catch (IOException ioex) {
                this.close(true);
                throw ioex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean flush() {
        LinkedList linkedList = this.sendQueue;
        synchronized (linkedList) {
            if (this.closed || this.sendBuffer == null) {
                return false;
            }
            if (this.sendBuffer.position() == 0) {
                return true;
            }
            if (this.lastActiveSendBuffer != null && this.lastActiveSendBuffer.position() + this.sendBuffer.position() <= this.lastActiveSendBuffer.capacity()) {
                this.sendBuffer.flip();
                this.lastActiveSendBuffer.put(this.sendBuffer);
                this.sendBuffer.clear();
                return true;
            }
            this.sendQueue.add(this.sendBuffer);
            this.lastActiveSendBuffer = this.sendBuffer;
            this.sendBuffer = this.bufferAllocator.get();
            if (this.flushPending) {
                return true;
            }
            this.flushPending = true;
        }
        return this.spawnFlushing();
    }

    private boolean spawnFlushing() {
        LeaderFollowersThreadPool lftp = this.context.getLeaderFollowersThreadPool();
        if (lftp != null) {
            lftp.execute(this.flushTask);
            return true;
        }
        this.context.getReactor().setInterestOps(this.channel, 5);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean flushInternal() {
        if (this.sendBuffer == null) {
            return false;
        }
        try {
            while (this.sendQueue.size() > 0) {
                ByteBuffer buf;
                LinkedList linkedList = this.sendQueue;
                synchronized (linkedList) {
                    block29: {
                        if (this.sendQueue.size() != 0) break block29;
                        boolean bl = true;
                        return bl;
                    }
                    buf = (ByteBuffer)this.sendQueue.removeFirst();
                    if (buf == this.lastActiveSendBuffer) {
                        this.lastActiveSendBuffer = null;
                    }
                }
                try {
                    this.send(buf);
                }
                finally {
                    this.bufferAllocator.put(buf);
                }
            }
            boolean buf = true;
            return buf;
        }
        catch (IOException ioex) {
            this.close(true);
            boolean bl = false;
            return bl;
        }
        finally {
            LinkedList linkedList = this.sendQueue;
            synchronized (linkedList) {
                this.flushPending = false;
                if (!this.closed && this.sendQueue.size() > 0) {
                    this.spawnFlushing();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submit(Request requestMessage) throws IOException {
        ByteBuffer message = requestMessage.getRequestMessage();
        if (message.capacity() == 0) {
            return;
        }
        if (requestMessage.getPriority() == 100) {
            this.send(message);
        } else {
            message.flip();
            LinkedList linkedList = this.sendQueue;
            synchronized (linkedList) {
                if (this.sendBuffer == null) {
                    throw new IllegalStateException("transport closed");
                }
                if (message.limit() + this.sendBuffer.position() > this.sendBuffer.capacity()) {
                    this.flush();
                }
                this.sendBuffer.put(message);
            }
        }
    }

    @Override
    public CAContext getContext() {
        return this.context;
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.socketAddress;
    }

    @Override
    public short getPriority() {
        return this.priority;
    }

    private static final int getNativeThreadPriority(short priority) {
        int nativePriority = priority - 0;
        nativePriority *= 5;
        nativePriority /= 99;
        return ++nativePriority;
    }

    public void setPriority(short priority) {
        if (priority < 0) {
            priority = 0;
        } else if (priority > 99) {
            priority = (short)99;
        }
        this.priority = priority;
        int nativePriority = CASTransport.getNativeThreadPriority(priority);
        if (nativePriority != Thread.currentThread().getPriority()) {
            Thread.currentThread().setPriority(nativePriority);
        }
    }

    public String getClientHostname() {
        return this.clientHostname;
    }

    public String getClientUsername() {
        return this.clientUsername;
    }

    public void setClientHostname(String clientHostname) {
        this.clientHostname = clientHostname;
        this.context.getLogger().fine("Client " + this.socketAddress + " is setting hostname to '" + clientHostname + "'.");
    }

    public void setClientUsername(String clientUsername) {
        this.clientUsername = clientUsername;
        this.context.getLogger().fine("Client " + this.socketAddress + " is setting username to '" + clientUsername + "'.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int preallocateChannelSID() {
        IntHashMap intHashMap = this.channels;
        synchronized (intHashMap) {
            int sid = this.context.generateChannelSID();
            while (this.channels.containsKey(sid)) {
                sid = this.context.generateChannelSID();
            }
            return sid;
        }
    }

    public void depreallocateChannelSID(int sid) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerChannel(int sid, ServerChannel channel) {
        IntHashMap intHashMap = this.channels;
        synchronized (intHashMap) {
            this.channels.put(sid, channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterChannel(int sid) {
        IntHashMap intHashMap = this.channels;
        synchronized (intHashMap) {
            this.channels.remove(sid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerChannel getChannel(int sid) {
        IntHashMap intHashMap = this.channels;
        synchronized (intHashMap) {
            return (ServerChannel)this.channels.get(sid);
        }
    }

    public ServerChannel getChannelAndVerifyRequest(int sid, short dataType, int dataCount) throws CAStatusException {
        ServerChannel channel = this.getChannel(sid);
        if (channel == null) {
            throw new CAStatusException(CAStatus.BADCHID);
        }
        if (dataType < DBR_String.TYPE.getValue() || dataType > DBR_STSACK_String.TYPE.getValue()) {
            throw new CAStatusException(CAStatus.BADTYPE);
        }
        if (dataCount <= 0) {
            throw new CAStatusException(CAStatus.BADCOUNT);
        }
        return channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChannelCount() {
        IntHashMap intHashMap = this.channels;
        synchronized (intHashMap) {
            return this.channels.size();
        }
    }

    public void eventsOff() {
        this.replaceEventPolicy = true;
        this.processEvents = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eventsOn() {
        this.replaceEventPolicy = false;
        this.processEvents = true;
        LinkedList linkedList = this.eventQueue;
        synchronized (linkedList) {
            this.eventQueue.notify();
        }
    }

    public final boolean hasReplaceEventPolicy() {
        return this.replaceEventPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processEvents(Runnable event) {
        if (!this.processEvents || this.closed) {
            return false;
        }
        LinkedList linkedList = this.eventQueue;
        synchronized (linkedList) {
            this.eventQueue.addLast(event);
            this.eventQueue.notify();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            Runnable event;
            LinkedList linkedList = this.eventQueue;
            synchronized (linkedList) {
                while (!(!this.eventQueue.isEmpty() && this.processEvents || this.closed)) {
                    try {
                        this.eventQueue.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.closed) {
                    this.eventQueue.clear();
                    return;
                }
                event = (Runnable)this.eventQueue.removeFirst();
            }
            try {
                event.run();
                continue;
            }
            catch (Throwable th) {
                logger.log(Level.SEVERE, "", th);
                continue;
            }
            break;
        }
    }
}

