/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.epics.caj.cas.handlers;

import com.cosylab.epics.caj.cas.CAJServerContext;
import com.cosylab.epics.caj.cas.CASTransport;
import com.cosylab.epics.caj.cas.ProcessVariableEventDispatcher;
import com.cosylab.epics.caj.cas.handlers.AbstractCASResponseHandler;
import com.cosylab.epics.caj.cas.requests.AccessRightsRequest;
import com.cosylab.epics.caj.cas.requests.CreateChannelFailedRequest;
import com.cosylab.epics.caj.cas.requests.ExceptionRequest;
import com.cosylab.epics.caj.impl.Transport;
import com.cosylab.epics.caj.impl.requests.CreateChannelRequest;
import gov.aps.jca.CAStatus;
import gov.aps.jca.CAStatusException;
import gov.aps.jca.cas.ProcessVariable;
import gov.aps.jca.cas.ProcessVariableAttachCallback;
import gov.aps.jca.cas.ServerChannel;
import gov.aps.jca.dbr.DBR_STS_String;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.logging.Level;

public class CreateChannelResponse
extends AbstractCASResponseHandler {
    public CreateChannelResponse(CAJServerContext context) {
        super(context, "Create channel request");
    }

    @Override
    protected void internalHandleResponse(InetSocketAddress responseFrom, Transport transport, ByteBuffer[] response) {
        CASTransport casTransport = (CASTransport)transport;
        short minorVersion = 0;
        if (this.parameter2 < 65535) {
            minorVersion = (short)this.parameter2;
        }
        casTransport.setMinorRevision(minorVersion);
        if (minorVersion < 4) {
            this.sendException(transport, this.parameter1, CAStatus.DEFUNCT, response[0], "R3.11 connect sequence from old client was ignored.");
            this.disconnect(transport);
            return;
        }
        if (this.payloadSize <= 1) {
            this.context.getLogger().warning("Zero length channel name, disconnecting client: " + transport.getRemoteAddress());
            this.disconnect(transport);
            return;
        }
        String channelName = CreateChannelResponse.extractString(response[1], 0, this.payloadSize, false);
        if (channelName.length() > 500) {
            this.context.getLogger().warning("Unreasonable channel name length, disconnecting client: " + transport.getRemoteAddress());
            this.disconnect(transport);
            return;
        }
        ProcessVariable pv = null;
        ProcessVariableEventDispatcher pved = new ProcessVariableEventDispatcher(null);
        try {
            ProcessVariableAttachCallbackImpl pvac = new ProcessVariableAttachCallbackImpl(transport, channelName, this.parameter1, pved);
            pv = this.context.getServer().processVariableAttach(channelName, pved, pvac);
        }
        catch (CAStatusException cse) {
            this.context.getLogger().log(Level.WARNING, "Exception caught when calling Server.processVariableAttach() for: " + channelName, cse);
            this.createChannelFailedResponse(transport, channelName, this.parameter1, cse.getStatus(), cse.getMessage());
        }
        catch (Throwable th) {
            this.context.getLogger().log(Level.WARNING, "Exception caught when calling Server.processVariableAttach() for: " + channelName, th);
            this.createChannelFailedResponse(transport, channelName, this.parameter1, CAStatus.DEFUNCT, th.getMessage());
        }
        if (pv != null) {
            this.createChannelResponse(transport, channelName, this.parameter1, pv, pved);
        }
    }

    private void createChannelResponse(Transport transport, String channelName, int cid, ProcessVariable pv, ProcessVariableEventDispatcher pved) {
        block9: {
            ServerChannel channel = null;
            try {
                if (pv == null) {
                    throw new CAStatusException(CAStatus.DEFUNCT, "ProcessVariable.processVariableAttach() must return non-null value.");
                }
                if (pv.getType().getValue() >= DBR_STS_String.TYPE.getValue()) {
                    throw new CAStatusException(CAStatus.BADTYPE, "ProcessVariable.getType() must return pute DBR type.");
                }
                pved.setProcessVariable(pv);
                CASTransport casTransport = (CASTransport)transport;
                int sid = casTransport.preallocateChannelSID();
                try {
                    channel = pv.createChannel(cid, sid, casTransport.getClientUsername(), casTransport.getClientHostname());
                    if (channel == null) {
                        throw new CAStatusException(CAStatus.DEFUNCT, "null channel returned.");
                    }
                    casTransport.registerChannel(sid, channel);
                }
                catch (Throwable th) {
                    casTransport.depreallocateChannelSID(sid);
                    throw th;
                }
                new AccessRightsRequest(transport, channel).submit();
                new com.cosylab.epics.caj.cas.requests.CreateChannelRequest(transport, channel).submit();
            }
            catch (CAStatusException cse) {
                this.context.getLogger().log(Level.WARNING, "Exception caught when creating channel: " + channelName, cse);
                this.createChannelFailedResponse(transport, channelName, cid, cse.getStatus(), cse.getMessage());
                if (channel != null) {
                    channel.destroy();
                }
            }
            catch (Throwable th) {
                this.context.getLogger().log(Level.WARNING, "Exception caught when creating channel: " + channelName, th);
                this.createChannelFailedResponse(transport, channelName, cid, CAStatus.DEFUNCT, th.getMessage());
                if (channel == null) break block9;
                channel.destroy();
            }
        }
    }

    private void createChannelFailedResponse(Transport transport, String channelName, int cid, CAStatus errorStatus, String message) {
        try {
            if (transport.getMinorRevision() >= 6) {
                new CreateChannelFailedRequest(transport, cid).submit();
            } else {
                CreateChannelRequest ccr = new CreateChannelRequest(transport, channelName, cid);
                ExceptionRequest exceptionRequest = new ExceptionRequest(transport, cid, errorStatus, ccr.generateRequestMessage(), message);
                exceptionRequest.submit();
            }
        }
        catch (Throwable th) {
            this.context.getLogger().log(Level.WARNING, "Failed to send channel failed to create response for: " + channelName, th);
        }
    }

    private void disconnect(Transport transport) {
        ((CASTransport)transport).close(true);
    }

    class ProcessVariableAttachCallbackImpl
    implements ProcessVariableAttachCallback {
        private Transport transport;
        private String channelName;
        private int cid;
        private ProcessVariableEventDispatcher pved;

        public ProcessVariableAttachCallbackImpl(Transport transport, String channelName, int cid, ProcessVariableEventDispatcher pved) {
            this.transport = transport;
            this.channelName = channelName;
            this.cid = cid;
            this.pved = pved;
        }

        @Override
        public void processVariableAttachCompleted(ProcessVariable processVariable) {
            CreateChannelResponse.this.createChannelResponse(this.transport, this.channelName, this.cid, processVariable, this.pved);
        }

        @Override
        public void canceled() {
            CreateChannelResponse.this.createChannelFailedResponse(this.transport, this.channelName, this.cid, CAStatus.DEFUNCT, "Async IO canceled.");
        }
    }
}

