/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.epics.caj.cas.handlers;

import com.cosylab.epics.caj.cas.CAJServerContext;
import com.cosylab.epics.caj.cas.CASTransport;
import com.cosylab.epics.caj.cas.handlers.AbstractCASResponseHandler;
import com.cosylab.epics.caj.cas.requests.ReadNotifyRequest;
import com.cosylab.epics.caj.impl.Transport;
import gov.aps.jca.CAStatus;
import gov.aps.jca.CAStatusException;
import gov.aps.jca.cas.ProcessVariable;
import gov.aps.jca.cas.ProcessVariableReadCallback;
import gov.aps.jca.cas.ServerChannel;
import gov.aps.jca.dbr.ACK;
import gov.aps.jca.dbr.DBR;
import gov.aps.jca.dbr.DBRFactory;
import gov.aps.jca.dbr.DBRType;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.logging.Level;

public class ReadNotifyResponse
extends AbstractCASResponseHandler {
    public ReadNotifyResponse(CAJServerContext context) {
        super(context, "Read notify request");
    }

    @Override
    protected void internalHandleResponse(InetSocketAddress responseFrom, Transport transport, ByteBuffer[] response) {
        ServerChannel channel;
        CASTransport casTransport = (CASTransport)transport;
        try {
            channel = casTransport.getChannelAndVerifyRequest(this.parameter1, this.dataType, this.dataCount);
        }
        catch (CAStatusException cse) {
            this.readNotifyFailureResponse(transport, this.dataType, this.dataCount, this.parameter1, this.parameter2, cse.getStatus());
            return;
        }
        if (!channel.readAccess()) {
            this.readNotifyFailureResponse(transport, this.dataType, this.dataCount, this.parameter1, this.parameter2, CAStatus.NORDACCESS);
            return;
        }
        ProcessVariable processVariable = channel.getProcessVariable();
        DBR value = ReadNotifyResponse.createDBRforReading(processVariable, this.dataType, this.dataCount);
        CAStatus status = null;
        try {
            ProcessVariableReadCallbackImpl pvrc = new ProcessVariableReadCallbackImpl(processVariable, transport, this.dataType, this.dataCount, this.parameter1, this.parameter2, value);
            status = channel.read(value, pvrc);
        }
        catch (Throwable th) {
            this.context.getLogger().log(Level.WARNING, "Exception caught when calling ServerChannel.read() for: " + channel.getProcessVariable().getName(), th);
            this.readNotifyFailureResponse(transport, this.dataType, this.dataCount, this.parameter1, this.parameter2, CAStatus.DEFUNCT);
            return;
        }
        if (status == null) {
            return;
        }
        this.readNotifyResponse(processVariable, transport, this.dataType, this.dataCount, this.parameter1, this.parameter2, value, status);
    }

    private void readNotifyResponse(ProcessVariable processVariable, Transport transport, short dataType, int dataCount, int sid, int ioid, DBR value, CAStatus status) {
        if (status != CAStatus.NORMAL) {
            this.readNotifyFailureResponse(transport, dataType, dataCount, sid, ioid, status);
            return;
        }
        try {
            value = value.convert(DBRType.forValue(dataType));
        }
        catch (CAStatusException cse) {
            this.readNotifyFailureResponse(transport, dataType, dataCount, sid, ioid, cse.getStatus());
            return;
        }
        if (value instanceof ACK) {
            ACK ack = (ACK)((Object)value);
            ack.setAckS(processVariable.getAckS());
            ack.setAckT(processVariable.isAckT());
        }
        try {
            new ReadNotifyRequest(transport, CAStatus.NORMAL.getStatusCode(), ioid, dataType, dataCount, value).submit();
        }
        catch (Throwable th) {
            this.context.getLogger().log(Level.WARNING, "Exception caught when responding to read notify request for channel with SID : " + sid, th);
        }
    }

    private void readNotifyFailureResponse(Transport transport, short dataType, int dataCount, int sid, int ioid, CAStatus errorStatus) {
        try {
            DBR value = DBRFactory.create(dataType, dataCount);
            new ReadNotifyRequest(transport, errorStatus.getStatusCode(), ioid, dataType, dataCount, value).submit();
        }
        catch (Throwable th) {
            this.context.getLogger().log(Level.WARNING, "Exception caught when responding with error to read notify request for channel with SID : " + sid, th);
        }
    }

    class ProcessVariableReadCallbackImpl
    implements ProcessVariableReadCallback {
        private ProcessVariable processVariable;
        private Transport transport;
        private short dataType;
        private int dataCount;
        private int sid;
        private int ioid;
        private DBR value;

        public ProcessVariableReadCallbackImpl(ProcessVariable processVariable, Transport transport, short dataType, int dataCount, int sid, int ioid, DBR value) {
            this.processVariable = processVariable;
            this.transport = transport;
            this.dataType = dataType;
            this.dataCount = dataCount;
            this.sid = sid;
            this.ioid = ioid;
            this.value = value;
        }

        @Override
        public void processVariableReadCompleted(CAStatus status) {
            if (status == null) {
                status = CAStatus.DEFUNCT;
            }
            ReadNotifyResponse.this.readNotifyResponse(this.processVariable, this.transport, this.dataType, this.dataCount, this.sid, this.ioid, this.value, status);
        }

        @Override
        public void canceled() {
            ReadNotifyResponse.this.readNotifyFailureResponse(this.transport, this.dataType, this.dataCount, this.sid, this.ioid, CAStatus.GETFAIL);
        }
    }
}

