/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.epics.caj.impl;

import com.cosylab.epics.caj.impl.BroadcastTransport;
import com.cosylab.epics.caj.impl.CAContext;
import com.cosylab.epics.caj.impl.ConnectionException;
import com.cosylab.epics.caj.impl.Connector;
import com.cosylab.epics.caj.impl.ResponseHandler;
import com.cosylab.epics.caj.impl.Transport;
import com.cosylab.epics.caj.impl.TransportClient;
import java.net.InetSocketAddress;
import java.nio.channels.DatagramChannel;

public class BroadcastConnector
implements Connector {
    private CAContext context;

    public BroadcastConnector(CAContext context) {
        this.context = context;
    }

    @Override
    public Transport connect(TransportClient client, ResponseHandler responseHandler, InetSocketAddress connectAddress, short transportRevision, short priority) throws ConnectionException {
        this.context.getLogger().finer("Creating datagram socket to: " + connectAddress);
        DatagramChannel socket = null;
        try {
            socket = DatagramChannel.open();
            socket.configureBlocking(false);
            socket.socket().setBroadcast(true);
            BroadcastTransport transport = new BroadcastTransport(this.context, responseHandler, socket, connectAddress, transportRevision);
            return transport;
        }
        catch (Throwable th) {
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new ConnectionException("Failed to connect to '" + connectAddress + "'.", connectAddress, th);
        }
    }
}

