/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.epics.caj.impl;

import com.cosylab.epics.caj.CAJContext;
import com.cosylab.epics.caj.impl.CATransport;
import com.cosylab.epics.caj.impl.ConnectionException;
import com.cosylab.epics.caj.impl.Connector;
import com.cosylab.epics.caj.impl.ResponseHandler;
import com.cosylab.epics.caj.impl.Transport;
import com.cosylab.epics.caj.impl.TransportClient;
import com.cosylab.epics.caj.impl.reactor.ReactorHandler;
import com.cosylab.epics.caj.impl.reactor.lf.LeaderFollowersHandler;
import com.cosylab.epics.caj.impl.requests.HostNameRequest;
import com.cosylab.epics.caj.impl.requests.UserNameRequest;
import com.cosylab.epics.caj.impl.requests.VersionRequest;
import com.cosylab.epics.caj.impl.sync.NamedLockPattern;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.channels.spi.AbstractSelectableChannel;

public class CAConnector
implements Connector {
    private CAJContext context;
    private NamedLockPattern namedLocker;
    private static final int LOCK_TIMEOUT = 20000;

    public CAConnector(CAJContext context) {
        this.context = context;
        this.namedLocker = new NamedLockPattern();
    }

    @Override
    public Transport connect(TransportClient client, ResponseHandler responseHandler, InetSocketAddress address, short transportRevision, short priority) throws ConnectionException {
        boolean lockAcquired;
        AbstractInterruptibleChannel socket = null;
        CATransport transport = (CATransport)this.context.getTransportRegistry().get(address, priority);
        if (transport != null) {
            this.context.getLogger().finer("Reusing existant connection to CA server: " + address);
            if (transport.acquire(client)) {
                return transport;
            }
        }
        if (lockAcquired = this.namedLocker.acquireSynchronizationObject(address, 20000L)) {
            try {
                transport = (CATransport)this.context.getTransportRegistry().get(address, priority);
                if (transport != null) {
                    this.context.getLogger().finer("Reusing existant connection to CA server: " + address);
                    if (transport.acquire(client)) {
                        CATransport cATransport = transport;
                        return cATransport;
                    }
                }
                this.context.getLogger().finer("Connecting to CA server: " + address);
                socket = this.tryConnect(address, 3);
                ((AbstractSelectableChannel)socket).configureBlocking(false);
                ((SocketChannel)socket).socket().setTcpNoDelay(true);
                ((SocketChannel)socket).socket().setKeepAlive(true);
                ReactorHandler handler = transport = new CATransport(this.context, client, responseHandler, (SocketChannel)socket, transportRevision, priority);
                if (this.context.getLeaderFollowersThreadPool() != null) {
                    handler = new LeaderFollowersHandler(this.context.getReactor(), handler, this.context.getLeaderFollowersThreadPool());
                }
                this.context.getReactor().register((SelectableChannel)socket, 1, handler);
                new VersionRequest(transport, priority).submit();
                new UserNameRequest(transport).submit();
                new HostNameRequest(transport).submit();
                this.context.getLogger().finer("Connected to CA server: " + address);
                CATransport cATransport = transport;
                return cATransport;
            }
            catch (Throwable th) {
                try {
                    if (socket != null) {
                        socket.close();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw new ConnectionException("Failed to connect to '" + address + "'.", address, th);
            }
            finally {
                this.namedLocker.releaseSynchronizationObject(address);
            }
        }
        throw new ConnectionException("Failed to obtain synchronization lock for '" + address + "', possible deadlock.", address, null);
    }

    private SocketChannel tryConnect(InetSocketAddress address, int tries) throws IOException {
        IOException lastException = null;
        for (int tryCount = 0; tryCount < tries; ++tryCount) {
            if (tryCount > 0) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.context.getLogger().finest("Openning socket to CA server " + address + ", attempt " + (tryCount + 1) + ".");
            try {
                return SocketChannel.open(address);
            }
            catch (IOException ioe) {
                lastException = ioe;
                continue;
            }
        }
        throw lastException;
    }
}

