/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.epics.caj.impl.handlers;

import com.cosylab.epics.caj.CAJContext;
import com.cosylab.epics.caj.impl.ExceptionHandler;
import com.cosylab.epics.caj.impl.Transport;
import com.cosylab.epics.caj.impl.handlers.AbstractCAJResponseHandler;
import com.cosylab.epics.caj.impl.handlers.ResponseRequestExceptionHandler;
import gov.aps.jca.CAStatus;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class ExceptionResponse
extends AbstractCAJResponseHandler
implements ExceptionHandler {
    private ExceptionHandler[] handlerTable;
    protected boolean debug = false;

    public ExceptionResponse(CAJContext context) {
        super(context, "Exception respone");
        this.intializeHandlerTable();
        this.debug = System.getProperties().containsKey("CAJ_DEBUG");
    }

    private void intializeHandlerTable() {
        ExceptionResponse defaultException = this;
        ResponseRequestExceptionHandler rreh = new ResponseRequestExceptionHandler(this.context);
        this.handlerTable = new ExceptionHandler[]{defaultException, rreh, defaultException, defaultException, defaultException, defaultException, defaultException, defaultException, defaultException, defaultException, defaultException, defaultException, defaultException, defaultException, defaultException, rreh, defaultException, defaultException, defaultException, rreh, defaultException, defaultException, defaultException, defaultException, defaultException, defaultException, defaultException, defaultException};
    }

    @Override
    protected void internalHandleResponse(InetSocketAddress responseFrom, Transport transport, ByteBuffer[] response) {
        int commandID;
        ByteBuffer originalHeaderBuffer = null;
        String errorMessage = null;
        ByteBuffer payloadBuffer = response.length == 1 ? response[0] : response[1];
        int payloadStart = payloadBuffer.position();
        if (this.payloadSize > 16) {
            int errorMessageStart;
            int originalHeaderPayloadSize = payloadBuffer.getShort(payloadStart + 2) & 0xFFFF;
            int originalHeaderSize = originalHeaderPayloadSize == 65535 ? 24 : 16;
            originalHeaderBuffer = payloadBuffer.slice();
            originalHeaderBuffer.limit(originalHeaderSize);
            int errorMessageEnd = errorMessageStart = payloadStart + originalHeaderSize;
            while (payloadBuffer.get(errorMessageEnd) != 0) {
                ++errorMessageEnd;
            }
            payloadBuffer.position(errorMessageStart);
            ByteBuffer errorMessageBuffer = payloadBuffer.slice();
            errorMessageBuffer.limit(errorMessageEnd - errorMessageStart);
            errorMessage = Charset.defaultCharset().decode(errorMessageBuffer).toString();
        }
        payloadBuffer.position(payloadStart + this.payloadSize);
        int n = commandID = originalHeaderBuffer != null ? (int)originalHeaderBuffer.getShort(0) : -1;
        if (commandID < 0 || commandID >= this.handlerTable.length) {
            this.context.getLogger().fine("Invalid (or unsupported) exception command: " + commandID + ".");
            this.handleException(this.parameter2, this.parameter1, errorMessage, originalHeaderBuffer);
            return;
        }
        if (this.debug) {
            this.context.getLogger().fine("Exception occured, code: " + CAStatus.forStatusCode(this.parameter2) + ", message: '" + errorMessage + "'.");
        }
        System.err.println("Exception occured, code: " + CAStatus.forStatusCode(this.parameter2) + ", message: '" + errorMessage + "'.");
        this.handlerTable[commandID].handleException(this.parameter2, this.parameter1, errorMessage, originalHeaderBuffer);
    }

    @Override
    public void handleException(int errorCode, int cid, String errorMessage, ByteBuffer originalHeaderBuffer) {
        this.context.getLogger().fine("Exception occured, code: " + CAStatus.forStatusCode(errorCode) + ", message: '" + errorMessage + "'.");
    }
}

