/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.epics.caj.impl.requests;

import com.cosylab.epics.caj.CAJChannel;
import com.cosylab.epics.caj.CAJContext;
import com.cosylab.epics.caj.impl.DBREncoder;
import com.cosylab.epics.caj.impl.Transport;
import com.cosylab.epics.caj.impl.requests.AbstractCARequest;
import java.nio.ByteBuffer;

public class WriteRequest
extends AbstractCARequest {
    protected CAJContext context;
    protected CAJChannel channel;

    public WriteRequest(CAJChannel channel, Transport transport, int sid, int cid, int dataType, int dataCount, Object value) {
        super(transport);
        boolean extendedHeader;
        this.channel = channel;
        this.context = (CAJContext)transport.getContext();
        int calculatedPayloadSize = DBREncoder.calculatePayloadSize((short)dataType, dataCount, value);
        int alignedPayloadSize = WriteRequest.calculateAlignedSize(8, calculatedPayloadSize);
        int alignedMessageSize = alignedPayloadSize + 16;
        boolean bl = extendedHeader = calculatedPayloadSize >= 65535 || dataCount >= 65535;
        if (extendedHeader) {
            if (transport.getMinorRevision() < 9) {
                throw new IllegalStateException("Message payload size " + alignedPayloadSize + " or element count " + dataCount + " out of bounds for CA revision " + transport.getMinorRevision() + ".");
            }
            alignedMessageSize += 8;
        }
        this.requestMessage = ByteBuffer.allocate(alignedMessageSize);
        this.requestMessage = WriteRequest.insertCAHeader(transport, this.requestMessage, (short)4, alignedPayloadSize, (short)dataType, dataCount, sid, cid);
        DBREncoder.insertPayload(this.requestMessage, (short)dataType, dataCount, value);
        this.requestMessage = WriteRequest.alignBuffer(8, this.requestMessage);
    }
}

