/*
 * Decompiled with CFR 0.152.
 */
package gov.aps.jca;

import gov.aps.jca.CAException;
import gov.aps.jca.Context;
import gov.aps.jca.cas.Server;
import gov.aps.jca.cas.ServerContext;
import gov.aps.jca.configuration.Configurable;
import gov.aps.jca.configuration.Configuration;
import gov.aps.jca.configuration.DefaultConfiguration;
import gov.aps.jca.dbr.DBRType;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;

public final class JCALibrary {
    private static final int VERSION = 2;
    private static final int REVISION = 3;
    private static final int MODIFICATION = 7;
    private static final String VERSION_STRING = "2.3.7";
    private static JCALibrary _instance = null;
    Properties _builtinProperties = new Properties();
    Properties _defaultProperties = new Properties(this._builtinProperties);
    Properties _properties = new Properties(this._defaultProperties);
    public static final String JNI_THREAD_SAFE = "gov.aps.jca.jni.ThreadSafeContext";
    public static final String JNI_SINGLE_THREADED = "gov.aps.jca.jni.SingleThreadedContext";
    public static final String CHANNEL_ACCESS_JAVA = "com.cosylab.epics.caj.CAJContext";
    public static final String CHANNEL_ACCESS_SERVER_JAVA = "com.cosylab.epics.caj.cas.CAJServerContext";

    public static synchronized JCALibrary getInstance() {
        if (_instance == null) {
            _instance = new JCALibrary();
        }
        return _instance;
    }

    protected JCALibrary() {
        DBRType.initialize();
        String fileSep = System.getProperty("file.separator");
        String path = null;
        try {
            InputStream is = JCALibrary.class.getResourceAsStream("JCALibrary.properties");
            if (is == null) {
                throw new RuntimeException("resource not found.");
            }
            this._builtinProperties.load(is);
        }
        catch (Throwable ressourceEx) {
            System.out.println("Unable to load default configuration located in 'JCALibrary.properties' resource: " + ressourceEx.getMessage());
        }
        try {
            path = System.getProperty("java.home") + fileSep + "lib" + fileSep + "JCALibrary.properties";
            this._defaultProperties.load(new FileInputStream(path));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            path = System.getProperty("gov.aps.jca.JCALibrary.properties", null);
            if (path == null) {
                path = System.getProperty("user.home") + fileSep + ".JCALibrary" + fileSep + "JCALibrary.properties";
            }
            this._properties.load(new FileInputStream(path));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public int getVersion() {
        return 2;
    }

    public int getRevision() {
        return 3;
    }

    public int getModification() {
        return 7;
    }

    public String getVersionString() {
        return VERSION_STRING;
    }

    public void printInfo() {
        this.printInfo(System.out);
    }

    public void printInfo(PrintStream out) {
        out.println(this.toString());
    }

    public String toString() {
        return JCALibrary.class.getName() + "[" + this.getVersionString() + "]";
    }

    public String getProperty(String name) {
        return System.getProperty(name, this._properties.getProperty(name));
    }

    public String getProperty(String name, String defaultValue) {
        return System.getProperty(name, this._properties.getProperty(name, defaultValue));
    }

    public float getPropertyAsFloat(String name, float defaultValue) {
        return Float.parseFloat(this.getProperty(name, String.valueOf(defaultValue)));
    }

    public int getPropertyAsInt(String name, int defaultValue) {
        return Integer.parseInt(this.getProperty(name, String.valueOf(defaultValue)));
    }

    public boolean getPropertyAsBoolean(String name, boolean defaultValue) {
        return Boolean.valueOf(this.getProperty(name, String.valueOf(defaultValue)));
    }

    public double getPropertyAsDouble(String name, double defaultValue) {
        return Double.parseDouble(this.getProperty(name, String.valueOf(defaultValue)));
    }

    public long getPropertyAsLong(String name, long defaultValue) {
        return Long.parseLong(this.getProperty(name, String.valueOf(defaultValue)));
    }

    public void listProperties() {
        this.listProperties(System.out);
    }

    public void listProperties(PrintStream out) {
        ArrayList<?> sys = Collections.list(System.getProperties().propertyNames());
        ArrayList<String> props = Collections.list(this._properties.propertyNames());
        props.removeAll(sys);
        props.addAll(sys);
        Collections.sort(props);
        for (String name : props) {
            out.println(name + "= " + this.getProperty(name));
        }
    }

    public Context createContext(String fqn) throws CAException {
        DefaultConfiguration conf = new DefaultConfiguration("CONTEXT");
        conf.setAttribute("class", fqn);
        return this.createContext(conf);
    }

    public Context createContext(Configuration configuration) throws CAException {
        try {
            String fqn = configuration.getAttribute("class");
            Class<?> contextClass = Class.forName(fqn);
            Context context = (Context)contextClass.newInstance();
            if (context instanceof Configurable) {
                ((Configurable)((Object)context)).configure(configuration);
            }
            return context;
        }
        catch (Throwable th) {
            throw new CAException("Unable to create context", th);
        }
    }

    public ServerContext createServerContext(String fqn, Server server) throws CAException {
        DefaultConfiguration conf = new DefaultConfiguration("SERVER_CONTEXT");
        conf.setAttribute("class", fqn);
        return this.createServerContext(conf, server);
    }

    public ServerContext createServerContext(Configuration configuration, Server server) throws CAException {
        try {
            String fqn = configuration.getAttribute("class");
            Class<?> contextClass = Class.forName(fqn);
            ServerContext context = (ServerContext)contextClass.newInstance();
            context.initialize(server);
            if (context instanceof Configurable) {
                ((Configurable)((Object)context)).configure(configuration);
            }
            return context;
        }
        catch (Throwable th) {
            throw new CAException("Unable to create server context", th);
        }
    }
}

