/*
 * Decompiled with CFR 0.152.
 */
package gov.aps.jca.configuration;

import gov.aps.jca.configuration.AbstractConfiguration;
import gov.aps.jca.configuration.Configuration;
import gov.aps.jca.configuration.ConfigurationException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;

public class DefaultConfiguration
extends AbstractConfiguration
implements Serializable {
    protected static final Configuration[] EMPTY_ARRAY = new Configuration[0];
    private final String m_name;
    private final String m_location;
    private final String m_namespace;
    private final String m_prefix;
    private HashMap m_attributes;
    private ArrayList m_children;
    private String m_value;
    private boolean m_readOnly;

    public DefaultConfiguration(String name) {
        this(name, "", "", "");
    }

    public DefaultConfiguration(String name, String location) {
        this(name, location, "", "");
    }

    public DefaultConfiguration(String name, String location, String ns, String prefix) {
        this.m_name = name;
        this.m_location = location;
        this.m_namespace = ns;
        this.m_prefix = prefix;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public String getNamespace() throws ConfigurationException {
        if (null != this.m_namespace) {
            return this.m_namespace;
        }
        throw new ConfigurationException("No namespace (not even default \"\") is associated with the configuration element \"" + this.getName() + "\" at " + this.getLocation());
    }

    @Override
    protected String getPrefix() throws ConfigurationException {
        if (null != this.m_prefix) {
            return this.m_prefix;
        }
        throw new ConfigurationException("No prefix (not even default \"\") is associated with the configuration element \"" + this.getName() + "\" at " + this.getLocation());
    }

    @Override
    public String getLocation() {
        return this.m_location;
    }

    @Override
    public String getValue(String defaultValue) {
        if (null != this.m_value) {
            return this.m_value;
        }
        return defaultValue;
    }

    @Override
    public String getValue() throws ConfigurationException {
        if (null != this.m_value) {
            return this.m_value;
        }
        throw new ConfigurationException("No value is associated with the configuration element \"" + this.getName() + "\" at " + this.getLocation());
    }

    @Override
    public String[] getAttributeNames() {
        if (null == this.m_attributes) {
            return new String[0];
        }
        return this.m_attributes.keySet().toArray(new String[0]);
    }

    @Override
    public Configuration[] getChildren() {
        if (null == this.m_children) {
            return new Configuration[0];
        }
        return this.m_children.toArray(new Configuration[0]);
    }

    @Override
    public String getAttribute(String name) throws ConfigurationException {
        String value;
        String string = value = null != this.m_attributes ? (String)this.m_attributes.get(name) : null;
        if (null != value) {
            return value;
        }
        throw new ConfigurationException("No attribute named \"" + name + "\" is associated with the configuration element \"" + this.getName() + "\" at " + this.getLocation());
    }

    @Override
    public Configuration getChild(String name, boolean createNew) {
        if (null != this.m_children) {
            int size = this.m_children.size();
            for (int i2 = 0; i2 < size; ++i2) {
                Configuration configuration = (Configuration)this.m_children.get(i2);
                if (!name.equals(configuration.getName())) continue;
                return configuration;
            }
        }
        if (createNew) {
            return new DefaultConfiguration(name, "-");
        }
        return null;
    }

    @Override
    public Configuration[] getChildren(String name) {
        if (null == this.m_children) {
            return new Configuration[0];
        }
        ArrayList<Configuration> children = new ArrayList<Configuration>();
        int size = this.m_children.size();
        for (int i2 = 0; i2 < size; ++i2) {
            Configuration configuration = (Configuration)this.m_children.get(i2);
            if (!name.equals(configuration.getName())) continue;
            children.add(configuration);
        }
        return children.toArray(new Configuration[0]);
    }

    public void appendValueData(String value) {
        this.checkWriteable();
        this.m_value = null == this.m_value ? value : this.m_value + value;
    }

    public void setValue(String value) {
        this.checkWriteable();
        this.m_value = value;
    }

    public void setAttribute(String name, String value) {
        this.checkWriteable();
        if (null == this.m_attributes) {
            this.m_attributes = new HashMap();
        }
        this.m_attributes.put(name, value);
    }

    public String addAttribute(String name, String value) {
        this.checkWriteable();
        if (null == this.m_attributes) {
            this.m_attributes = new HashMap();
        }
        return this.m_attributes.put(name, value);
    }

    public void addChild(Configuration configuration) {
        this.checkWriteable();
        if (null == this.m_children) {
            this.m_children = new ArrayList();
        }
        this.m_children.add(configuration);
    }

    public void removeChild(Configuration configuration) {
        this.checkWriteable();
        if (null == this.m_children) {
            return;
        }
        this.m_children.remove(configuration);
    }

    public int getChildCount() {
        if (null == this.m_children) {
            return 0;
        }
        return this.m_children.size();
    }

    public void makeReadOnly() {
        this.m_readOnly = true;
    }

    protected final void checkWriteable() throws IllegalStateException {
        if (this.m_readOnly) {
            throw new IllegalStateException("Configuration is read only and can not be modified");
        }
    }
}

