/*
 * Decompiled with CFR 0.152.
 */
package gov.aps.jca.dbr;

import gov.aps.jca.CAStatus;
import gov.aps.jca.CAStatusException;
import gov.aps.jca.dbr.DBR;
import gov.aps.jca.dbr.DBRFactory;
import gov.aps.jca.dbr.DBRType;
import gov.aps.jca.dbr.DBR_Byte;
import gov.aps.jca.dbr.DBR_Double;
import gov.aps.jca.dbr.DBR_Enum;
import gov.aps.jca.dbr.DBR_Float;
import gov.aps.jca.dbr.DBR_Int;
import gov.aps.jca.dbr.DBR_String;
import gov.aps.jca.dbr.SHORT;

public class DBR_PutAckT
extends DBR
implements SHORT {
    public static final DBRType TYPE = new DBRType("DBR_PUT_ACKT", 35, DBR_PutAckT.class);

    public DBR_PutAckT() {
        this(1);
    }

    public DBR_PutAckT(int count) {
        this(new short[count]);
    }

    public DBR_PutAckT(short[] value) {
        super(value);
    }

    @Override
    public DBRType getType() {
        return TYPE;
    }

    @Override
    public short[] getShortValue() {
        return (short[])this.getValue();
    }

    @Override
    public DBR convert(DBRType convertType) throws CAStatusException {
        if (convertType.isSHORT()) {
            return this;
        }
        short[] fromValue = this.getShortValue();
        DBR dbr = DBRFactory.create(convertType, this._count);
        if (convertType.isSTRING()) {
            String[] toValue = ((DBR_String)dbr).getStringValue();
            for (int i2 = 0; i2 < this._count; ++i2) {
                toValue[i2] = String.valueOf(fromValue[i2]);
            }
        } else if (convertType.isFLOAT()) {
            float[] toValue = ((DBR_Float)dbr).getFloatValue();
            for (int i3 = 0; i3 < this._count; ++i3) {
                toValue[i3] = fromValue[i3];
            }
        } else if (convertType.isENUM()) {
            short[] toValue = ((DBR_Enum)dbr).getEnumValue();
            for (int i4 = 0; i4 < this._count; ++i4) {
                toValue[i4] = fromValue[i4];
            }
        } else if (convertType.isBYTE()) {
            byte[] toValue = ((DBR_Byte)dbr).getByteValue();
            for (int i5 = 0; i5 < this._count; ++i5) {
                toValue[i5] = (byte)fromValue[i5];
            }
        } else if (convertType.isINT()) {
            int[] toValue = ((DBR_Int)dbr).getIntValue();
            for (int i6 = 0; i6 < this._count; ++i6) {
                toValue[i6] = fromValue[i6];
            }
        } else if (convertType.isDOUBLE()) {
            double[] toValue = ((DBR_Double)dbr).getDoubleValue();
            for (int i7 = 0; i7 < this._count; ++i7) {
                toValue[i7] = fromValue[i7];
            }
        } else {
            throw new CAStatusException(CAStatus.NOCONVERT, "converstion not supported");
        }
        return dbr;
    }
}

