/*
 * Decompiled with CFR 0.152.
 */
package gov.aps.jca.dbr;

import gov.aps.jca.CAStatusException;
import gov.aps.jca.dbr.DBR;
import gov.aps.jca.dbr.DBRType;
import gov.aps.jca.dbr.DBR_Short;
import gov.aps.jca.dbr.STS;
import gov.aps.jca.dbr.Severity;
import gov.aps.jca.dbr.Status;
import java.io.PrintStream;

public class DBR_STS_Short
extends DBR_Short
implements STS {
    public static final DBRType TYPE = new DBRType("DBR_STS_SHORT", 8, DBR_STS_Short.class);
    protected Status _status;
    protected Severity _severity;

    public DBR_STS_Short() {
        this(1);
    }

    public DBR_STS_Short(int count) {
        this(new short[count]);
    }

    public DBR_STS_Short(short[] value) {
        super(value);
    }

    @Override
    public DBRType getType() {
        return TYPE;
    }

    @Override
    public Status getStatus() {
        return this._status;
    }

    @Override
    public void setStatus(int status) {
        this.setStatus(Status.forValue(status));
    }

    @Override
    public void setStatus(Status status) {
        if (status == null) {
            throw new IllegalArgumentException("Illegal status: null");
        }
        this._status = status;
    }

    @Override
    public Severity getSeverity() {
        return this._severity;
    }

    @Override
    public void setSeverity(int severity) {
        this.setSeverity(Severity.forValue(severity));
    }

    @Override
    public void setSeverity(Severity severity) {
        if (severity == null) {
            throw new IllegalArgumentException("Illegal severity: null");
        }
        this._severity = severity;
    }

    @Override
    public void printInfo(PrintStream out) {
        super.printInfo(out);
        out.println("STATUS   : " + this.getStatus().getName());
        out.println("SEVERITY : " + this.getSeverity().getName());
    }

    @Override
    public DBR convert(DBRType convertType) throws CAStatusException {
        DBR dbr = super.convert(convertType);
        if (dbr.isSTS()) {
            STS sts = (STS)((Object)dbr);
            sts.setSeverity(this._severity);
            sts.setStatus(this._status);
        }
        return dbr;
    }
}

