/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.epics.ca.AccessRights;
import org.epics.ca.Channel;
import org.epics.ca.ConnectionState;
import org.epics.ca.Constants;
import org.epics.ca.Context;
import org.epics.ca.EpicsChannelAccessTestServer;
import org.epics.ca.Listener;
import org.epics.ca.Monitor;
import org.epics.ca.NotificationConsumer;
import org.epics.ca.Status;
import org.epics.ca.ThreadWatcher;
import org.epics.ca.data.Alarm;
import org.epics.ca.data.AlarmSeverity;
import org.epics.ca.data.AlarmStatus;
import org.epics.ca.data.Control;
import org.epics.ca.data.Data;
import org.epics.ca.data.Graphic;
import org.epics.ca.data.GraphicEnum;
import org.epics.ca.data.GraphicEnumArray;
import org.epics.ca.data.Metadata;
import org.epics.ca.data.Timestamped;
import org.epics.ca.impl.monitor.MonitorNotificationServiceFactoryCreator;
import org.epics.ca.impl.repeater.NetworkUtilities;
import org.epics.ca.util.logging.LibraryLogManager;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;

class ChannelTest {
    private static final Logger logger = LibraryLogManager.getLogger(ChannelTest.class);
    private ThreadWatcher threadWatcher;
    private static final double DELTA = 1.0E-10;
    private static final int TIMEOUT_MILLISEC = 10000;
    private static final int TEST_SLEEP_INTERVAL_MILLISEC = 500;

    ChannelTest() {
    }

    @BeforeAll
    static void beforeAll() {
        MatcherAssert.assertThat(NetworkUtilities.verifyTargetPlatformNetworkStackIsChannelAccessCompatible(), Is.is(true));
        if (NetworkUtilities.isVpnActive()) {
            Assertions.fail("This test is not supported when a VPN connection is active on the local network interface.");
        }
    }

    @BeforeEach
    void beforeEach() {
        this.threadWatcher = ThreadWatcher.start();
        EpicsChannelAccessTestServer.start();
    }

    @AfterEach
    void afterEach() {
        EpicsChannelAccessTestServer.shutdown();
        this.threadWatcher.verify();
    }

    @Test
    void testConnect() throws Throwable {
        try (Context context = new Context();){
            try (Channel<Double> channel = context.createChannel("no_such_channel_test", Double.class);){
                MatcherAssert.assertThat(channel, IsNull.notNullValue());
                MatcherAssert.assertThat(channel.getName(), Is.is("no_such_channel_test"));
                MatcherAssert.assertThat(channel.getConnectionState(), Is.is(ConnectionState.NEVER_CONNECTED));
                try {
                    channel.connectAsync().get(10000L, TimeUnit.MILLISECONDS);
                    Assertions.fail("connected on non-existent channel, timeout expected");
                }
                catch (TimeoutException timeoutException) {
                    // empty catch block
                }
                MatcherAssert.assertThat(channel.getConnectionState(), Is.is(ConnectionState.NEVER_CONNECTED));
            }
            channel = context.createChannel("adc01", Double.class);
            var4_6 = null;
            try {
                MatcherAssert.assertThat(channel, IsNull.notNullValue());
                MatcherAssert.assertThat(channel.getName(), Is.is("adc01"));
                MatcherAssert.assertThat(channel.getConnectionState(), Is.is(ConnectionState.NEVER_CONNECTED));
                channel.connectAsync().get(10000L, TimeUnit.MILLISECONDS);
                MatcherAssert.assertThat(channel.getConnectionState(), Is.is(ConnectionState.CONNECTED));
                MatcherAssert.assertThat(channel.getName(), Is.is("adc01"));
            }
            catch (Throwable throwable) {
                var4_6 = throwable;
                throw throwable;
            }
            finally {
                if (channel != null) {
                    if (var4_6 != null) {
                        try {
                            channel.close();
                        }
                        catch (Throwable throwable) {
                            var4_6.addSuppressed(throwable);
                        }
                    } else {
                        channel.close();
                    }
                }
            }
            channel = context.createChannel("adc01", Double.class);
            var4_6 = null;
            try {
                MatcherAssert.assertThat(channel, IsNull.notNullValue());
                MatcherAssert.assertThat(channel.getConnectionState(), Is.is(ConnectionState.NEVER_CONNECTED));
                channel.connectAsync().get(10000L, TimeUnit.MILLISECONDS);
                MatcherAssert.assertThat(channel.getConnectionState(), Is.is(ConnectionState.CONNECTED));
            }
            catch (Throwable throwable) {
                var4_6 = throwable;
                throw throwable;
            }
            finally {
                if (channel != null) {
                    if (var4_6 != null) {
                        try {
                            channel.close();
                        }
                        catch (Throwable throwable) {
                            var4_6.addSuppressed(throwable);
                        }
                    } else {
                        channel.close();
                    }
                }
            }
        }
    }

    @Test
    void testConnectionListener() throws Throwable {
        try (Context context = new Context();
             Channel<Double> channel = context.createChannel("adc01", Double.class);){
            MatcherAssert.assertThat(channel, IsNull.notNullValue());
            MatcherAssert.assertThat(channel.getConnectionState(), Is.is(ConnectionState.NEVER_CONNECTED));
            AtomicInteger connectedCount = new AtomicInteger();
            AtomicInteger disconnectedCount = new AtomicInteger();
            AtomicInteger unregisteredEventCount = new AtomicInteger();
            Listener cl = channel.addConnectionListener((c, connected) -> {
                if (c == channel) {
                    if (connected.booleanValue()) {
                        connectedCount.incrementAndGet();
                    } else {
                        disconnectedCount.incrementAndGet();
                    }
                }
            });
            MatcherAssert.assertThat(cl, IsNull.notNullValue());
            Listener cl2 = channel.addConnectionListener((c, connected) -> unregisteredEventCount.incrementAndGet());
            MatcherAssert.assertThat(cl2, IsNull.notNullValue());
            MatcherAssert.assertThat(unregisteredEventCount.get(), Is.is(0));
            cl2.close();
            channel.connectAsync().get(10000L, TimeUnit.MILLISECONDS);
            MatcherAssert.assertThat(channel.getConnectionState(), Is.is(ConnectionState.CONNECTED));
            Thread.sleep(500L);
            MatcherAssert.assertThat(connectedCount.get(), Is.is(1));
            MatcherAssert.assertThat(disconnectedCount.get(), Is.is(0));
            MatcherAssert.assertThat(unregisteredEventCount.get(), Is.is(0));
            channel.close();
            Thread.sleep(500L);
            MatcherAssert.assertThat(connectedCount.get(), Is.is(1));
            MatcherAssert.assertThat(disconnectedCount.get(), Is.is(0));
            MatcherAssert.assertThat(unregisteredEventCount.get(), Is.is(0));
        }
    }

    @Test
    void testAccessRightsListener() throws Throwable {
        try (Context context = new Context();
             Channel<Double> channel = context.createChannel("adc01", Double.class);){
            MatcherAssert.assertThat(channel, IsNull.notNullValue());
            AtomicInteger aclCount = new AtomicInteger();
            AtomicInteger unregisteredEventCount = new AtomicInteger();
            Listener rl = channel.addAccessRightListener((c, ar) -> {
                if (c == channel && ar == AccessRights.READ_WRITE) {
                    aclCount.incrementAndGet();
                }
            });
            MatcherAssert.assertThat(rl, IsNull.notNullValue());
            Listener cl2 = channel.addAccessRightListener((c, ar) -> unregisteredEventCount.incrementAndGet());
            MatcherAssert.assertThat(cl2, IsNull.notNullValue());
            MatcherAssert.assertThat(unregisteredEventCount.get(), Is.is(0));
            cl2.close();
            channel.connectAsync().get(10000L, TimeUnit.MILLISECONDS);
            MatcherAssert.assertThat(channel.getAccessRights(), Is.is(AccessRights.READ_WRITE));
            Thread.sleep(500L);
            MatcherAssert.assertThat(aclCount.get(), Is.is(1));
            MatcherAssert.assertThat(unregisteredEventCount.get(), Is.is(0));
            channel.close();
            Thread.sleep(500L);
            MatcherAssert.assertThat(aclCount.get(), Is.is(1));
            MatcherAssert.assertThat(unregisteredEventCount.get(), Is.is(0));
        }
    }

    @Test
    void testProperties() throws Throwable {
        try (Context context = new Context();
             Channel<Double> channel = context.createChannel("adc01", Double.class);){
            channel.connectAsync().get(10000L, TimeUnit.MILLISECONDS);
            Map<String, Object> props = channel.getProperties();
            Object nativeTypeCode = props.get(Constants.ChannelProperties.nativeTypeCode.name());
            MatcherAssert.assertThat(nativeTypeCode, IsNull.notNullValue());
            MatcherAssert.assertThat(nativeTypeCode, Is.is((short)6));
            Object nativeElementCount = props.get(Constants.ChannelProperties.nativeElementCount.name());
            MatcherAssert.assertThat(nativeElementCount, IsNull.notNullValue());
            MatcherAssert.assertThat(nativeElementCount, Is.is(2));
            Object nativeType = props.get(Constants.ChannelProperties.nativeType.name());
            MatcherAssert.assertThat(nativeType, IsNull.notNullValue());
            MatcherAssert.assertThat(nativeType, Is.is(Double.class));
        }
    }

    @MethodSource(value={"getArgumentsForMonitorNotificationServiceImplementations"})
    @ParameterizedTest
    void testMonitorDisconnectionBehaviour(String serviceImpl) throws InterruptedException {
        Properties contextProperties = new Properties();
        contextProperties.setProperty("CA_MONITOR_NOTIFIER_IMPL", serviceImpl);
        try (Context context = new Context(contextProperties);
             Channel<Integer> channel = context.createChannel("adc01", Integer.class);){
            channel.addConnectionListener((c, h) -> logger.info(String.format("Channel '%s', new connection state is: '%s' ", new Object[]{c.getName(), c.getConnectionState()})));
            Assertions.assertDoesNotThrow(() -> {
                logger.info("connecting async...");
                channel.connectAsync().get(10000L, TimeUnit.MILLISECONDS);
                logger.info("connected.");
            });
            int testValue = 99;
            channel.put(99);
            Consumer consumer = Mockito.mock(GenericIntegerConsumer.class);
            channel.addValueMonitor(consumer);
            Thread.sleep(500L);
            Mockito.verify(consumer, Mockito.times(1)).accept(99);
            EpicsChannelAccessTestServer.shutdown();
            Thread.sleep(500L);
            Mockito.verifyNoMoreInteractions(consumer);
            EpicsChannelAccessTestServer.start();
        }
    }

    @Test
    void testMonitors() throws Throwable {
        try (Context context = new Context();
             Channel<Integer> channel = context.createChannel("100msCounter", Integer.class);){
            channel.connect();
            try {
                channel.addValueMonitor(null);
                Assertions.fail("null handler accepted");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            try {
                channel.addValueMonitor(value -> {}, 0);
                Assertions.fail("empty mask accepted");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            try (Monitor<Integer> monitor = channel.addValueMonitor(value -> {}, 1);){
                Assertions.assertNotNull(monitor);
            }
            AtomicInteger monitorNotificationCount = new AtomicInteger();
            Monitor<Integer> monitor = channel.addValueMonitor(value -> monitorNotificationCount.incrementAndGet(), 1);
            Assertions.assertNotNull(monitor);
            Thread.sleep(5000L);
            monitor.close();
            int monitorNotifications = monitorNotificationCount.get();
            MatcherAssert.assertThat(monitorNotificationCount.get(), Matchers.greaterThanOrEqualTo(45));
            Thread.sleep(1000L);
            MatcherAssert.assertThat(monitorNotificationCount.get(), Is.is(monitorNotifications));
        }
    }

    @Test
    void testLargeArray() throws Throwable {
        try (Context context = new Context();
             Channel<int[]> channel = context.createChannel("large", int[].class);){
            Assertions.assertDoesNotThrow(() -> channel.connectAsync().get(10000L, TimeUnit.MILLISECONDS));
            int[] value = channel.getAsync().get(10000L, TimeUnit.MILLISECONDS);
            MatcherAssert.assertThat(value, IsNull.notNullValue());
            int LARGE_PRIME = 15485863;
            int i2 = 0;
            while (i2 < value.length) {
                MatcherAssert.assertThat(value[i2], Is.is(i2));
                int n = i2++;
                value[n] = value[n] + 15485863;
            }
            Status putStatus = channel.putAsync(value).get(10000L, TimeUnit.MILLISECONDS);
            MatcherAssert.assertThat(putStatus, Is.is(Status.NORMAL));
            value = channel.getAsync().get(10000L, TimeUnit.MILLISECONDS);
            MatcherAssert.assertThat(channel, IsNull.notNullValue());
            for (int i3 = 0; i3 < value.length; ++i3) {
                MatcherAssert.assertThat(value[i3], Is.is(i3 + 15485863));
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"getArgumentsForMonitorNotificationServiceImplementations"})
    void testContextCloseAlsoClosesMonitorNotifier(String serviceImpl) {
        MatcherAssert.assertThat(MonitorNotificationServiceFactoryCreator.getServiceCount(), Is.is(0L));
        Properties contextProperties = new Properties();
        contextProperties.setProperty("CA_MONITOR_NOTIFIER_IMPL", serviceImpl);
        Context context = new Context(contextProperties);
        Channel<Integer> channel = context.createChannel("adc01", Integer.class);
        Assertions.assertDoesNotThrow(() -> channel.connectAsync().get(10000L, TimeUnit.MILLISECONDS));
        MatcherAssert.assertThat(MonitorNotificationServiceFactoryCreator.getServiceCount(), Is.is(0L));
        NotificationConsumer notificationConsumer = NotificationConsumer.getNormalConsumer();
        NotificationConsumer.clearCurrentTotalNotificationCount();
        NotificationConsumer.setExpectedTotalNotificationCount(2);
        channel.addValueMonitor(notificationConsumer);
        channel.addValueMonitor(notificationConsumer);
        MatcherAssert.assertThat(MonitorNotificationServiceFactoryCreator.getServiceCount(), Is.is(2L));
        NotificationConsumer.awaitExpectedTotalNotificationCount();
        context.close();
        MatcherAssert.assertThat(MonitorNotificationServiceFactoryCreator.getServiceCount(), Is.is(0L));
    }

    @ParameterizedTest
    @MethodSource(value={"getArgumentsForMonitorNotificationServiceImplementations"})
    void testChannelCloseDoesNotCloseMonitorNotifier(String serviceImpl) {
        MatcherAssert.assertThat(MonitorNotificationServiceFactoryCreator.getServiceCount(), Is.is(0L));
        Properties contextProperties = new Properties();
        contextProperties.setProperty("CA_MONITOR_NOTIFIER_IMPL", serviceImpl);
        try (Context context = new Context(contextProperties);){
            Channel<Integer> channel = context.createChannel("adc01", Integer.class);
            Assertions.assertDoesNotThrow(() -> channel.connectAsync().get(10000L, TimeUnit.MILLISECONDS));
            MatcherAssert.assertThat(MonitorNotificationServiceFactoryCreator.getServiceCount(), Is.is(0L));
            NotificationConsumer notificationConsumer = NotificationConsumer.getNormalConsumer();
            NotificationConsumer.clearCurrentTotalNotificationCount();
            NotificationConsumer.setExpectedTotalNotificationCount(2);
            channel.addValueMonitor(notificationConsumer);
            channel.addValueMonitor(notificationConsumer);
            MatcherAssert.assertThat(MonitorNotificationServiceFactoryCreator.getServiceCount(), Is.is(2L));
            NotificationConsumer.awaitExpectedTotalNotificationCount();
            channel.close();
            MatcherAssert.assertThat(MonitorNotificationServiceFactoryCreator.getServiceCount(), Is.is(2L));
        }
        MatcherAssert.assertThat(MonitorNotificationServiceFactoryCreator.getServiceCount(), Is.is(0L));
    }

    @ParameterizedTest
    @MethodSource(value={"getArgumentsForMonitorNotificationServiceImplementations"})
    void testMonitorCloseDoesNotAlsoCloseMonitorNotifier(String serviceImpl) {
        MatcherAssert.assertThat(MonitorNotificationServiceFactoryCreator.getServiceCount(), Is.is(0L));
        Properties contextProperties = new Properties();
        contextProperties.setProperty("CA_MONITOR_NOTIFIER_IMPL", serviceImpl);
        try (Context context = new Context(contextProperties);){
            MatcherAssert.assertThat(MonitorNotificationServiceFactoryCreator.getServiceCount(), Is.is(0L));
            Channel<Integer> channel = context.createChannel("adc01", Integer.class);
            Assertions.assertDoesNotThrow(() -> channel.connectAsync().get(10000L, TimeUnit.MILLISECONDS));
            MatcherAssert.assertThat(MonitorNotificationServiceFactoryCreator.getServiceCount(), Is.is(0L));
            NotificationConsumer notificationConsumer = NotificationConsumer.getNormalConsumer();
            NotificationConsumer.clearCurrentTotalNotificationCount();
            NotificationConsumer.setExpectedTotalNotificationCount(2);
            Monitor<Integer> monitor1 = channel.addValueMonitor(notificationConsumer);
            Monitor<Integer> monitor2 = channel.addValueMonitor(notificationConsumer);
            MatcherAssert.assertThat(MonitorNotificationServiceFactoryCreator.getServiceCount(), Is.is(2L));
            NotificationConsumer.awaitExpectedTotalNotificationCount();
            monitor1.close();
            MatcherAssert.assertThat(MonitorNotificationServiceFactoryCreator.getServiceCount(), Is.is(2L));
            monitor2.close();
            MatcherAssert.assertThat(MonitorNotificationServiceFactoryCreator.getServiceCount(), Is.is(2L));
        }
        MatcherAssert.assertThat(MonitorNotificationServiceFactoryCreator.getServiceCount(), Is.is(0L));
    }

    @MethodSource(value={"getArgumentsForTestPutAndGetValue"})
    @ParameterizedTest
    <T> void testPutAndGetValue(String channelName, Class<T> type, T expectedValue, boolean async) throws Throwable {
        logger.info("testPutAndGetValue invoked with args: " + String.format("'%s', '%s', '%s'.", channelName, type.getSimpleName(), async));
        try (Context context = new Context();
             Channel channel = context.createChannel(channelName, type);){
            T value;
            Assertions.assertDoesNotThrow(() -> channel.connectAsync().get(10000L, TimeUnit.MILLISECONDS));
            if (async) {
                Status status = channel.putAsync(expectedValue).get(10000L, TimeUnit.MILLISECONDS);
                Assertions.assertTrue(status.isSuccessful());
            } else {
                channel.putNoWait(expectedValue);
            }
            if (async) {
                value = channel.getAsync().get(10000L, TimeUnit.MILLISECONDS);
                Assertions.assertNotNull(value);
            } else {
                value = channel.get();
            }
            MatcherAssert.assertThat(value, Is.is(expectedValue));
        }
    }

    @MethodSource(value={"getArgumentsForTestPutAndGetMetadata"})
    @ParameterizedTest
    <T, ST, MT extends Metadata<T>> void testPutAndGetMetadata(String channelName, Class<T> type, Class<ST> scalarType, T expectedValue, Class<? extends Metadata<T>> metaType, Alarm<?> expectedAlarm, Control<?, Double> expectedMeta, boolean async) throws Throwable {
        logger.info("testPutAndGetMetadata invoked with args: " + String.format("'%s', '%s', '%s', '%s', '%s'.", channelName, type.getSimpleName(), scalarType.getSimpleName(), metaType.getSimpleName(), async));
        if ((metaType.equals(Control.class) || metaType.equals(Graphic.class)) && (type.equals(String.class) || type.equals(String[].class))) {
            logger.info("Skipping test because EPICS does not support this combination !");
            return;
        }
        logger.info("Creating context...");
        try (Context context = new Context();){
            logger.info("Done. Creating channel...");
            try (Channel channel = context.createChannel(channelName, type);){
                Alarm v;
                Object value;
                logger.info("Done. connecting channel...");
                Assertions.assertDoesNotThrow(() -> channel.connectAsync().get(10000L, TimeUnit.MILLISECONDS));
                if (async) {
                    Status status = channel.putAsync(expectedValue).get(10000L, TimeUnit.MILLISECONDS);
                    Assertions.assertTrue(status.isSuccessful());
                } else {
                    channel.putNoWait(expectedValue);
                }
                if (async) {
                    value = (Metadata)channel.getAsync(metaType).get(10000L, TimeUnit.MILLISECONDS);
                    Assertions.assertNotNull(value);
                } else {
                    value = channel.get(metaType);
                }
                if (Alarm.class.isAssignableFrom(metaType)) {
                    v = (Alarm)value;
                    MatcherAssert.assertThat(v.getAlarmStatus(), Is.is(expectedAlarm.getAlarmStatus()));
                    MatcherAssert.assertThat(v.getAlarmSeverity(), Is.is(expectedAlarm.getAlarmSeverity()));
                }
                if (Timestamped.class.isAssignableFrom(metaType)) {
                    v = (Timestamped)value;
                    long dt = System.currentTimeMillis() - ((Timestamped)v).getMillis();
                    Assertions.assertTrue(dt < 10000L);
                }
                if (Graphic.class.isAssignableFrom(metaType)) {
                    v = (Graphic)value;
                    MatcherAssert.assertThat(((Graphic)v).getUnits(), Is.is(expectedMeta.getUnits()));
                    if (scalarType.equals(Double.class) || scalarType.equals(Float.class)) {
                        Assertions.assertEquals(expectedMeta.getPrecision(), ((Graphic)v).getPrecision());
                    }
                    MatcherAssert.assertThat(((Number)((Graphic)v).getLowerAlarm()).doubleValue(), Matchers.closeTo((Double)expectedMeta.getLowerAlarm(), 1.0E-10));
                    MatcherAssert.assertThat(((Number)((Graphic)v).getLowerDisplay()).doubleValue(), Matchers.closeTo((Double)expectedMeta.getLowerDisplay(), 1.0E-10));
                    MatcherAssert.assertThat(((Number)((Graphic)v).getLowerWarning()).doubleValue(), Matchers.closeTo((Double)expectedMeta.getLowerWarning(), 1.0E-10));
                    MatcherAssert.assertThat(((Number)((Graphic)v).getUpperAlarm()).doubleValue(), Matchers.closeTo((Double)expectedMeta.getUpperAlarm(), 1.0E-10));
                    MatcherAssert.assertThat(((Number)((Graphic)v).getUpperDisplay()).doubleValue(), Matchers.closeTo((Double)expectedMeta.getUpperDisplay(), 1.0E-10));
                    MatcherAssert.assertThat(((Number)((Graphic)v).getUpperWarning()).doubleValue(), Matchers.closeTo((Double)expectedMeta.getUpperWarning(), 1.0E-10));
                }
                if (Control.class.isAssignableFrom(metaType)) {
                    v = (Control)value;
                    MatcherAssert.assertThat(((Number)((Control)v).getLowerControl()).doubleValue(), Matchers.closeTo(expectedMeta.getLowerControl(), 1.0E-10));
                    MatcherAssert.assertThat(((Number)((Control)v).getUpperControl()).doubleValue(), Matchers.closeTo(expectedMeta.getUpperControl(), 1.0E-10));
                }
                MatcherAssert.assertThat(((Data)value).getValue(), Is.is(expectedValue));
            }
        }
    }

    @MethodSource(value={"getArgumentsForTestGraphicEnum"})
    @ParameterizedTest
    <T> void testGraphicEnum(String channelName, Class<T> clazz, T expectedValue, Alarm<?> expectedAlarm, String[] expectedLabels, boolean async) throws Throwable {
        try (Context context = new Context();
             Channel channel = context.createChannel(channelName, clazz);){
            Alarm value;
            Class gec;
            Assertions.assertDoesNotThrow(() -> channel.connectAsync().get(10000L, TimeUnit.MILLISECONDS));
            if (async) {
                Status status = channel.putAsync(expectedValue).get(10000L, TimeUnit.MILLISECONDS);
                Assertions.assertTrue(status.isSuccessful());
            } else {
                channel.putNoWait(expectedValue);
            }
            Class clazz2 = gec = clazz.isArray() ? GraphicEnumArray.class : GraphicEnum.class;
            if (async) {
                value = (Alarm)channel.getAsync(gec).get(10000L, TimeUnit.MILLISECONDS);
                Assertions.assertNotNull(value);
            } else {
                value = (Alarm)channel.get(gec);
            }
            MatcherAssert.assertThat(value.getValue(), Is.is(expectedValue));
            MatcherAssert.assertThat(value.getAlarmStatus(), Is.is(expectedAlarm.getAlarmStatus()));
            MatcherAssert.assertThat(value.getAlarmSeverity(), Is.is(expectedAlarm.getAlarmSeverity()));
            String[] labels = clazz.isArray() ? ((GraphicEnumArray)value).getLabels() : ((GraphicEnum)value).getLabels();
            MatcherAssert.assertThat(labels, Matchers.arrayContaining(expectedLabels));
        }
    }

    private static Stream<Arguments> getArgumentsForMonitorNotificationServiceImplementations() {
        List<String> serviceImpls = MonitorNotificationServiceFactoryCreator.getAllServiceImplementations();
        return serviceImpls.stream().map(xva$0 -> Arguments.of(xva$0));
    }

    private static Stream<Arguments> getArgumentsForTestPutAndGetValue() {
        List<Boolean> asyncOptions = Arrays.asList(false, true);
        return asyncOptions.stream().flatMap(async -> Stream.of(Arguments.of("adc01", String.class, "12.346", async), Arguments.of("adc01", Short.class, (short)123, async), Arguments.of("adc01", Float.class, Float.valueOf(-123.4f), async), Arguments.of("adc01", Byte.class, (byte)100, async), Arguments.of("adc01", Integer.class, 123456, async), Arguments.of("adc01", Double.class, 12.3456, async), Arguments.of("adc01", String[].class, new String[]{"12.356", "3.112"}, async), Arguments.of("adc01", short[].class, new short[]{123, -321}, async), Arguments.of("adc01", float[].class, new float[]{-123.4f, 321.98f}, async), Arguments.of("adc01", byte[].class, new byte[]{120, -120}, async), Arguments.of("adc01", int[].class, new int[]{123456, 654321}, async), Arguments.of("adc01", double[].class, new double[]{12.82, 3.112}, async)));
    }

    private static Stream<Arguments> getArgumentsForTestPutAndGetMetadata() {
        Alarm alarm = new Alarm();
        alarm.setAlarmStatus(AlarmStatus.UDF_ALARM);
        alarm.setAlarmSeverity(AlarmSeverity.INVALID_ALARM);
        Control meta = new Control();
        meta.setUpperDisplay(10.0);
        meta.setLowerDisplay(-10.0);
        meta.setUpperAlarm(9.0);
        meta.setLowerAlarm(-9.0);
        meta.setUpperControl(8.0);
        meta.setLowerControl(-8.0);
        meta.setUpperWarning(7.0);
        meta.setLowerWarning(-7.0);
        meta.setUnits("units");
        meta.setPrecision(3);
        List<Class> metaTypeOptions = Arrays.asList(Alarm.class, Timestamped.class, Control.class, Graphic.class);
        return metaTypeOptions.stream().flatMap(metaType -> Stream.of(Arguments.of("adc01", String.class, String.class, "12.346", metaType, alarm, meta, false), Arguments.of("adc01", Short.class, Short.class, (short)123, metaType, alarm, meta, false), Arguments.of("adc01", Float.class, Float.class, Float.valueOf(-123.4f), metaType, alarm, meta, false), Arguments.of("adc01", Byte.class, Byte.class, (byte)100, metaType, alarm, meta, false), Arguments.of("adc01", Integer.class, Integer.class, 123456, metaType, alarm, meta, false), Arguments.of("adc01", Double.class, Double.class, 12.3456, metaType, alarm, meta, false), Arguments.of("adc01", String.class, String.class, "12.346", metaType, alarm, meta, true), Arguments.of("adc01", Short.class, Short.class, (short)123, metaType, alarm, meta, true), Arguments.of("adc01", Float.class, Float.class, Float.valueOf(-123.4f), metaType, alarm, meta, true), Arguments.of("adc01", Byte.class, Byte.class, (byte)100, metaType, alarm, meta, true), Arguments.of("adc01", Integer.class, Integer.class, 123456, metaType, alarm, meta, true), Arguments.of("adc01", Double.class, Double.class, 12.3456, metaType, alarm, meta, true), Arguments.of("adc01", String[].class, String.class, new String[]{"12.356", "3.112"}, metaType, alarm, meta, false), Arguments.of("adc01", short[].class, Short.class, new short[]{123, -321}, metaType, alarm, meta, false), Arguments.of("adc01", float[].class, Float.class, new float[]{-123.4f, 321.98f}, metaType, alarm, meta, false), Arguments.of("adc01", byte[].class, Byte.class, new byte[]{120, -120}, metaType, alarm, meta, false), Arguments.of("adc01", int[].class, Integer.class, new int[]{123456, 654321}, metaType, alarm, meta, false), Arguments.of("adc01", double[].class, Double.class, new double[]{12.82, 3.112}, metaType, alarm, meta, false), Arguments.of("adc01", String[].class, String.class, new String[]{"12.356", "3.112"}, metaType, alarm, meta, true), Arguments.of("adc01", short[].class, Short.class, new short[]{123, -321}, metaType, alarm, meta, true), Arguments.of("adc01", float[].class, Float.class, new float[]{-123.4f, 321.98f}, metaType, alarm, meta, true), Arguments.of("adc01", byte[].class, Byte.class, new byte[]{120, -120}, metaType, alarm, meta, true), Arguments.of("adc01", int[].class, Integer.class, new int[]{123456, 654321}, metaType, alarm, meta, true), Arguments.of("adc01", double[].class, Double.class, new double[]{12.82, 3.112}, metaType, alarm, meta, true)));
    }

    private static Stream<Arguments> getArgumentsForTestGraphicEnum() {
        Alarm alarm = new Alarm();
        alarm.setAlarmStatus(AlarmStatus.UDF_ALARM);
        alarm.setAlarmSeverity(AlarmSeverity.INVALID_ALARM);
        String[] labels = new String[]{"zero", "one", "two", "three", "four", "five", "six", "seven"};
        List<Boolean> asyncOptions = Arrays.asList(false, true);
        return asyncOptions.stream().flatMap(async -> Stream.of(Arguments.of("enum", Short.class, (short)2, alarm, labels, async), Arguments.of("enum", Short.class, (short)3, alarm, labels, async), Arguments.of("enum", short[].class, new short[]{4, 2}, alarm, labels, async), Arguments.of("enum", short[].class, new short[]{1, 3}, alarm, labels, async)));
    }

    static interface GenericIntegerConsumer
    extends Consumer<Integer> {
    }
}

