/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.epics.ca.Channel;
import org.epics.ca.ChannelDescriptor;
import org.epics.ca.Channels;
import org.epics.ca.ConnectionState;
import org.epics.ca.Context;
import org.epics.ca.EpicsChannelAccessTestServer;
import org.epics.ca.ThreadWatcher;
import org.epics.ca.annotation.CaChannel;
import org.epics.ca.impl.repeater.NetworkUtilities;
import org.epics.ca.util.logging.LibraryLogManager;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ChannelsTest {
    private static final Logger logger = LibraryLogManager.getLogger(ChannelsTest.class);
    private ThreadWatcher threadWatcher;
    private Context context;

    ChannelsTest() {
    }

    @BeforeAll
    static void beforeAll() {
        MatcherAssert.assertThat(NetworkUtilities.verifyTargetPlatformNetworkStackIsChannelAccessCompatible(), Is.is(true));
        if (NetworkUtilities.isVpnActive()) {
            Assertions.fail("This test is not supported when a VPN connection is active on the local network interface.");
        }
    }

    @BeforeEach
    void beforeEach() {
        this.threadWatcher = ThreadWatcher.start();
        EpicsChannelAccessTestServer.start();
        this.context = new Context();
    }

    @AfterEach
    void afterEach() {
        logger.info("Shutting down EPICSChannelAccessTestServer.");
        EpicsChannelAccessTestServer.shutdown();
        logger.info("Closing context.");
        this.context.close();
        this.threadWatcher.verify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testWaitForValue() {
        try (Channel<Integer> channel = this.context.createChannel("simple", Integer.class);){
            channel.connect();
            channel.put(0);
            ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
            try (Channel<Integer> channelAlias = this.context.createChannel("simple", Integer.class);){
                channelAlias.connect();
                executorService.schedule(() -> {
                    channel.put(12);
                    logger.info("Value set to 12");
                }, 2L, TimeUnit.SECONDS);
                long start = System.currentTimeMillis();
                Channels.waitForValue(channelAlias, 12);
                long end = System.currentTimeMillis();
                logger.info("value reached within " + (end - start));
                long elapsedTime = end - start;
                Assertions.assertTrue(elapsedTime > 1900L && elapsedTime < 2100L);
            }
            finally {
                executorService.shutdown();
            }
        }
    }

    @Test
    void testCreateChannelsWithDescriptors() {
        ArrayList descriptors = new ArrayList();
        descriptors.add(new ChannelDescriptor<String>("simple", String.class));
        descriptors.add(new ChannelDescriptor<Double>("adc01", Double.class));
        List<Channel<?>> channels = Channels.create(this.context, descriptors);
        Assertions.assertEquals(2, channels.size());
    }

    @Test
    void testAnnotations() {
        AnnotatedClass annotatedTestClass = new AnnotatedClass();
        Channels.create(this.context, annotatedTestClass);
        annotatedTestClass.getDoubleChannel().put(1.0);
        annotatedTestClass.getDoubleChannel().put(10.0);
        Assertions.assertTrue(annotatedTestClass.getStringChannel().get().startsWith("10"));
        Assertions.assertEquals(2, annotatedTestClass.getStringChannels().size());
        Channels.close(annotatedTestClass);
    }

    @Test
    void testAnnotationsMacro() {
        HashMap<String, String> macros = new HashMap<String, String>();
        macros.put("MACRO1", "01");
        AnnotatedClassMacros object = new AnnotatedClassMacros();
        Channels.create(this.context, object, macros);
        object.getDoubleChannel().get();
        Assertions.assertEquals((Object)ConnectionState.CONNECTED, (Object)object.getDoubleChannel().getConnectionState());
        Channel<Double> channel = object.getDoubleChannel();
        Channels.close(object);
        Assertions.assertEquals((Object)ConnectionState.CLOSED, (Object)channel.getConnectionState());
    }

    static class AnnotatedClassMacros {
        @CaChannel(name={"adc${MACRO1}"}, type=Double.class)
        private Channel<Double> doubleChannel;

        AnnotatedClassMacros() {
        }

        Channel<Double> getDoubleChannel() {
            return this.doubleChannel;
        }
    }

    static class AnnotatedClass {
        @CaChannel(name={"adc01"}, type=Double.class)
        private Channel<Double> doubleChannel;
        @CaChannel(name={"adc01"}, type=String.class)
        private Channel<String> stringChannel;
        @CaChannel(name={"adc01", "simple"}, type=String.class)
        private List<Channel<String>> stringChannels;

        AnnotatedClass() {
        }

        Channel<Double> getDoubleChannel() {
            return this.doubleChannel;
        }

        Channel<String> getStringChannel() {
            return this.stringChannel;
        }

        List<Channel<String>> getStringChannels() {
            return this.stringChannels;
        }
    }
}

