/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca;

import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.time.StopWatch;
import org.epics.ca.Channel;
import org.epics.ca.Context;
import org.epics.ca.EpicsChannelAccessTestServer;
import org.epics.ca.ThreadWatcher;
import org.epics.ca.impl.LibraryConfiguration;
import org.epics.ca.impl.ProtocolConfiguration;
import org.epics.ca.impl.repeater.CARepeaterStatusChecker;
import org.epics.ca.impl.repeater.NetworkUtilities;
import org.epics.ca.util.logging.LibraryLogManager;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;

class ContextTest {
    private static final int TEST_PORT = 5065;
    private static final String TEST_CHANNEL_NAME = "test01";
    private static final Logger logger = LibraryLogManager.getLogger(ContextTest.class);
    private ThreadWatcher threadWatcher;

    ContextTest() {
    }

    @BeforeAll
    static void beforeAll() {
        MatcherAssert.assertThat(NetworkUtilities.verifyTargetPlatformNetworkStackIsChannelAccessCompatible(), Is.is(true));
        if (NetworkUtilities.isVpnActive()) {
            Assertions.fail("This test is not supported when a VPN connection is active on the local network interface.");
        }
    }

    @BeforeEach
    void beforeEach() {
        this.threadWatcher = ThreadWatcher.start();
        MatcherAssert.assertThat(CARepeaterStatusChecker.isRepeaterRunning(5065), Is.is(false));
    }

    @AfterEach
    void afterEach() {
        MatcherAssert.assertThat(CARepeaterStatusChecker.verifyRepeaterStops(5065), Is.is(true));
        Assertions.assertDoesNotThrow(() -> this.threadWatcher.verify(), "Thread leak detected !");
    }

    @Test
    void testConstructor_withNoProperties_doesNotThrow() {
        Assertions.assertDoesNotThrow(() -> {
            try (Context ignored = new Context();){
                logger.info("The new context was successfully created.");
            }
        });
    }

    @Test
    void testConstructor_withEmptyProperties_doesNotThrow() {
        Assertions.assertDoesNotThrow(() -> {
            try (Context ignored = new Context(new Properties());){
                logger.info("The new context was successfully created.");
            }
        });
    }

    @Test
    void testConstructor_withNullProperties_doesThrow() {
        Exception ex = Assertions.assertThrows(NullPointerException.class, () -> {
            try (Context ignored = new Context(null);){
                logger.warning("The new context was created but shouldn't have been.");
            }
        });
        MatcherAssert.assertThat(ex.getMessage(), Is.is("null properties"));
    }

    @Test
    void testCreateChannel() {
        try (Context context = new Context();){
            Throwable throwable;
            Channel<Object> ignored5;
            Throwable throwable2;
            Channel<Object> ignored22;
            try {
                ignored22 = context.createChannel(null, null);
                throwable2 = null;
                try {
                    Assertions.fail("null name/type accepted");
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (ignored22 != null) {
                        if (throwable2 != null) {
                            try {
                                ignored22.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                        } else {
                            ignored22.close();
                        }
                    }
                }
            }
            catch (NullPointerException ignored22) {
                // empty catch block
            }
            try {
                ignored22 = context.createChannel(null, Double.class);
                throwable2 = null;
                try {
                    Assertions.fail("null name accepted");
                }
                catch (Throwable throwable5) {
                    throwable2 = throwable5;
                    throw throwable5;
                }
                finally {
                    if (ignored22 != null) {
                        if (throwable2 != null) {
                            try {
                                ignored22.close();
                            }
                            catch (Throwable throwable6) {
                                throwable2.addSuppressed(throwable6);
                            }
                        } else {
                            ignored22.close();
                        }
                    }
                }
            }
            catch (NullPointerException ignored3) {
                // empty catch block
            }
            try {
                ignored22 = context.createChannel(TEST_CHANNEL_NAME, null);
                throwable2 = null;
                try {
                    Assertions.fail("null type accepted");
                }
                catch (Throwable throwable7) {
                    throwable2 = throwable7;
                    throw throwable7;
                }
                finally {
                    if (ignored22 != null) {
                        if (throwable2 != null) {
                            try {
                                ignored22.close();
                            }
                            catch (Throwable throwable8) {
                                throwable2.addSuppressed(throwable8);
                            }
                        } else {
                            ignored22.close();
                        }
                    }
                }
            }
            catch (NullPointerException ignored4) {
                // empty catch block
            }
            String tooLongName = Stream.generate(() -> "a").limit(10000L).collect(Collectors.joining());
            try {
                ignored5 = context.createChannel(tooLongName, Double.class);
                throwable = null;
                try {
                    Assertions.fail("too long name accepted");
                }
                catch (Throwable throwable9) {
                    throwable = throwable9;
                    throw throwable9;
                }
                finally {
                    if (ignored5 != null) {
                        if (throwable != null) {
                            try {
                                ignored5.close();
                            }
                            catch (Throwable throwable10) {
                                throwable.addSuppressed(throwable10);
                            }
                        } else {
                            ignored5.close();
                        }
                    }
                }
            }
            catch (IllegalArgumentException ignored5) {
                // empty catch block
            }
            try {
                ignored5 = context.createChannel(TEST_CHANNEL_NAME, Context.class);
                throwable = null;
                try {
                    Assertions.fail("invalid type accepted");
                }
                catch (Throwable throwable11) {
                    throwable = throwable11;
                    throw throwable11;
                }
                finally {
                    if (ignored5 != null) {
                        if (throwable != null) {
                            try {
                                ignored5.close();
                            }
                            catch (Throwable throwable12) {
                                throwable.addSuppressed(throwable12);
                            }
                        } else {
                            ignored5.close();
                        }
                    }
                }
            }
            catch (IllegalArgumentException ignored6) {
                // empty catch block
            }
            try {
                ignored5 = context.createChannel(TEST_CHANNEL_NAME, Double.class, -1);
                throwable = null;
                try {
                    Assertions.fail("priority out of range accepted");
                }
                catch (Throwable throwable13) {
                    throwable = throwable13;
                    throw throwable13;
                }
                finally {
                    if (ignored5 != null) {
                        if (throwable != null) {
                            try {
                                ignored5.close();
                            }
                            catch (Throwable throwable14) {
                                throwable.addSuppressed(throwable14);
                            }
                        } else {
                            ignored5.close();
                        }
                    }
                }
            }
            catch (IllegalArgumentException ignored7) {
                // empty catch block
            }
            try {
                ignored5 = context.createChannel(TEST_CHANNEL_NAME, Double.class, 100);
                throwable = null;
                try {
                    Assertions.fail("priority out of range accepted");
                }
                catch (Throwable throwable15) {
                    throwable = throwable15;
                    throw throwable15;
                }
                finally {
                    if (ignored5 != null) {
                        if (throwable != null) {
                            try {
                                ignored5.close();
                            }
                            catch (Throwable throwable16) {
                                throwable.addSuppressed(throwable16);
                            }
                        } else {
                            ignored5.close();
                        }
                    }
                }
            }
            catch (IllegalArgumentException ignored8) {
                // empty catch block
            }
            throwable = null;
            try (Channel<Double> c1 = context.createChannel(TEST_CHANNEL_NAME, Double.class);
                 Channel<Double> c2 = context.createChannel(TEST_CHANNEL_NAME, Double.class);){
                Assertions.assertNotNull(c1);
                Assertions.assertNotNull(c2);
                Assertions.assertNotSame(c1, c2);
                Assertions.assertEquals(TEST_CHANNEL_NAME, c1.getName());
            }
            catch (Throwable throwable17) {
                throwable = throwable17;
                throw throwable17;
            }
            throwable = null;
            try (Channel<Double> c = context.createChannel(TEST_CHANNEL_NAME, Double.class, 0);){
                Assertions.assertNotNull(c);
            }
            catch (Throwable throwable18) {
                throwable = throwable18;
                throw throwable18;
            }
        }
    }

    @Test
    void testOperationsOnClosedContext() {
        Context context = new Context();
        context.close();
        context.close();
        try {
            context.createChannel(TEST_CHANNEL_NAME, Double.class);
            Assertions.fail("creation of a channel on closed context must fail");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            context.createChannel(TEST_CHANNEL_NAME, Double.class, 0);
            Assertions.fail("creation of a channel on closed context must fail");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    void integrationTestCreateContext_doesNotStartRepeater_whenDisabled() {
        System.setProperty(LibraryConfiguration.PropertyNames.CA_REPEATER_DISABLE.toString(), "true");
        try (Context ignored = new Context();){
            MatcherAssert.assertThat(CARepeaterStatusChecker.verifyRepeaterStarts(5065), Is.is(false));
        }
        System.setProperty(LibraryConfiguration.PropertyNames.CA_REPEATER_DISABLE.toString(), String.valueOf(false));
    }

    @Test
    void integrationTestCreateContext_startsRepeater_whenEnabled() {
        System.setProperty(LibraryConfiguration.PropertyNames.CA_REPEATER_DISABLE.toString(), "false");
        try (Context ignored = new Context();){
            MatcherAssert.assertThat(CARepeaterStatusChecker.verifyRepeaterStarts(5065), Is.is(true));
        }
        MatcherAssert.assertThat(CARepeaterStatusChecker.verifyRepeaterStops(5065), Is.is(true));
        System.setProperty(LibraryConfiguration.PropertyNames.CA_REPEATER_DISABLE.toString(), String.valueOf(false));
    }

    @Test
    void integrationTestCreateContext_startsRepeaterByDefault() {
        try (Context ignored = new Context();){
            MatcherAssert.assertThat(CARepeaterStatusChecker.verifyRepeaterStarts(5065), Is.is(true));
        }
        MatcherAssert.assertThat(CARepeaterStatusChecker.verifyRepeaterStops(5065), Is.is(true));
    }

    @Test
    void integrationTestCreateMultipleContexts_repeaterShutdownOccursOnlyAfterLastContextIsClosed() {
        System.setProperty(LibraryConfiguration.PropertyNames.CA_REPEATER_DISABLE.toString(), "false");
        Context ignored1 = new Context();
        MatcherAssert.assertThat(CARepeaterStatusChecker.verifyRepeaterStarts(5065), Is.is(true));
        try (Context ignored2 = new Context();){
            MatcherAssert.assertThat(CARepeaterStatusChecker.isRepeaterRunning(5065), Is.is(true));
        }
        MatcherAssert.assertThat(CARepeaterStatusChecker.isRepeaterRunning(5065), Is.is(true));
        ignored1.close();
        MatcherAssert.assertThat(CARepeaterStatusChecker.verifyRepeaterStops(5065), Is.is(true));
        System.setProperty(LibraryConfiguration.PropertyNames.CA_REPEATER_DISABLE.toString(), String.valueOf(false));
    }

    @Test
    void integrationTestCreateMultipleContexts_withMultipleRepeaters_runningOnMultiplePorts() {
        Properties ctx1Props = new Properties();
        ctx1Props.setProperty(ProtocolConfiguration.PropertyNames.EPICS_CA_REPEATER_PORT.toString(), "1111");
        Context ignored1 = new Context(ctx1Props);
        MatcherAssert.assertThat(CARepeaterStatusChecker.verifyRepeaterStarts(1111), Is.is(true));
        Properties ctx2Props = new Properties();
        ctx2Props.setProperty(ProtocolConfiguration.PropertyNames.EPICS_CA_REPEATER_PORT.toString(), "2222");
        try (Context ignored2 = new Context(ctx2Props);){
            MatcherAssert.assertThat(CARepeaterStatusChecker.verifyRepeaterStarts(2222), Is.is(true));
        }
        MatcherAssert.assertThat(CARepeaterStatusChecker.verifyRepeaterStops(2222), Is.is(true));
        ignored1.close();
        MatcherAssert.assertThat(CARepeaterStatusChecker.verifyRepeaterStops(1111), Is.is(true));
    }

    @Test
    void integrationTestRepeaterRegistration() throws InterruptedException {
        System.setProperty(LibraryConfiguration.PropertyNames.CA_LIBRARY_LOG_LEVEL.toString(), Level.FINER.toString());
        System.setProperty(LibraryConfiguration.PropertyNames.CA_REPEATER_LOG_LEVEL.toString(), Level.ALL.toString());
        System.setProperty(LibraryConfiguration.PropertyNames.CA_REPEATER_OUTPUT_CAPTURE.toString(), "true");
        try (Context ignored = new Context();){
            Thread.sleep(600L);
        }
        System.setProperty(LibraryConfiguration.PropertyNames.CA_LIBRARY_LOG_LEVEL.toString(), LibraryConfiguration.CA_LIBRARY_LOG_LEVEL_DEFAULT.toString());
        System.setProperty(LibraryConfiguration.PropertyNames.CA_REPEATER_LOG_LEVEL.toString(), LibraryConfiguration.CA_REPEATER_LOG_LEVEL_DEFAULT.toString());
        System.setProperty(LibraryConfiguration.PropertyNames.CA_REPEATER_OUTPUT_CAPTURE.toString(), String.valueOf(false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CsvSource(value={"false, 10000, 15000", "true, 0, 2000"})
    @ParameterizedTest
    void integrationTestTimeToConnectToNewlyStartedChannelAccessServer(boolean repeaterEnable, int minConnectTimeInMillis, int maxConnectTimeInMillis) throws InterruptedException, ExecutionException {
        System.setProperty(LibraryConfiguration.PropertyNames.CA_REPEATER_DISABLE.toString(), String.valueOf(!repeaterEnable));
        StopWatch stopWatch = new StopWatch();
        try (Context context = new Context();){
            Channel<String> channel = context.createChannel("adc01", String.class);
            CompletableFuture<Channel<String>> future = channel.connectAsync();
            Thread.sleep(13000L);
            logger.info("Starting Test Server...");
            EpicsChannelAccessTestServer.start();
            stopWatch.start();
            future.get();
            stopWatch.stop();
            String repeaterState = repeaterEnable ? "ENABLED" : "DISABLED";
            logger.info("TIME TO CONNECT WITH REPEATER " + repeaterState + " = " + stopWatch.getTime(TimeUnit.MILLISECONDS) + " ms.");
        }
        finally {
            System.setProperty(LibraryConfiguration.PropertyNames.CA_REPEATER_DISABLE.toString(), String.valueOf(false));
            EpicsChannelAccessTestServer.shutdown();
        }
        MatcherAssert.assertThat((int)stopWatch.getTime(TimeUnit.MILLISECONDS), Matchers.greaterThan(minConnectTimeInMillis));
        MatcherAssert.assertThat((int)stopWatch.getTime(TimeUnit.MILLISECONDS), Matchers.lessThan(maxConnectTimeInMillis));
    }
}

