/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca;

import java.util.Properties;
import java.util.logging.Level;
import org.epics.ca.Context;
import org.epics.ca.EpicsChannelAccessTestServer;
import org.epics.ca.ThreadWatcher;
import org.epics.ca.impl.repeater.NetworkUtilities;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Test;

public class EpicsChannelAccessTestServerTest {
    private ThreadWatcher threadWatcher;

    @BeforeEach
    void beforeEach() {
        this.threadWatcher = ThreadWatcher.start();
        if (NetworkUtilities.isVpnActive()) {
            Assertions.fail("This test is not supported when a VPN connection is active on the local network interface.");
        }
    }

    @AfterEach
    void afterEach() {
        this.threadWatcher.verify();
    }

    @RepeatedTest(value=10)
    void startThenShutdownRepeatedly() throws InterruptedException {
        EpicsChannelAccessTestServer.start();
        Thread.sleep(100L);
        EpicsChannelAccessTestServer.shutdown();
    }

    @Test
    void startWhenAlreadyStarted_throwsIllegalStateException() {
        EpicsChannelAccessTestServer.start();
        RuntimeException ex = Assertions.assertThrows(IllegalStateException.class, EpicsChannelAccessTestServer::start);
        MatcherAssert.assertThat(ex.getMessage(), Is.is("The EpicsChanneAccessTestServer was not shutdown."));
        EpicsChannelAccessTestServer.shutdown();
    }

    @Test
    void shutdownWhenAlreadyShutdown_throwsIllegalStateException() {
        RuntimeException ex = Assertions.assertThrows(IllegalStateException.class, EpicsChannelAccessTestServer::shutdown);
        MatcherAssert.assertThat(ex.getMessage(), Is.is("The EpicsChanneAccessTestServer was not started."));
    }

    @Test
    void testRepeaterBeaconForwarding() throws InterruptedException {
        Properties properties = new Properties();
        properties.setProperty("CA_LIBRARY_LOG_LEVEL", Level.ALL.toString());
        properties.setProperty("CA_REPEATER_LOG_LEVEL", Level.ALL.toString());
        properties.setProperty("CA_REPEATER_OUTPUT_CAPTURE", "true");
        try (Context ignored = new Context(properties);){
            Thread.sleep(1000L);
            EpicsChannelAccessTestServer.start();
            Thread.sleep(10000L);
        }
        EpicsChannelAccessTestServer.shutdown();
    }
}

