/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca;

import java.net.URL;
import java.util.logging.Logger;
import org.epics.ca.LibraryVersion;
import org.epics.ca.util.logging.LibraryLogManager;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.Test;

public class LibraryVersionTest {
    private static final Logger logger = LibraryLogManager.getLogger(LibraryVersionTest.class);

    @Test
    void testLibraryVersion() {
        URL testResource = LibraryVersionTest.class.getResource("LibraryVersionTest.class");
        boolean runningFromjarX = testResource.toString().startsWith("jar:");
        String versionString = LibraryVersion.getAsString();
        if (runningFromjarX) {
            logger.info("Test is running from JAR. Version is: " + versionString + "'.");
            MatcherAssert.assertThat(LibraryVersion.getAsString(), Is.is("1.3.2"));
        } else {
            logger.info("Test is running from class file without manifest. Version is: '" + versionString + "'.");
            MatcherAssert.assertThat(LibraryVersion.getAsString(), Is.is("<unknown>"));
        }
    }
}

