/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.jcip.annotations.ThreadSafe;
import org.epics.ca.util.logging.LibraryLogManager;

@ThreadSafe
public class ThreadWatcher {
    private static final Logger logger = LibraryLogManager.getLogger(ThreadWatcher.class);
    private static final Set<String> jvmManagedThreads = new HashSet<String>(Arrays.asList("process reaper", "Finalizer", "Reference Handler", "Signal Dispatcher", "Attach Listener"));
    private final Set<Thread> threadsAtStart;

    private ThreadWatcher(Set<Thread> threadsAtStart) {
        logger.finest("Threads at start: '" + threadsAtStart + "'");
        this.threadsAtStart = threadsAtStart;
    }

    public static ThreadWatcher start() {
        return new ThreadWatcher(ThreadWatcher.getStableThreadSnapshot());
    }

    public void verify() {
        Set<Thread> threadsAtEndTry1 = ThreadWatcher.getStableThreadSnapshot();
        logger.finest("Threads at end: try 1: '" + threadsAtEndTry1 + "'");
        if (ThreadWatcher.userThreadsEqual(this.threadsAtStart, threadsAtEndTry1)) {
            return;
        }
        logger.info("Waiting for thread stabilisation...");
        int mediumStabilisationDelayInMillis = 500;
        ThreadWatcher.safeSleep(500);
        Set<Thread> threadsAtEndTry2 = ThreadWatcher.getStableThreadSnapshot();
        logger.finest("Threads at end: try 2: '" + threadsAtEndTry2 + "'");
        if (ThreadWatcher.userThreadsEqual(this.threadsAtStart, threadsAtEndTry2)) {
            return;
        }
        logger.info("Waiting for thread stabilisation...");
        int longStabilisationDelayInMillis = 1000;
        ThreadWatcher.safeSleep(1000);
        Set<Thread> threadsAtEndTry3 = ThreadWatcher.getStableThreadSnapshot();
        logger.finest("Threads at end: try 3: '" + threadsAtEndTry3 + "'");
        if (ThreadWatcher.userThreadsEqual(this.threadsAtStart, threadsAtEndTry3)) {
            return;
        }
        logger.info("-- THREAD CHANGE REPORT ---------------------------");
        logger.info("-- BEFORE -----------------------------------------");
        ThreadWatcher.showThreads(this.threadsAtStart);
        logger.info("-- NOW --------------------------------------------");
        ThreadWatcher.showThreads(threadsAtEndTry3);
        logger.info("---------------------------------------------------");
        String message = "There have been unexpected thread changes - there is probably a resource leak !";
        logger.warning("There have been unexpected thread changes - there is probably a resource leak !");
        throw new RuntimeException("There have been unexpected thread changes - there is probably a resource leak !");
    }

    private static boolean userThreadsEqual(Set<Thread> before, Set<Thread> after) {
        Set filteredBefore = before.stream().filter(x -> !jvmManagedThreads.contains(x.getName().trim())).collect(Collectors.toSet());
        Set filteredAfter = after.stream().filter(x -> !jvmManagedThreads.contains(x.getName().trim())).collect(Collectors.toSet());
        return filteredBefore.equals(filteredAfter);
    }

    private static Set<Thread> getStableThreadSnapshot() {
        int shortStabilisationDelayInMillis = 10;
        Set<Thread> threadsEarlier = ThreadWatcher.getThreadSnapshot();
        ThreadWatcher.safeSleep(10);
        Set<Thread> threadsNow = ThreadWatcher.getThreadSnapshot();
        while (!threadsNow.equals(threadsEarlier)) {
            threadsEarlier = threadsNow;
            threadsNow = ThreadWatcher.getThreadSnapshot();
            ThreadWatcher.safeSleep(10);
        }
        return threadsNow;
    }

    private static Set<Thread> getThreadSnapshot() {
        return Thread.getAllStackTraces().keySet();
    }

    private static void safeSleep(int delayInMillis) {
        try {
            Thread.sleep(delayInMillis);
        }
        catch (InterruptedException e) {
            String message = "Interrupted whilst waiting for threads to stabilise";
            logger.warning("Interrupted whilst waiting for threads to stabilise");
            throw new RuntimeException("Interrupted whilst waiting for threads to stabilise");
        }
    }

    private static void showThreads(Set<Thread> threadSet) {
        threadSet.forEach(x -> logger.info(x.getName()));
    }
}

