/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.examples;

import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import net.jcip.annotations.ThreadSafe;
import org.epics.ca.EpicsChannelAccessTestServer;
import org.epics.ca.examples.Example;
import org.epics.ca.impl.JavaProcessManager;
import org.epics.ca.util.logging.LibraryLogManager;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

@ThreadSafe
public class ExampleTest {
    private static final Logger logger = LibraryLogManager.getLogger(ExampleTest.class);

    @BeforeEach
    void beforeEach() {
        EpicsChannelAccessTestServer.start();
    }

    @AfterEach
    void afterEach() {
        EpicsChannelAccessTestServer.shutdown();
    }

    @Test
    void runExample() throws InterruptedException {
        Properties properties = new Properties();
        JavaProcessManager exampleRunner = new JavaProcessManager(Example.class, properties, new String[0]);
        boolean startedOk = exampleRunner.start(true);
        MatcherAssert.assertThat(startedOk, Is.is(true));
        boolean completedOK = exampleRunner.waitFor(10L, TimeUnit.SECONDS);
        if (!completedOK) {
            exampleRunner.shutdown();
        }
        MatcherAssert.assertThat(completedOK, Is.is(true));
        MatcherAssert.assertThat(exampleRunner.getExitValue(), Is.is(0));
    }
}

