/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.impl;

import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.Validate;
import org.epics.ca.AccessRights;
import org.epics.ca.Channel;
import org.epics.ca.ConnectionState;
import org.epics.ca.Constants;
import org.epics.ca.Listener;
import org.epics.ca.Monitor;
import org.epics.ca.Status;
import org.epics.ca.data.Metadata;
import org.epics.ca.impl.ContextImpl;
import org.epics.ca.impl.Messages;
import org.epics.ca.impl.ResponseRequest;
import org.epics.ca.impl.StatefullEventSource;
import org.epics.ca.impl.TcpTransport;
import org.epics.ca.impl.Transport;
import org.epics.ca.impl.TransportClient;
import org.epics.ca.impl.TypeSupports;
import org.epics.ca.impl.monitor.MonitorNotificationService;
import org.epics.ca.impl.monitor.MonitorNotificationServiceFactory;
import org.epics.ca.impl.requests.MonitorRequest;
import org.epics.ca.impl.requests.ReadNotifyRequest;
import org.epics.ca.impl.requests.WriteNotifyRequest;
import org.epics.ca.util.IntHashMap;
import org.epics.ca.util.logging.LibraryLogManager;

public class ChannelImpl<T>
implements Channel<T>,
TransportClient {
    private final Map<AccessRightsListener, BiConsumer<Channel<T>, AccessRights>> accessRightsListeners = new HashMap<AccessRightsListener, BiConsumer<Channel<T>, AccessRights>>();
    private final ContextImpl context;
    private final String name;
    private final Class<T> channelType;
    private final int priority;
    private final int cid;
    private final int INVALID_SID = -1;
    private int sid = -1;
    private TcpTransport tcpTransport;
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final AtomicReference<ConnectionState> connectionState = new AtomicReference<ConnectionState>(ConnectionState.NEVER_CONNECTED);
    private final AtomicReference<AccessRights> accessRights = new AtomicReference<AccessRights>(AccessRights.NO_RIGHTS);
    private final AtomicReference<Object> timerIdRef = new AtomicReference();
    private final AccessRightsStatefullEventSource accessRightsEventSource = new AccessRightsStatefullEventSource();
    private final IntHashMap<ResponseRequest> responseRequests = new IntHashMap();
    private final TypeSupports.TypeSupport<T> typeSupport;
    private final AtomicBoolean connectIssued = new AtomicBoolean(false);
    private final AtomicReference<CompletableFuture<Channel<T>>> connectFuture = new AtomicReference();
    private final ConnectionStateStatefullEventSource connectionStateEventSource = new ConnectionStateStatefullEventSource();
    private final Map<ConnectionListener, BiConsumer<Channel<T>, Boolean>> connectionListeners = new HashMap<ConnectionListener, BiConsumer<Channel<T>, Boolean>>();
    private boolean allowCreation = false;
    private volatile int nativeElementCount = 0;
    private final AtomicInteger connectionLossId = new AtomicInteger();
    private static final Logger logger = LibraryLogManager.getLogger(ChannelImpl.class);

    public ChannelImpl(ContextImpl context, String name, Class<T> channelType, int priority) {
        this.context = context;
        this.name = name;
        this.channelType = channelType;
        this.priority = priority;
        TypeSupports.TypeSupport<Object> typeSupport = this.typeSupport = channelType.equals(Object.class) ? new DynamicTypeSupport() : TypeSupports.getTypeSupportForType(channelType);
        if (this.typeSupport == null) {
            throw new RuntimeException("Unsupported channel data type " + channelType);
        }
        this.cid = context.generateCID();
        context.registerChannel(this);
    }

    @Override
    public void transportClosed() {
        this.disconnect(true);
    }

    @Override
    public void close() {
        if (this.connectionState.getAndSet(ConnectionState.CLOSED) == ConnectionState.CLOSED) {
            return;
        }
        this.context.getChannelSearchManager().unregisterChannel(this);
        this.disconnectPendingIO(true);
        if (this.tcpTransport != null) {
            try {
                Messages.clearChannelMessage(this.tcpTransport, this.cid, this.sid);
                this.tcpTransport.flush();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.tcpTransport.release(this);
            this.tcpTransport = null;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ConnectionState getConnectionState() {
        return this.connectionState.get();
    }

    @Override
    public AccessRights getAccessRights() {
        return this.accessRights.get();
    }

    @Override
    public CompletableFuture<Channel<T>> connectAsync() {
        if (!this.connectIssued.getAndSet(true)) {
            CompletableFuture<Channel<T>> future = new CompletableFuture<Channel<T>>();
            this.connectFuture.set(future);
            this.initiateSearch();
            return future;
        }
        throw new IllegalStateException("Connect already issued on this channel instance.");
    }

    @Override
    public Channel<T> connect() {
        try {
            return this.connectAsync().get();
        }
        catch (Throwable th) {
            throw new RuntimeException("Failed to connect.", th);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Listener addConnectionListener(BiConsumer<Channel<T>, Boolean> handler) {
        ConnectionListener cl = new ConnectionListener();
        Map<ConnectionListener, BiConsumer<Channel<T>, Boolean>> map = this.connectionListeners;
        synchronized (map) {
            this.connectionListeners.put(cl, handler);
        }
        return cl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Listener addAccessRightListener(BiConsumer<Channel<T>, AccessRights> handler) {
        AccessRightsListener arl = new AccessRightsListener();
        Map<AccessRightsListener, BiConsumer<Channel<T>, AccessRights>> map = this.accessRightsListeners;
        synchronized (map) {
            this.accessRightsListeners.put(arl, handler);
        }
        return arl;
    }

    @Override
    public T get() {
        try {
            return this.getAsync().get();
        }
        catch (Throwable th) {
            throw new RuntimeException("Failed to do get.", th);
        }
    }

    @Override
    public void put(T value) {
        try {
            CompletableFuture<Status> call = this.putAsync(value);
            Status status = call.get();
            if (!status.isSuccessful()) {
                throw new RuntimeException(status.getMessage());
            }
        }
        catch (Throwable th) {
            throw new RuntimeException("Failed to do put.", th);
        }
    }

    @Override
    public void putNoWait(T value) {
        TcpTransport tcpTransport = this.getTcpTransportIfConnected();
        AccessRights currentRights = this.getAccessRights();
        boolean haveWriteRights = currentRights == AccessRights.WRITE || currentRights == AccessRights.READ_WRITE;
        Validate.validState(haveWriteRights, "No write rights.", new Object[0]);
        int count = this.typeSupport.getForcedElementCount();
        if (count == 0) {
            count = Array.getLength(value);
        }
        Messages.writeMessage(tcpTransport, this.sid, this.cid, this.typeSupport, value, count);
        tcpTransport.flush();
    }

    @Override
    public CompletableFuture<T> getAsync() {
        TcpTransport tcpTransport = this.getTcpTransportIfConnected();
        AccessRights currentRights = this.getAccessRights();
        boolean haveReadRights = currentRights == AccessRights.READ || currentRights == AccessRights.READ_WRITE;
        Validate.validState(haveReadRights, "No read rights.", new Object[0]);
        return new ReadNotifyRequest<T>(this, tcpTransport, this.sid, this.typeSupport);
    }

    @Override
    public CompletableFuture<Status> putAsync(T value) {
        TcpTransport tcpTransport = this.getTcpTransportIfConnected();
        AccessRights currentRights = this.getAccessRights();
        boolean haveWriteRights = currentRights == AccessRights.WRITE || currentRights == AccessRights.READ_WRITE;
        Validate.validState(haveWriteRights, "No write rights.", new Object[0]);
        int count = this.typeSupport.getForcedElementCount();
        if (count == 0) {
            count = Array.getLength(value);
        }
        return new WriteNotifyRequest<T>(this, tcpTransport, this.sid, this.typeSupport, value, count);
    }

    @Override
    public <MT extends Metadata<T>> MT get(Class<? extends Metadata> clazz) {
        try {
            return (MT)((Metadata)this.getAsync(clazz).get());
        }
        catch (Throwable th) {
            throw new RuntimeException("Failed to do get.", th);
        }
    }

    @Override
    public <MT extends Metadata<T>> CompletableFuture<MT> getAsync(Class<? extends Metadata> clazz) {
        TcpTransport tcpTransport = this.getTcpTransportIfConnected();
        TypeSupports.TypeSupport<? extends Metadata> metaTypeSupport = this.getTypeSupport(clazz, this.channelType);
        AccessRights currentRights = this.getAccessRights();
        boolean haveReadRights = currentRights == AccessRights.READ || currentRights == AccessRights.READ_WRITE;
        Validate.validState(haveReadRights, "No read rights.", new Object[0]);
        return new ReadNotifyRequest<Metadata>(this, tcpTransport, this.sid, metaTypeSupport);
    }

    @Override
    public Monitor<T> addValueMonitor(Consumer<? super T> handler, int mask) {
        Validate.isTrue(mask != 0, "The mask cannot be zero.", new Object[0]);
        TcpTransport tcpTransport = this.getTcpTransportIfConnected();
        MonitorNotificationServiceFactory serviceFactory = this.context.getMonitorNotificationServiceFactory();
        MonitorNotificationService<? super T> notifier = serviceFactory.getServiceForConsumer(handler);
        return new MonitorRequest<T>(this, tcpTransport, this.typeSupport, mask, notifier, handler);
    }

    @Override
    public <MT extends Metadata<T>> Monitor<MT> addMonitor(Class<? extends Metadata> clazz, Consumer<MT> handler, int mask) {
        Validate.isTrue(mask != 0, "The mask cannot be zero.", new Object[0]);
        TcpTransport tcpTransport = this.getTcpTransportIfConnected();
        TypeSupports.TypeSupport<? extends Metadata> metaTypeSupport = this.getTypeSupport(clazz, this.channelType);
        MonitorNotificationServiceFactory serviceFactory = this.context.getMonitorNotificationServiceFactory();
        MonitorNotificationService<MT> notifier = serviceFactory.getServiceForConsumer(handler);
        return new MonitorRequest<Metadata>(this, tcpTransport, metaTypeSupport, mask, notifier, handler);
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public boolean generateSearchRequestMessage(Transport transport, ByteBuffer buffer) {
        return Messages.generateSearchRequestMessage(transport, buffer, this.name, this.cid);
    }

    public synchronized TcpTransport getTcpTransport() {
        return this.tcpTransport;
    }

    public int getNativeElementCount() {
        return this.nativeElementCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerResponseRequest(ResponseRequest responseRequest) {
        IntHashMap<ResponseRequest> intHashMap = this.responseRequests;
        synchronized (intHashMap) {
            this.responseRequests.put(responseRequest.getIOID(), responseRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterResponseRequest(ResponseRequest responseRequest) {
        IntHashMap<ResponseRequest> intHashMap = this.responseRequests;
        synchronized (intHashMap) {
            this.responseRequests.remove(responseRequest.getIOID());
        }
    }

    public int getCID() {
        return this.cid;
    }

    public int getSID() {
        return this.sid;
    }

    public void setAccessRights(AccessRights rights) {
        AccessRights previousRights = this.accessRights.getAndSet(rights);
        if (previousRights != rights) {
            this.context.enqueueStatefullEvent(this.accessRightsEventSource);
        }
    }

    public void setTimerId(Object timerId) {
        this.timerIdRef.set(timerId);
    }

    public Object getTimerId() {
        return this.timerIdRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createChannel(TcpTransport transport, int sid, short typeCode, int elementCount) {
        ChannelImpl channelImpl = this;
        synchronized (channelImpl) {
            if (!this.allowCreation) {
                return;
            }
            this.allowCreation = false;
            if (this.tcpTransport != null && this.tcpTransport != transport) {
                this.disconnectPendingIO(false);
                this.tcpTransport.release(this);
            } else if (this.tcpTransport == transport) {
                return;
            }
            this.tcpTransport = transport;
            if (transport.getMinorRevision() < 4) {
                this.sid = sid;
                this.nativeElementCount = elementCount;
                this.properties.put(Constants.ChannelProperties.nativeTypeCode.name(), typeCode);
                this.properties.put(Constants.ChannelProperties.nativeElementCount.name(), elementCount);
            }
            this.properties.put(Constants.ChannelProperties.remoteAddress.name(), transport.getRemoteAddress());
        }
        try {
            Messages.createChannelMessage(transport, this.name, this.cid);
            transport.flush();
        }
        catch (Throwable th) {
            this.createChannelFailed();
        }
    }

    public synchronized void disconnect(boolean reconnect) {
        if (this.connectionState.get() != ConnectionState.CONNECTED && this.tcpTransport == null) {
            return;
        }
        this.setConnectionState(ConnectionState.DISCONNECTED);
        this.connectionLossId.incrementAndGet();
        this.disconnectPendingIO(false);
        if (this.tcpTransport != null) {
            this.tcpTransport.release(this);
            this.tcpTransport = null;
        }
        if (reconnect) {
            this.initiateSearch();
        }
    }

    int getPriority() {
        return this.priority;
    }

    void createChannelFailed() {
        this.initiateSearch();
    }

    TypeSupports.TypeSupport<T> getTypeSupport() {
        return this.typeSupport;
    }

    synchronized void connectionCompleted(int sid, short typeCode, int elementCount) throws IllegalStateException {
        if (this.connectionState.get() == ConnectionState.CLOSED) {
            return;
        }
        if (this.tcpTransport.getMinorRevision() < 1) {
            this.setAccessRights(AccessRights.READ_WRITE);
        }
        if (this.tcpTransport.getMinorRevision() >= 4) {
            this.sid = sid;
            this.nativeElementCount = elementCount;
            this.properties.put(Constants.ChannelProperties.nativeTypeCode.name(), typeCode);
            this.properties.put(Constants.ChannelProperties.nativeElementCount.name(), elementCount);
        }
        if (this.typeSupport instanceof DynamicTypeSupport) {
            TypeSupports.TypeSupport<?> nativeTypeSupport = TypeSupports.getTypeSupport(typeCode, elementCount);
            if (nativeTypeSupport == null) {
                logger.log(Level.SEVERE, "Type support for typeCode=" + typeCode + ", elementCount=" + elementCount + " is not supported, switching to String/String[]");
                nativeTypeSupport = elementCount > 1 ? TypeSupports.getTypeSupportForType(String[].class) : TypeSupports.getTypeSupportForType(String.class);
            }
            ((DynamicTypeSupport)this.typeSupport).setDelegate(nativeTypeSupport);
        }
        this.properties.put(Constants.ChannelProperties.nativeType.name(), this.typeSupport.newInstance().getClass());
        this.resubscribeSubscriptions(this.tcpTransport);
        this.setConnectionState(ConnectionState.CONNECTED);
    }

    synchronized void initiateSearch() {
        this.allowCreation = true;
        this.context.getChannelSearchManager().registerChannel(this);
    }

    void setAccessRights(int rightsCode) {
        this.setAccessRights(AccessRights.values()[rightsCode]);
    }

    private int getConnectionLossId() {
        return this.connectionLossId.get();
    }

    private void setConnectionState(ConnectionState state) {
        ConnectionState previousCS = this.connectionState.getAndSet(state);
        if (previousCS != state) {
            CompletableFuture cf = this.connectFuture.getAndSet(null);
            if (cf != null) {
                cf.complete(this);
            }
            this.context.enqueueStatefullEvent(this.connectionStateEventSource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resubscribeSubscriptions(Transport transport) {
        ResponseRequest[] responseRequestArray = this.responseRequests;
        synchronized (this.responseRequests) {
            int count = this.responseRequests.size();
            if (count == 0) {
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return;
            }
            ResponseRequest[] requests = new ResponseRequest[count];
            requests = this.responseRequests.toArray((ResponseRequest[])requests);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            for (ResponseRequest request : requests) {
                try {
                    if (!(request instanceof MonitorRequest)) continue;
                    ((MonitorRequest)request).resubscribe(transport);
                }
                catch (Throwable th) {
                    logger.log(Level.WARNING, "Unexpected exception caught during resubscription notification.", th);
                }
            }
            return;
        }
    }

    private TcpTransport getTcpTransportIfConnected() {
        TcpTransport transport = this.getTcpTransport();
        boolean isConnected = this.connectionState.get() == ConnectionState.CONNECTED && transport != null;
        Validate.validState(isConnected, "Channel not connected", new Object[0]);
        return transport;
    }

    private TypeSupports.TypeSupport<?> getTypeSupport(Class<?> metaTypeClass, Class<?> typeClass) {
        TypeSupports.TypeSupport<?> metaTypeSupport = TypeSupports.getTypeSupportForMetatypeAndType(metaTypeClass, typeClass);
        if (metaTypeSupport == null) {
            if (this.typeSupport instanceof DynamicTypeSupport) {
                Class nativeType = (Class)this.properties.get(Constants.ChannelProperties.nativeType.name());
                metaTypeSupport = TypeSupports.getTypeSupportForMetatypeAndType(metaTypeClass, nativeType);
            }
            if (metaTypeSupport == null) {
                throw new RuntimeException("Unsupported channel metadata type " + metaTypeClass + "<" + typeClass + ">");
            }
        }
        return metaTypeSupport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnectPendingIO(boolean destroy) {
        Status status = destroy ? Status.CHANDESTROY : Status.DISCONN;
        ResponseRequest[] responseRequestArray = this.responseRequests;
        synchronized (this.responseRequests) {
            ResponseRequest[] requests = new ResponseRequest[this.responseRequests.size()];
            requests = this.responseRequests.toArray((ResponseRequest[])requests);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            for (ResponseRequest request : requests) {
                try {
                    request.exception(status.getStatusCode(), null);
                }
                catch (Throwable th) {
                    logger.log(Level.WARNING, "Unexpected exception caught during disconnect/destroy notification.", th);
                }
            }
            return;
        }
    }

    private class DynamicTypeSupport
    implements TypeSupports.TypeSupport<T> {
        private final AtomicReference<TypeSupports.TypeSupport> delegate = new AtomicReference();

        private DynamicTypeSupport() {
        }

        public void setDelegate(TypeSupports.TypeSupport typeSupport) {
            this.delegate.set(typeSupport);
        }

        @Override
        public T newInstance() {
            return this.delegate.get().newInstance();
        }

        @Override
        public int getDataType() {
            return this.delegate.get().getDataType();
        }

        @Override
        public T deserialize(ByteBuffer buffer, T object, int count) {
            return this.delegate.get().deserialize(buffer, object, count);
        }

        @Override
        public int getForcedElementCount() {
            return this.delegate.get().getForcedElementCount();
        }

        @Override
        public void serialize(ByteBuffer buffer, T object, int count) {
            this.delegate.get().serialize(buffer, object, count);
        }

        @Override
        public int serializeSize(T object, int count) {
            return this.delegate.get().serializeSize(object, count);
        }
    }

    class ConnectionStateStatefullEventSource
    extends StatefullEventSource {
        ConnectionStateStatefullEventSource() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispatch() {
            BiConsumer[] listeners;
            boolean connected = ChannelImpl.this.getConnectionState() == ConnectionState.CONNECTED;
            BiConsumer[] biConsumerArray = ChannelImpl.this.connectionListeners;
            synchronized (biConsumerArray) {
                listeners = new BiConsumer[ChannelImpl.this.connectionListeners.size()];
                ChannelImpl.this.connectionListeners.values().toArray(listeners);
            }
            for (BiConsumer listener : listeners) {
                try {
                    listener.accept(ChannelImpl.this, connected);
                }
                catch (Throwable th) {
                    logger.log(Level.WARNING, "Unexpected exception caught when dispatching connection listener event.", th);
                }
            }
        }
    }

    class ConnectionListener
    implements Listener {
        ConnectionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Map map = ChannelImpl.this.connectionListeners;
            synchronized (map) {
                ChannelImpl.this.connectionListeners.remove(this);
            }
        }
    }

    class AccessRightsListener
    implements Listener {
        AccessRightsListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Map map = ChannelImpl.this.accessRightsListeners;
            synchronized (map) {
                ChannelImpl.this.accessRightsListeners.remove(this);
            }
        }
    }

    class AccessRightsStatefullEventSource
    extends StatefullEventSource {
        AccessRightsStatefullEventSource() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispatch() {
            BiConsumer[] listeners;
            AccessRights acr = ChannelImpl.this.getAccessRights();
            BiConsumer[] biConsumerArray = ChannelImpl.this.accessRightsListeners;
            synchronized (biConsumerArray) {
                listeners = new BiConsumer[ChannelImpl.this.accessRightsListeners.size()];
                ChannelImpl.this.accessRightsListeners.values().toArray(listeners);
            }
            for (BiConsumer listener : listeners) {
                try {
                    listener.accept(ChannelImpl.this, acr);
                }
                catch (Throwable th) {
                    logger.log(Level.WARNING, "Unexpected exception caught when dispatching access rights listener event.", th);
                }
            }
        }
    }
}

