/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.Validate;
import org.epics.ca.impl.JavaProcessStreamConsumer;
import org.epics.ca.util.logging.LibraryLogManager;

public class JavaProcessManager {
    private static final Logger logger = LibraryLogManager.getLogger(JavaProcessManager.class);
    private static final File NULL_FILE = new File(System.getProperty("os.name").startsWith("Windows") ? "NUL" : "/dev/null");
    private final Class<?> classWithMainMethod;
    private final String[] programArgs;
    private final Properties systemProperties;
    private final String classPath;
    private Process process;

    public JavaProcessManager(Class<?> classWithMainMethod, Properties systemProperties, String[] programArgs) {
        this.classWithMainMethod = Validate.notNull(classWithMainMethod);
        this.systemProperties = Validate.notNull(systemProperties);
        this.programArgs = Validate.notNull(programArgs);
        String cp = System.getProperty("java.class.path");
        Validate.validState(cp != null);
        Validate.notBlank(cp);
        this.classPath = cp;
        logger.finer("Created JavaProcessManager for class named '" + classWithMainMethod.getName() + "'.");
        logger.finer("The class path is '" + this.classPath + "'.");
        logger.finer("The system properties are: '" + systemProperties.toString() + "'.");
        logger.finer("The program arguments are: '" + Arrays.toString(programArgs) + "'.");
    }

    public boolean start(boolean outputCaptureEnable) {
        logger.fine("Starting a new JVM to run Java class: '" + this.classWithMainMethod.getSimpleName() + "' [output capture = '" + outputCaptureEnable + "']...");
        ArrayList<String> commandLine = new ArrayList<String>(Arrays.asList("java", "-cp", this.classPath));
        Set<String> keys = this.systemProperties.stringPropertyNames();
        logger.finer("There are '" + keys.size() + "' additional system properties.");
        keys.forEach(propName -> {
            String newProperty = "-D" + propName + "=" + this.systemProperties.getProperty((String)propName);
            logger.finer("Adding system property: '" + newProperty + "' to command line.");
            commandLine.add(newProperty);
        });
        commandLine.add(this.classWithMainMethod.getName());
        commandLine.addAll(Arrays.asList(this.programArgs));
        try {
            logger.finer("The new JVM will be started using the command line: '" + commandLine + "'.");
            if (outputCaptureEnable) {
                logger.finest("The output from the process will be captured in the log.");
                this.process = new ProcessBuilder(new String[0]).command(commandLine).start();
                JavaProcessStreamConsumer.consumeFrom(this.process);
            } else {
                logger.finest("The output from the process will NOT be captured in the log.");
                this.process = new ProcessBuilder(new String[0]).command(commandLine).redirectError(ProcessBuilder.Redirect.to(NULL_FILE)).redirectOutput(ProcessBuilder.Redirect.to(NULL_FILE)).redirectInput(ProcessBuilder.Redirect.from(NULL_FILE)).start();
            }
            logger.finest("The process was started OK.");
        }
        catch (IOException | RuntimeException ex) {
            String message = "Failed to run '" + commandLine + "' in separate process.";
            logger.log(Level.WARNING, message, ex);
            return false;
        }
        return this.process.isAlive();
    }

    public boolean shutdown() {
        boolean terminatedOk;
        logger.finer("Attempting to kill the process cooperatively...");
        try {
            this.process.destroy();
        }
        catch (RuntimeException ex) {
            logger.log(Level.WARNING, "Exception when terminating the process cooperatively.", ex);
            return false;
        }
        if (this.process.isAlive()) {
            logger.finer("Attempting to kill the process forcibly...");
            try {
                this.process.destroyForcibly();
            }
            catch (RuntimeException ex) {
                logger.log(Level.WARNING, "Exception when terminating the process forcibly.", ex);
                return false;
            }
        }
        logger.finer("Waiting for process termination...");
        try {
            terminatedOk = this.process.waitFor(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            logger.warning("The process termination wait period was interrupted.");
            return false;
        }
        logger.fine("The process shutdown sequence finished. Result " + (terminatedOk ? "OK." : "FAIL."));
        return terminatedOk;
    }

    public boolean isAlive() {
        if (this.process == null) {
            return false;
        }
        return this.process.isAlive();
    }

    public boolean waitFor(long timeout, TimeUnit timeUnit) throws InterruptedException {
        return this.process.waitFor(timeout, timeUnit);
    }

    public int getExitValue() {
        return this.process.exitValue();
    }
}

