/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.impl;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.epics.ca.impl.LibraryConfiguration;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.EnabledOnOs;
import org.junit.jupiter.api.condition.OS;

class LibraryConfigurationTest {
    LibraryConfigurationTest() {
    }

    @Test
    void testDefaults() {
        LibraryConfiguration instance = LibraryConfiguration.getInstance();
        MatcherAssert.assertThat(instance, Is.is(Matchers.notNullValue()));
        MatcherAssert.assertThat(!instance.isRepeaterEnabled(), Is.is(false));
        MatcherAssert.assertThat(instance.isRepeaterOutputCaptureEnabled(), Is.is(false));
        MatcherAssert.assertThat(instance.getLibraryLogLevel(), Is.is(LibraryConfiguration.CA_LIBRARY_LOG_LEVEL_DEFAULT));
        MatcherAssert.assertThat(instance.getRepeaterLogLevel(), Is.is(LibraryConfiguration.CA_REPEATER_LOG_LEVEL_DEFAULT));
        MatcherAssert.assertThat(instance.getMonitorNotifierImplementation(), Is.is("BlockingQueueMultipleWorkerMonitorNotificationServiceImpl,16"));
    }

    @Test
    void testSystemPropertyOverride() {
        System.setProperty(LibraryConfiguration.PropertyNames.CA_REPEATER_DISABLE.name(), "yes");
        System.setProperty(LibraryConfiguration.PropertyNames.CA_REPEATER_OUTPUT_CAPTURE.name(), "no");
        System.setProperty(LibraryConfiguration.PropertyNames.CA_LIBRARY_LOG_LEVEL.name(), Level.CONFIG.toString());
        System.setProperty(LibraryConfiguration.PropertyNames.CA_REPEATER_LOG_LEVEL.name(), Level.FINER.toString());
        System.setProperty(LibraryConfiguration.PropertyNames.CA_MONITOR_NOTIFIER_IMPL.name(), "someMonitorNotifierEngineImpl");
        LibraryConfiguration instance = LibraryConfiguration.getInstance();
        MatcherAssert.assertThat(instance, Is.is(Matchers.notNullValue()));
        MatcherAssert.assertThat(instance.isRepeaterEnabled(), Is.is(false));
        MatcherAssert.assertThat(instance.isRepeaterOutputCaptureEnabled(), Is.is(false));
        MatcherAssert.assertThat(instance.getLibraryLogLevel(), Is.is(Level.CONFIG));
        MatcherAssert.assertThat(instance.getRepeaterLogLevel(), Is.is(Level.FINER));
        MatcherAssert.assertThat(instance.getMonitorNotifierImplementation(), Is.is("someMonitorNotifierEngineImpl"));
        System.clearProperty(LibraryConfiguration.PropertyNames.CA_REPEATER_DISABLE.name());
        System.clearProperty(LibraryConfiguration.PropertyNames.CA_REPEATER_OUTPUT_CAPTURE.name());
        System.clearProperty(LibraryConfiguration.PropertyNames.CA_LIBRARY_LOG_LEVEL.name());
        System.clearProperty(LibraryConfiguration.PropertyNames.CA_REPEATER_LOG_LEVEL.name());
        System.clearProperty(LibraryConfiguration.PropertyNames.CA_MONITOR_NOTIFIER_IMPL.name());
    }

    @EnabledOnOs(value={OS.MAC, OS.LINUX})
    @Test
    void testEnvironmentalVariablesOverrides() throws Exception {
        HashMap<String, String> envMap = new HashMap<String, String>();
        envMap.put(LibraryConfiguration.PropertyNames.CA_LIBRARY_LOG_LEVEL.name(), Level.ALL.toString());
        envMap.put(LibraryConfiguration.PropertyNames.CA_MONITOR_NOTIFIER_IMPL.name(), "someOtherMonitorNotifierEngineImpl");
        LibraryConfigurationTest.setEnv(envMap);
        System.setProperty(LibraryConfiguration.PropertyNames.CA_LIBRARY_LOG_LEVEL.name(), Level.OFF.toString());
        LibraryConfiguration instance = LibraryConfiguration.getInstance();
        MatcherAssert.assertThat(instance, Is.is(Matchers.notNullValue()));
        MatcherAssert.assertThat(instance.getLibraryLogLevel(), Is.is(Level.OFF));
        MatcherAssert.assertThat(instance.getMonitorNotifierImplementation(), Is.is("someOtherMonitorNotifierEngineImpl"));
        envMap.clear();
        LibraryConfigurationTest.setEnv(envMap);
        System.clearProperty(LibraryConfiguration.PropertyNames.CA_LIBRARY_LOG_LEVEL.name());
    }

    private static void setEnv(Map<String, String> newenv) throws Exception {
        try {
            Class<?> processEnvironmentClass = Class.forName("java.lang.ProcessEnvironment");
            Field theEnvironmentField = processEnvironmentClass.getDeclaredField("theEnvironment");
            theEnvironmentField.setAccessible(true);
            Map env = (Map)theEnvironmentField.get(null);
            env.putAll(newenv);
            Field theCaseInsensitiveEnvironmentField = processEnvironmentClass.getDeclaredField("theCaseInsensitiveEnvironment");
            theCaseInsensitiveEnvironmentField.setAccessible(true);
            Map cienv = (Map)theCaseInsensitiveEnvironmentField.get(null);
            cienv.putAll(newenv);
        }
        catch (NoSuchFieldException e) {
            Class<?>[] classes = Collections.class.getDeclaredClasses();
            Map<String, String> env = System.getenv();
            for (Class<?> cl : classes) {
                if (!"java.util.Collections$UnmodifiableMap".equals(cl.getName())) continue;
                Field field = cl.getDeclaredField("m");
                field.setAccessible(true);
                Object obj = field.get(env);
                Map map = (Map)obj;
                map.clear();
                map.putAll(newenv);
            }
        }
    }
}

