/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.impl.repeater;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.Validate;
import org.epics.ca.impl.repeater.CARepeaterMessage;
import org.epics.ca.impl.repeater.NetworkUtilities;
import org.epics.ca.impl.repeater.UdpSocketUtilities;
import org.epics.ca.util.logging.LibraryLogManager;

class CARepeaterClientProxy
implements AutoCloseable {
    private static final Logger logger = LibraryLogManager.getLogger(CARepeaterClientProxy.class);
    private final InetSocketAddress clientListeningSocketAddress;
    private final DatagramSocket senderSocket;
    private static final boolean SEND_SOCKET_LAZY_BIND = true;

    CARepeaterClientProxy(InetSocketAddress clientListeningSocketAddress) throws SocketException {
        Validate.notNull(clientListeningSocketAddress, "The 'clientListeningSocketAddress' argument was null.", new Object[0]);
        InetAddress inetAddress = clientListeningSocketAddress.getAddress();
        Validate.isTrue(NetworkUtilities.isThisMyIpAddress(inetAddress), "The 'clientListeningSocketAddress' specified a socket which was not local ('" + inetAddress + "').", new Object[0]);
        logger.finest("Creating new CA Repeater Client Proxy for client socket with listening address: '" + clientListeningSocketAddress + "'...");
        this.clientListeningSocketAddress = clientListeningSocketAddress;
        logger.finest("The sending socket will be bound later.");
        this.senderSocket = UdpSocketUtilities.createUnboundSendSocket();
        logger.finest("The sending socket will be connected to the client listening at address: " + clientListeningSocketAddress);
        this.senderSocket.connect(this.clientListeningSocketAddress);
    }

    @Override
    public void close() {
        logger.finest("Closing CA Repeater client sending socket: " + this.clientListeningSocketAddress);
        this.senderSocket.close();
    }

    InetSocketAddress getClientListeningSocketAddress() {
        return this.clientListeningSocketAddress;
    }

    boolean sendCaRepeaterConfirmMessage(InetAddress repeaterAddress) {
        Validate.notNull(repeaterAddress);
        logger.finest("Sending CA_REPEATER_CONFIRM to client listening at socket address: " + this.clientListeningSocketAddress);
        DatagramPacket packet = CARepeaterMessage.createRepeaterConfirmMessage(repeaterAddress);
        return this.sendDatagram(packet);
    }

    boolean sendCaServerBeaconMessage(short serverProtocolMinorVersion, short serverTcpListeningPort, int serverBeaconId, InetAddress serverAddress) {
        Validate.notNull(serverAddress);
        logger.finest("Sending CA_RSRV_IS_UP (Beacon message) to client listening at socket address: " + this.clientListeningSocketAddress);
        DatagramPacket packet = CARepeaterMessage.createBeaconMessage(serverProtocolMinorVersion, serverTcpListeningPort, serverBeaconId, serverAddress);
        return this.sendDatagram(packet);
    }

    boolean sendCaVersionMessage() {
        logger.finest("Sending CA_PROTO_VERSION to client listening at socket address: " + this.clientListeningSocketAddress);
        DatagramPacket packet = CARepeaterMessage.createVersionMessage();
        return this.sendDatagram(packet);
    }

    boolean sendDatagram(DatagramPacket packet) {
        Validate.notNull(packet, "The 'packet' argument was null.", new Object[0]);
        Validate.isTrue(packet.getPort() == -1, "The datagram port should not be configured.", new Object[0]);
        Validate.isTrue(packet.getAddress() == null, "The datagram inet address should not be configured.", new Object[0]);
        try {
            logger.finest("Setting datagram destination socket address to " + this.clientListeningSocketAddress);
            DatagramPacket sendPacket = new DatagramPacket(packet.getData(), packet.getLength(), this.clientListeningSocketAddress);
            logger.finest("Sending datagram packet to: " + this.clientListeningSocketAddress);
            this.senderSocket.send(sendPacket);
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Failed to send datagram packet to: " + this.clientListeningSocketAddress, ex);
            return false;
        }
        return true;
    }

    boolean isClientDead() {
        logger.finest("Checking whether client is alive at address: " + this.clientListeningSocketAddress);
        return CARepeaterClientProxy.isClientDead(this.clientListeningSocketAddress);
    }

    static boolean isClientDead(InetSocketAddress socketAddress) {
        logger.finest("Checking whether the CA Repeater client at address '" + socketAddress + " is alive.");
        logger.finest("Checking socket availability for address: " + socketAddress + ".");
        if (UdpSocketUtilities.isSocketAvailable(socketAddress)) {
            logger.finest("The socket is available => the client appears to be DEAD !");
            return true;
        }
        logger.finest("The socket is NOT available => the client appears to be ALIVE !");
        return false;
    }
}

