/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.impl.repeater;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.logging.Logger;
import org.epics.ca.ThreadWatcher;
import org.epics.ca.impl.repeater.CARepeaterClientProxy;
import org.epics.ca.impl.repeater.CARepeaterMessage;
import org.epics.ca.impl.repeater.NetworkUtilities;
import org.epics.ca.impl.repeater.UdpSocketReceiver;
import org.epics.ca.impl.repeater.UdpSocketUtilities;
import org.epics.ca.util.logging.LibraryLogManager;
import org.epics.ca.util.net.InetAddressUtil;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class CARepeaterClientProxyTest {
    private static final Logger logger = LibraryLogManager.getLogger(CARepeaterClientProxyTest.class);
    private ThreadWatcher threadWatcher;

    CARepeaterClientProxyTest() {
    }

    @BeforeAll
    static void beforeAll() {
        MatcherAssert.assertThat(NetworkUtilities.verifyTargetPlatformNetworkStackIsChannelAccessCompatible(), Is.is(true));
        if (NetworkUtilities.isVpnActive()) {
            Assertions.fail("This test is not supported when a VPN connection is active on the local network interface.");
        }
    }

    @BeforeEach
    void beforeEach() {
        this.threadWatcher = ThreadWatcher.start();
    }

    @AfterEach
    void afterEach() {
        this.threadWatcher.verify();
    }

    @Test
    void testConstructor_nullArgument_throwsNullPointerException() {
        NullPointerException throwable = Assertions.assertThrows(NullPointerException.class, () -> new CARepeaterClientProxy(null));
        MatcherAssert.assertThat(((Throwable)throwable).getMessage(), Matchers.containsString("The 'clientListeningSocketAddress' argument was null."));
    }

    @Test
    void testConstructor_localAddressDoesNotThrowException() {
        InetSocketAddress nonLocalAddress = new InetSocketAddress("localhost", 1234);
        Assertions.assertDoesNotThrow(() -> new CARepeaterClientProxy(nonLocalAddress));
    }

    @Test
    void testConstructor_loopbackIpDoesNotThrowException() {
        InetSocketAddress nonLocalAddress = new InetSocketAddress("127.0.0.1", 1234);
        Assertions.assertDoesNotThrow(() -> new CARepeaterClientProxy(nonLocalAddress).close());
    }

    @Test
    void testConstructor_wildcardAddressDoesNotThrowException() {
        InetSocketAddress wildcardAddress = new InetSocketAddress(1234);
        Assertions.assertDoesNotThrow(() -> new CARepeaterClientProxy(wildcardAddress).close());
    }

    @Test
    void testConstructor_ephemeralPortDoesNotThrowException() {
        InetSocketAddress nonLocalAddress = new InetSocketAddress(0);
        Assertions.assertDoesNotThrow(() -> new CARepeaterClientProxy(nonLocalAddress).close());
    }

    @Test
    void testSendUdpPacket_throwsIllegalArgumentException_whenDatagramPortIsConfigured() throws SocketException {
        try (CARepeaterClientProxy proxy = new CARepeaterClientProxy(new InetSocketAddress(0));){
            DatagramPacket datagramPacketWithShouldNotBeConfiguredPort = new DatagramPacket(new byte[0], 0);
            datagramPacketWithShouldNotBeConfiguredPort.setPort(1234);
            IllegalArgumentException throwable = Assertions.assertThrows(IllegalArgumentException.class, () -> proxy.sendDatagram(datagramPacketWithShouldNotBeConfiguredPort));
            MatcherAssert.assertThat(throwable.getMessage(), Is.is("The datagram port should not be configured."));
        }
    }

    @Test
    void testSendUdpPacket_throwsIllegalArgumentException_whenDatagramInetAddressIsConfigured() throws SocketException {
        try (CARepeaterClientProxy proxy = new CARepeaterClientProxy(new InetSocketAddress(0));){
            DatagramPacket datagramPacketWithShouldNotBeConfiguredAddress = new DatagramPacket(new byte[0], 0);
            datagramPacketWithShouldNotBeConfiguredAddress.setAddress(InetAddress.getLoopbackAddress());
            IllegalArgumentException throwable = Assertions.assertThrows(IllegalArgumentException.class, () -> proxy.sendDatagram(datagramPacketWithShouldNotBeConfiguredAddress));
            MatcherAssert.assertThat(throwable.getMessage(), Is.is("The datagram inet address should not be configured."));
        }
    }

    @Test
    void testSendCaBeaconMessage_throwsNullPointerException_whenServerAddressNull() throws SocketException, UnknownHostException {
        try (CARepeaterClientProxy proxy = new CARepeaterClientProxy(new InetSocketAddress(InetAddress.getLocalHost(), 3333));){
            NullPointerException throwable = Assertions.assertThrows(NullPointerException.class, () -> proxy.sendCaServerBeaconMessage((short)99, (short)4444, 305419896, null));
            MatcherAssert.assertThat(((Throwable)throwable).getMessage(), Is.is("The validated object is null"));
        }
    }

    @Test
    void integrationTestSendCaVersionMessage() throws SocketException {
        try (UdpSocketReceiver receiver = UdpSocketReceiver.startListening(31245);){
            try (CARepeaterClientProxy proxy = new CARepeaterClientProxy(new InetSocketAddress(InetAddress.getLoopbackAddress(), 31245));){
                logger.info("About to send...");
                proxy.sendCaVersionMessage();
                logger.info("Sent.");
            }
            DatagramPacket receivePacket = receiver.getDatagram();
            MatcherAssert.assertThat(receivePacket.getLength(), Is.is(16));
            ByteBuffer byteBuffer = ByteBuffer.wrap(receivePacket.getData());
            byteBuffer.limit(receivePacket.getLength());
            MatcherAssert.assertThat(byteBuffer.getShort(CARepeaterMessage.CaHeaderOffsets.CA_HDR_SHORT_COMMAND_OFFSET.value), Is.is(CARepeaterMessage.CaCommandCodes.CA_PROTO_VERSION.value));
            MatcherAssert.assertThat(byteBuffer.getShort(CARepeaterMessage.CaVersionMessageOffsets.CA_HDR_SHORT_VERSION_MSG_UNUSED1_OFFSET.value), Is.is((short)0));
            MatcherAssert.assertThat(byteBuffer.getShort(CARepeaterMessage.CaVersionMessageOffsets.CA_HDR_SHORT_VERSION_MSG_PRIORITY_OFFSET.value), Is.is((short)0));
            MatcherAssert.assertThat(byteBuffer.getShort(CARepeaterMessage.CaVersionMessageOffsets.CA_HDR_SHORT_VERSION_MSG_UNUSED_TCP_MINOR_VERSION_OFFSET.value), Is.is((short)0));
            MatcherAssert.assertThat(byteBuffer.getInt(CARepeaterMessage.CaVersionMessageOffsets.CA_HDR_INT_VERSION_MSG_UNUSED2_OFFSET.value), Is.is(0));
            MatcherAssert.assertThat(byteBuffer.getInt(CARepeaterMessage.CaVersionMessageOffsets.CA_HDR_INT_VERSION_MSG_UNUSED3_OFFSET.value), Is.is(0));
        }
    }

    @Test
    void integrationTestSendCaBeaconMessage() throws SocketException, UnknownHostException {
        try (UdpSocketReceiver receiver = UdpSocketReceiver.startListening(31246);){
            try (CARepeaterClientProxy proxy = new CARepeaterClientProxy(new InetSocketAddress(InetAddress.getLoopbackAddress(), 31246));){
                logger.info("About to send...");
                proxy.sendCaServerBeaconMessage((short)99, (short)4444, 305419896, InetAddress.getByAddress(new byte[]{-86, -69, -52, -35}));
                logger.info("Sent !");
            }
            DatagramPacket receivePacket = receiver.getDatagram();
            MatcherAssert.assertThat(receivePacket.getLength(), Is.is(16));
            ByteBuffer byteBuffer = ByteBuffer.wrap(receivePacket.getData());
            byteBuffer.limit(receivePacket.getLength());
            MatcherAssert.assertThat(byteBuffer.getShort(CARepeaterMessage.CaHeaderOffsets.CA_HDR_SHORT_COMMAND_OFFSET.value), Is.is(CARepeaterMessage.CaCommandCodes.CA_PROTO_RSRV_IS_UP.value));
            MatcherAssert.assertThat(byteBuffer.getShort(CARepeaterMessage.CaBeaconMessageOffsets.CA_HDR_SHORT_BEACON_MSG_UNUSED_OFFSET.value), Is.is((short)0));
            MatcherAssert.assertThat(byteBuffer.getShort(CARepeaterMessage.CaBeaconMessageOffsets.CA_HDR_SHORT_BEACON_MSG_SERVER_PROTOCOL_MINOR_VERSION_OFFSET.value), Is.is((short)99));
            MatcherAssert.assertThat(byteBuffer.getShort(CARepeaterMessage.CaBeaconMessageOffsets.CA_HDR_SHORT_BEACON_MSG_SERVER_TCP_LISTENING_PORT_OFFSET.value), Is.is((short)4444));
            MatcherAssert.assertThat(byteBuffer.getInt(CARepeaterMessage.CaBeaconMessageOffsets.CA_HDR_INT_BEACON_MSG_SERVER_BEACON_ID_OFFSET.value), Is.is(305419896));
            MatcherAssert.assertThat(byteBuffer.getInt(CARepeaterMessage.CaBeaconMessageOffsets.CA_HDR_INT_BEACON_MSG_SERVER_ADDR_OFFSET.value), Is.is(-1430532899));
        }
    }

    @Test
    void integrationTestSendRepeaterConfirmMessage() throws SocketException {
        try (UdpSocketReceiver receiver = UdpSocketReceiver.startListening(31247);){
            try (CARepeaterClientProxy proxy = new CARepeaterClientProxy(new InetSocketAddress(InetAddress.getLoopbackAddress(), 31247));){
                logger.info("About to send...");
                proxy.sendCaRepeaterConfirmMessage(InetAddress.getLoopbackAddress());
                logger.info("Sent.");
            }
            DatagramPacket receivePacket = receiver.getDatagram();
            MatcherAssert.assertThat(receivePacket.getLength(), Is.is(16));
            ByteBuffer byteBuffer = ByteBuffer.wrap(receivePacket.getData());
            byteBuffer.limit(receivePacket.getLength());
            MatcherAssert.assertThat(byteBuffer.getShort(CARepeaterMessage.CaRepeaterConfirmMessageOffsets.CA_HDR_SHORT_REPEATER_CONFIRM_MSG_COMMAND_OFFSET.value), Is.is(CARepeaterMessage.CaCommandCodes.CA_REPEATER_CONFIRM.value));
            MatcherAssert.assertThat(byteBuffer.getShort(CARepeaterMessage.CaRepeaterConfirmMessageOffsets.CA_HDR_SHORT_REPEATER_CONFIRM_MSG_UNUSED1_OFFSET.value), Is.is((short)0));
            MatcherAssert.assertThat(byteBuffer.getShort(CARepeaterMessage.CaRepeaterConfirmMessageOffsets.CA_HDR_SHORT_REPEATER_CONFIRM_MSG_UNUSED2_OFFSET.value), Is.is((short)0));
            MatcherAssert.assertThat(byteBuffer.getShort(CARepeaterMessage.CaRepeaterConfirmMessageOffsets.CA_HDR_SHORT_REPEATER_CONFIRM_MSG_UNUSED3_OFFSET.value), Is.is((short)0));
            MatcherAssert.assertThat(byteBuffer.getInt(CARepeaterMessage.CaRepeaterConfirmMessageOffsets.CA_HDR_INT_REPEATER_CONFIRM_MSG_UNUSED4_OFFSET.value), Is.is(0));
            InetAddress caRepeaterInetAddressAsInteger = InetAddressUtil.intToIPv4Address(byteBuffer.getInt(CARepeaterMessage.CaRepeaterConfirmMessageOffsets.CA_HDR_INT_REPEATER_CONFIRM_MSG_REPEATER_ADDR_OFFSET.value));
            MatcherAssert.assertThat(NetworkUtilities.isThisMyIpAddress(caRepeaterInetAddressAsInteger), Is.is(true));
        }
    }

    @Test
    void testIsClientDead() throws SocketException {
        try (DatagramSocket caRepeaterClientListener = UdpSocketUtilities.createBroadcastAwareListeningSocket(1111, false);
             CARepeaterClientProxy proxyToClientWhichIsAlive = new CARepeaterClientProxy(new InetSocketAddress(1111));
             CARepeaterClientProxy proxyToClientWhichIsDead = new CARepeaterClientProxy(new InetSocketAddress(1112));){
            MatcherAssert.assertThat(proxyToClientWhichIsAlive.isClientDead(), Is.is(false));
            MatcherAssert.assertThat(proxyToClientWhichIsDead.isClientDead(), Is.is(true));
        }
        var2_2 = null;
        try (CARepeaterClientProxy proxyToGoneAwayClient = new CARepeaterClientProxy(new InetSocketAddress(1111));){
            MatcherAssert.assertThat(proxyToGoneAwayClient.isClientDead(), Is.is(true));
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
    }
}

