/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.impl.repeater;

import java.util.logging.Logger;
import org.epics.ca.ThreadWatcher;
import org.epics.ca.impl.repeater.CARepeaterServiceInstance;
import org.epics.ca.impl.repeater.CARepeaterStatusChecker;
import org.epics.ca.impl.repeater.NetworkUtilities;
import org.epics.ca.util.logging.LibraryLogManager;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class CARepeaterServiceInstanceTest {
    private static final int TEST_PORT = 47952;
    private static final Logger logger = LibraryLogManager.getLogger(CARepeaterServiceInstanceTest.class);
    private ThreadWatcher threadWatcher;

    @BeforeAll
    static void beforeAll() {
        MatcherAssert.assertThat(NetworkUtilities.verifyTargetPlatformNetworkStackIsChannelAccessCompatible(), Is.is(true));
        if (NetworkUtilities.isVpnActive()) {
            Assertions.fail("This test is not supported when a VPN connection is active on the local network interface.");
        }
    }

    @BeforeEach
    void beforeEach() {
        this.threadWatcher = ThreadWatcher.start();
        MatcherAssert.assertThat(CARepeaterStatusChecker.isRepeaterRunning(47952), Is.is(false));
    }

    @AfterEach
    void afterEach() {
        MatcherAssert.assertThat(CARepeaterStatusChecker.verifyRepeaterStops(47952), Is.is(true));
        Assertions.assertDoesNotThrow(() -> this.threadWatcher.verify(), "Thread leak detected !");
    }

    @Test
    void doNothing() {
    }

    @Test
    void testActivateAndShutdown() {
        logger.info("Activating a new CA Repeater instance..");
        CARepeaterServiceInstance instance = new CARepeaterServiceInstance(47952);
        instance.activate();
        logger.info("OK");
        logger.info("Verifying that the CA Repeater process is reported as being alive...");
        MatcherAssert.assertThat(instance.isProcessAlive(), Is.is(true));
        logger.info("OK");
        logger.info("Verifying that the CA Repeater starts running...");
        MatcherAssert.assertThat(CARepeaterStatusChecker.verifyRepeaterStarts(47952), Is.is(true));
        logger.info("OK");
        logger.info("Shutting down the CA Repeater process...");
        instance.shutdown();
        logger.info("OK");
        logger.info("Verifying that the CA Repeater process is no longer reported as being alive...");
        MatcherAssert.assertThat(instance.isProcessAlive(), Is.is(false));
        logger.info("OK");
        logger.info("Verifying that the CA Repeater shuts down...");
        MatcherAssert.assertThat(CARepeaterStatusChecker.verifyRepeaterStops(47952), Is.is(true));
        logger.info("OK");
    }

    @Test
    void testShutdownWithoutPreviousActivateThrowsException() {
        CARepeaterServiceInstance instance = new CARepeaterServiceInstance(47952);
        IllegalStateException throwable = Assertions.assertThrows(IllegalStateException.class, instance::shutdown);
        MatcherAssert.assertThat(throwable.getMessage(), Is.is("This service instance was not previously activated."));
    }

    @Test
    void testActivateTwiceThrowsException() {
        CARepeaterServiceInstance instance = new CARepeaterServiceInstance(47952);
        instance.activate();
        MatcherAssert.assertThat(CARepeaterStatusChecker.verifyRepeaterStarts(47952), Is.is(true));
        IllegalStateException throwable = Assertions.assertThrows(IllegalStateException.class, instance::activate);
        MatcherAssert.assertThat(throwable.getMessage(), Is.is("This service instance was already activated."));
        instance.shutdown();
        MatcherAssert.assertThat(CARepeaterStatusChecker.verifyRepeaterStops(47952), Is.is(true));
    }

    @Test
    void testShutdownTwiceThrowsException() {
        CARepeaterServiceInstance instance = new CARepeaterServiceInstance(47952);
        instance.activate();
        MatcherAssert.assertThat(CARepeaterStatusChecker.verifyRepeaterStarts(47952), Is.is(true));
        instance.shutdown();
        MatcherAssert.assertThat(CARepeaterStatusChecker.verifyRepeaterStops(47952), Is.is(true));
        IllegalStateException throwable = Assertions.assertThrows(IllegalStateException.class, instance::shutdown);
        MatcherAssert.assertThat(throwable.getMessage(), Is.is("This service instance was already shut down."));
    }
}

