/*
 * Decompiled with CFR 0.152.
 */
package org.epics.ca.impl.repeater;

import java.util.logging.Logger;
import org.epics.ca.ThreadWatcher;
import org.epics.ca.impl.repeater.CARepeaterServiceManager;
import org.epics.ca.impl.repeater.CARepeaterStatusChecker;
import org.epics.ca.impl.repeater.NetworkUtilities;
import org.epics.ca.util.logging.LibraryLogManager;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class CARepeaterServiceManagerTest {
    private static final int TEST_PORT_1 = 45783;
    private static final int TEST_PORT_2 = 45787;
    private static final int TEST_PORT_3 = 45789;
    private static final Logger logger = LibraryLogManager.getLogger(CARepeaterServiceManagerTest.class);
    private ThreadWatcher threadWatcher;

    @BeforeAll
    static void beforeAll() {
        MatcherAssert.assertThat(NetworkUtilities.verifyTargetPlatformNetworkStackIsChannelAccessCompatible(), Is.is(true));
        if (NetworkUtilities.isVpnActive()) {
            Assertions.fail("This test is not supported when a VPN connection is active on the local network interface.");
        }
    }

    @BeforeEach
    void beforeEach() {
        this.threadWatcher = ThreadWatcher.start();
        MatcherAssert.assertThat(CARepeaterStatusChecker.isRepeaterRunning(45783), Is.is(false));
        MatcherAssert.assertThat(CARepeaterStatusChecker.isRepeaterRunning(45787), Is.is(false));
        MatcherAssert.assertThat(CARepeaterStatusChecker.isRepeaterRunning(45789), Is.is(false));
    }

    @AfterEach
    void afterEach() {
        MatcherAssert.assertThat(CARepeaterStatusChecker.verifyRepeaterStops(45783), Is.is(true));
        MatcherAssert.assertThat(CARepeaterStatusChecker.verifyRepeaterStops(45787), Is.is(true));
        MatcherAssert.assertThat(CARepeaterStatusChecker.verifyRepeaterStops(45789), Is.is(true));
        Assertions.assertDoesNotThrow(() -> this.threadWatcher.verify(), "Thread leak detected !");
    }

    @Test
    void testCARepeaterServiceManager_requestAndCancelService() {
        CARepeaterServiceManager caRepeaterServiceManager = new CARepeaterServiceManager();
        caRepeaterServiceManager.requestServiceOnPort(45783);
        MatcherAssert.assertThat(caRepeaterServiceManager.getServiceInstances(), Is.is(1));
        MatcherAssert.assertThat(CARepeaterStatusChecker.verifyRepeaterStarts(45783), Is.is(true));
        caRepeaterServiceManager.cancelServiceRequestOnPort(45783);
        MatcherAssert.assertThat(caRepeaterServiceManager.getServiceInstances(), Is.is(0));
        MatcherAssert.assertThat(CARepeaterStatusChecker.verifyRepeaterStops(45783), Is.is(true));
    }

    @Test
    void testCARepeaterServiceManager_requestAndCancelServiceTwiceOnSamePort() {
        CARepeaterServiceManager caRepeaterServiceManager = new CARepeaterServiceManager();
        MatcherAssert.assertThat(caRepeaterServiceManager.getServiceInstances(), Is.is(0));
        caRepeaterServiceManager.requestServiceOnPort(45783);
        MatcherAssert.assertThat(caRepeaterServiceManager.getServiceInstances(), Is.is(1));
        MatcherAssert.assertThat(CARepeaterStatusChecker.verifyRepeaterStarts(45783), Is.is(true));
        caRepeaterServiceManager.requestServiceOnPort(45783);
        MatcherAssert.assertThat(caRepeaterServiceManager.getServiceInstances(), Is.is(1));
        MatcherAssert.assertThat(CARepeaterStatusChecker.isRepeaterRunning(45783), Is.is(true));
        caRepeaterServiceManager.cancelServiceRequestOnPort(45783);
        MatcherAssert.assertThat(caRepeaterServiceManager.getServiceInstances(), Is.is(1));
        MatcherAssert.assertThat(CARepeaterStatusChecker.isRepeaterRunning(45783), Is.is(true));
        caRepeaterServiceManager.cancelServiceRequestOnPort(45783);
        MatcherAssert.assertThat(caRepeaterServiceManager.getServiceInstances(), Is.is(0));
        MatcherAssert.assertThat(CARepeaterStatusChecker.verifyRepeaterStops(45783), Is.is(true));
    }

    @Test
    void testCARepeaterServiceManager_requestAndCancelServiceOnDifferentPorts() {
        CARepeaterServiceManager caRepeaterServiceManager = new CARepeaterServiceManager();
        MatcherAssert.assertThat(caRepeaterServiceManager.getServiceInstances(), Is.is(0));
        caRepeaterServiceManager.requestServiceOnPort(45783);
        MatcherAssert.assertThat(caRepeaterServiceManager.getServiceInstances(), Is.is(1));
        MatcherAssert.assertThat(CARepeaterStatusChecker.verifyRepeaterStarts(45783), Is.is(true));
        caRepeaterServiceManager.requestServiceOnPort(45787);
        MatcherAssert.assertThat(caRepeaterServiceManager.getServiceInstances(), Is.is(2));
        MatcherAssert.assertThat(CARepeaterStatusChecker.isRepeaterRunning(45783), Is.is(true));
        MatcherAssert.assertThat(CARepeaterStatusChecker.verifyRepeaterStarts(45787), Is.is(true));
        caRepeaterServiceManager.cancelServiceRequestOnPort(45789);
        MatcherAssert.assertThat(caRepeaterServiceManager.getServiceInstances(), Is.is(2));
        MatcherAssert.assertThat(CARepeaterStatusChecker.isRepeaterRunning(45783), Is.is(true));
        MatcherAssert.assertThat(CARepeaterStatusChecker.isRepeaterRunning(45787), Is.is(true));
        caRepeaterServiceManager.cancelServiceRequestOnPort(45783);
        MatcherAssert.assertThat(caRepeaterServiceManager.getServiceInstances(), Is.is(1));
        MatcherAssert.assertThat(CARepeaterStatusChecker.verifyRepeaterStops(45783), Is.is(true));
        MatcherAssert.assertThat(CARepeaterStatusChecker.isRepeaterRunning(45787), Is.is(true));
        caRepeaterServiceManager.cancelServiceRequestOnPort(45787);
        MatcherAssert.assertThat(caRepeaterServiceManager.getServiceInstances(), Is.is(0));
        MatcherAssert.assertThat(CARepeaterStatusChecker.verifyRepeaterStops(45787), Is.is(true));
    }
}

